/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.schedule;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hdm.business.domain.service.hrpi.IHRPIService;
import kd.hr.hdm.business.reg.domain.service.bill.IRegBillService;
import kd.sdk.hr.hspm.common.utils.QFilterUtil;

public class RegOrgUpgradeTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(RegOrgUpgradeTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("RegOrgUpgradeTask start ...");
        this.upgrade();
        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        scheduleManager.disableJob("3YYLWE0E0V77");
        scheduleManager.disableSchedule("3YYMGPNZCKNO");
        LOGGER.info("RegOrgUpgradeTask end ...");
    }

    private void upgrade() {
        QFilter filter = new QFilter("baffiliateadminorg", "=", (Object)0L);
        DynamicObject[] queryResults = IRegBillService.getInstance().query("cmpemp,badminorg,baffiliateadminorg,ermanfile,laborreltype,bdependencytype,org,bempgroup,person,billstatus,auditstatus,bhrbu,mid", new QFilter[]{filter});
        HashSet ermanFileIds = Sets.newHashSetWithExpectedSize((int)queryResults.length);
        HashSet midFileIds = Sets.newHashSetWithExpectedSize((int)queryResults.length);
        Stream.of(queryResults).forEach(dy -> {
            ermanFileIds.add(dy.getLong("ermanfile.id"));
            midFileIds.add(dy.getLong("mid"));
        });
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hdm_batchregbill");
        DynamicObject[] batchStatusDys = serviceHelper.query("id,auditstatus,billstatus", new QFilter[]{new QFilter("id", "in", (Object)midFileIds)});
        HashMap batchStatusMap = Maps.newHashMapWithExpectedSize((int)batchStatusDys.length);
        for (DynamicObject batchStatusDy : batchStatusDys) {
            batchStatusMap.put(batchStatusDy.getLong("id"), batchStatusDy);
        }
        String properties = "id,name,org,affiliateadminorg,empgroup,empposrel,person,employee,cmpemp,dependencytype,empentrel";
        QFilter qFilter = new QFilter("id", "in", (Object)ermanFileIds);
        qFilter.and(QFilterUtil.getInitStatusFinish());
        DynamicObject[] ermanFileDys = IHRPIService.getInstance().listFieldsFilterInfo(properties, qFilter, "hspm_ermanfile");
        HashMap ermanFileInfoMap = Maps.newHashMapWithExpectedSize((int)ermanFileDys.length);
        for (DynamicObject ermanFileDy : ermanFileDys) {
            ermanFileInfoMap.put(ermanFileDy.getLong("id"), ermanFileDy);
        }
        for (DynamicObject queryResult : queryResults) {
            long ermanFileId = queryResult.getLong("ermanfile.id");
            DynamicObject ermanFileInfo = (DynamicObject)ermanFileInfoMap.get(ermanFileId);
            if (HRObjectUtils.isEmpty((Object)ermanFileInfo)) continue;
            queryResult.set("bdependencytype", ermanFileInfo.get("dependencytype"));
            queryResult.set("laborreltype", ermanFileInfo.get("empentrel.laborreltype"));
            queryResult.set("bhrbu", ermanFileInfo.get("org"));
            queryResult.set("baffiliateadminorg", ermanFileInfo.get("affiliateadminorg"));
            queryResult.set("bempgroup", ermanFileInfo.get("empgroup"));
            queryResult.set("badminorg", ermanFileInfo.get("empposrel.adminorg"));
            queryResult.set("person", ermanFileInfo.get("person"));
            queryResult.set("cmpemp", ermanFileInfo.get("cmpemp.managingscope"));
            long mid = queryResult.getLong("mid");
            DynamicObject batchStatusDy = (DynamicObject)batchStatusMap.get(mid);
            queryResult.set("billstatus", batchStatusDy.get("billstatus"));
            queryResult.set("auditstatus", batchStatusDy.get("auditstatus"));
        }
        IRegBillService.getInstance().update(queryResults);
    }
}

