/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.schedule;

import com.google.common.collect.Maps;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hdm.business.reg.RegDetailInfoHelper;
import kd.hr.hdm.business.reg.domain.repository.database.RegProcessRepository;
import kd.hr.hdm.business.reg.domain.repository.database.RegTraceRepository;
import kd.hr.hdm.business.reg.domain.service.bill.IRegBillService;
import kd.hr.hdm.common.reg.enums.RegBusinessStatusEnum;

public class RegOverDueTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(RegOverDueTask.class);
    private static final String REG_SELECT_PROPERTIES = "preactualdate,bemployee";
    private static final String REG_TRACE_SELECT_PROPERTIES = "bemployee,createtime";
    private static final String REG_PROCESS_SELECT_PROPERTIES = "bemployee,isoverdue";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("RegOverDueTask start ...");
        DynamicObject[] regBillDynamicObjects = this.queryRegBill();
        if (regBillDynamicObjects != null && regBillDynamicObjects.length > 0) {
            HashMap preActualDateMap = Maps.newHashMapWithExpectedSize((int)regBillDynamicObjects.length);
            for (DynamicObject dynamicObject : regBillDynamicObjects) {
                long employeeId = dynamicObject.getLong("bemployee.id");
                String preActualDate = dynamicObject.getString("preactualdate");
                if (preActualDate == null) continue;
                preActualDateMap.put(employeeId, preActualDate);
            }
            this.validateOverDue(preActualDateMap);
        }
        RegDetailInfoHelper.getInstance().setSchedule("36NIFIHVSZ2R");
        LOGGER.info("RegOverDueTask end ...");
    }

    private void validateOverDue(Map<Long, String> preActualDateMap) {
        ArrayList<Long> employeeIdList = new ArrayList<Long>(preActualDateMap.keySet());
        QFilter employeeFilter = new QFilter("bemployee", "in", employeeIdList);
        QFilter typeFilter = new QFilter("type", "=", (Object)"1070");
        DynamicObject[] regTraceObjects = RegTraceRepository.getInstance().query(REG_TRACE_SELECT_PROPERTIES, new QFilter[]{employeeFilter, typeFilter});
        if (regTraceObjects == null) {
            throw new KDBizException(" query reg trace exception");
        }
        ArrayList<Long> overDueEmployeeList = new ArrayList<Long>();
        for (DynamicObject dynamicObject : regTraceObjects) {
            long employeeId = dynamicObject.getLong("bemployee.id");
            String preActualDateStr = preActualDateMap.get(employeeId);
            if (preActualDateStr == null) continue;
            String createTimeStr = dynamicObject.getString("createtime");
            try {
                Date createTime = HRDateTimeUtils.parseDate((String)createTimeStr, (String)"yyyy-MM-dd");
                Date preActualDate = HRDateTimeUtils.parseDate((String)preActualDateStr, (String)"yyyy-MM-dd");
                boolean isBefore = HRDateTimeUtils.dayBefore((Date)preActualDate, (Date)createTime);
                if (!isBefore) continue;
                overDueEmployeeList.add(employeeId);
            }
            catch (ParseException e) {
                LOGGER.error("createTime,preActualDate parse error", (Throwable)e);
                throw new KDBizException("createTime,preActualDate parse exception");
            }
        }
        if (overDueEmployeeList.size() > 0) {
            this.updateOverDue(overDueEmployeeList);
        }
    }

    private void updateOverDue(List<Long> overDueEmployeeList) {
        QFilter employeeFilter = new QFilter("bemployee", "in", overDueEmployeeList);
        DynamicObject[] regProcessObjects = RegProcessRepository.getInstance().query(REG_PROCESS_SELECT_PROPERTIES, new QFilter[]{employeeFilter});
        if (regProcessObjects == null || regProcessObjects.length < 1) {
            throw new KDBizException(" query reg process exception");
        }
        for (DynamicObject dynamicObject : regProcessObjects) {
            dynamicObject.set("isoverdue", (Object)Boolean.TRUE);
        }
        RegProcessRepository.getInstance().update(regProcessObjects);
    }

    private DynamicObject[] queryRegBill() {
        QFilter regStatusFilter = new QFilter("regstatus", "=", (Object)RegBusinessStatusEnum.ALREADY_REGED.getCode());
        return IRegBillService.getInstance().query(REG_SELECT_PROPERTIES, new QFilter[]{regStatusFilter});
    }
}

