/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.schedule;

import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.util.StringUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hdm.business.reg.RegDetailInfoHelper;
import kd.hr.hdm.business.reg.domain.service.bill.IRegBillService;
import kd.hr.hdm.common.reg.enums.RegCategoryEnum;
import kd.hr.hdm.common.reg.enums.RegDateUnitEnum;

public class RegProbationexTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(RegProbationexTask.class);
    private static final String REG_SELECT_PROPERTIES = "preactualdate,probation,probationunit,probationex,probationunitex,postponedate,postponeprobation,postponeprobationunit";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("RegProbationexTask start ...");
        DynamicObject[] regBillDynamicObjects = this.queryRegBill();
        if (regBillDynamicObjects != null && regBillDynamicObjects.length > 0) {
            this.updatePostponeProbation(regBillDynamicObjects);
        }
        RegDetailInfoHelper.getInstance().setSchedule("35S2YUJJ67V4");
        LOGGER.info("RegProbationexTask end ...");
    }

    private DynamicObject[] queryRegBill() {
        QFilter regCategoryFilter = new QFilter("regcategory", "=", (Object)RegCategoryEnum.POSTPHONE.getId());
        return IRegBillService.getInstance().query(REG_SELECT_PROPERTIES, new QFilter[]{regCategoryFilter});
    }

    private void updatePostponeProbation(DynamicObject[] regBillDynamicObjects) {
        for (DynamicObject regBill : regBillDynamicObjects) {
            String probationUnit = regBill.getString("probationunit");
            String probationEXunit = regBill.getString("probationunitex");
            if (StringUtils.isEmpty((String)probationUnit) || StringUtils.isEmpty((String)probationEXunit)) continue;
            if (probationUnit.equals(probationEXunit)) {
                int probationEx = regBill.getInt("probationex");
                int probation = regBill.getInt("probation");
                regBill.set("postponeprobation", (Object)(probationEx - probation));
                regBill.set("postponeprobationunit", (Object)probationUnit);
                continue;
            }
            Date preActualDate = regBill.getDate("preactualdate");
            Date postponeDate = regBill.getDate("postponedate");
            if (preActualDate == null || postponeDate == null) continue;
            long dateDiff = HRDateTimeUtils.dateDiff((String)"d", (Date)preActualDate, (Date)postponeDate);
            regBill.set("postponeprobation", (Object)dateDiff);
            regBill.set("postponeprobationunit", (Object)RegDateUnitEnum.DAY.getCode());
        }
        IRegBillService.getInstance().update(regBillDynamicObjects);
    }
}

