/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.schedule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hdm.business.reg.RegDetailInfoHelper;
import kd.hr.hdm.business.reg.domain.repository.database.RegProcessRepository;
import kd.hr.hdm.business.reg.domain.service.bill.IRegBillService;
import kd.hr.hdm.common.reg.constants.TrialPeriodResultConstants;
import kd.hr.hdm.common.reg.enums.RegBusinessStatusEnum;

public class RegProcessUpgradeTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(RegProcessUpgradeTask.class);
    private static final String REG_SELECT_PROPERTIES = "person,bemployee";
    private static final String REG_PROCESS_SELECT_PROPERTIES = "person,bemployee,regstatus";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("RegProcessUpgradeTask start ...");
        QFilter personFilter = new QFilter("person", "=", (Object)0L);
        DynamicObject[] regProcessObjects = RegProcessRepository.getInstance().query(REG_PROCESS_SELECT_PROPERTIES, new QFilter[]{personFilter});
        if (regProcessObjects == null || regProcessObjects.length < 1) {
            return;
        }
        Long[] employeeIds = (Long[])Arrays.stream(regProcessObjects).map(regProcess -> regProcess.getLong("bemployee")).toArray(Long[]::new);
        DynamicObject[] regBillObjects = this.queryRegBill(employeeIds);
        if (regBillObjects == null || regBillObjects.length < 1) {
            return;
        }
        boolean success = this.updateProbationResult(regProcessObjects);
        if (!success) {
            return;
        }
        Map<Long, Long> employeeMap = Arrays.stream(regBillObjects).collect(Collectors.toMap(regBillObject -> regBillObject.getLong("bemployee.id"), regBillObject -> regBillObject.getLong("person.id"), (n, o) -> n));
        for (DynamicObject dynamicObject : regProcessObjects) {
            Long personId = employeeMap.get(dynamicObject.getLong("bemployee"));
            dynamicObject.set("person", (Object)personId);
        }
        RegProcessRepository.getInstance().update(regProcessObjects);
        RegDetailInfoHelper.getInstance().setSchedule("3=UXSF=+RP1X");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateProbationResult(DynamicObject[] regProcessObjects) {
        ArrayList<Long> alreadyEmployeeIdList = new ArrayList<Long>();
        ArrayList<Long> rejectEmployeeIdList = new ArrayList<Long>();
        for (DynamicObject regProcess : regProcessObjects) {
            String regStatus = regProcess.getString("regstatus");
            long employeeId2 = regProcess.getLong("bemployee");
            if (RegBusinessStatusEnum.ALREADY_REGED.getCode().equals(regStatus)) {
                alreadyEmployeeIdList.add(employeeId2);
            }
            if (!RegBusinessStatusEnum.REJECT_REG.getCode().equals(regStatus)) continue;
            rejectEmployeeIdList.add(employeeId2);
        }
        try (TXHandle txHandle = TX.requiresNew();){
            if (alreadyEmployeeIdList.size() > 0 || rejectEmployeeIdList.size() > 0) {
                String sql = "update t_hrpi_trialperiodrst set fprobationrstid = ? where femployeeid = ? and fiscurrentversion = ?";
                ArrayList paramsList = new ArrayList();
                alreadyEmployeeIdList.forEach(employeeId -> {
                    Object[] params = new Object[]{TrialPeriodResultConstants.REG_PASS, employeeId, "1"};
                    paramsList.add(params);
                });
                rejectEmployeeIdList.forEach(employeeId -> {
                    Object[] params = new Object[]{TrialPeriodResultConstants.REG_NOT_PASS, employeeId, "1"};
                    paramsList.add(params);
                });
                HRDBUtil.executeBatch((DBRoute)DBRoute.of((String)"hr"), (String)sql, paramsList);
            }
        }
        return true;
    }

    private DynamicObject[] queryRegBill(Long[] employeeIds) {
        QFilter regStatusFilter = new QFilter("bemployee", "in", (Object)employeeIds);
        return IRegBillService.getInstance().query(REG_SELECT_PROPERTIES, new QFilter[]{regStatusFilter});
    }
}

