/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.warn.reg;

import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.earlywarn.EarlyWarnContext;
import kd.bos.entity.earlywarn.warn.plugin.IEarlyWarnWriteOut;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hdm.business.repository.RegProcessRepository;

public class DueRegEarlyWarnWriteOut
implements IEarlyWarnWriteOut {
    private static final Log LOGGER = LogFactory.getLog(DueRegEarlyWarnWriteOut.class);

    public void writeOut(DynamicObjectCollection dynamicObjectCollection, EarlyWarnContext context) {
        DynamicObjectCollection warnDataList = context.getWarnDataList();
        if (CollectionUtils.isEmpty((Collection)warnDataList)) {
            LOGGER.warn("warnDataList is empty");
            return;
        }
        List<Long> personIds = warnDataList.stream().map(warnData -> warnData.getLong("person.id")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(personIds)) {
            LOGGER.error("personIds is empty");
            return;
        }
        LOGGER.info("personIds:{}", (Object)JSON.toJSONString(personIds));
        RegProcessRepository repository = RegProcessRepository.getRepository();
        Map<Long, DynamicObject> regProcessMap = repository.queryByPersonIds(personIds, new String[]{"person", "isoverdue"});
        if (regProcessMap.size() == 0) {
            LOGGER.warn("regProcessMap is empty");
            return;
        }
        regProcessMap.values().forEach(dy -> dy.set("isoverdue", (Object)true));
        repository.update(regProcessMap.values().toArray(new DynamicObject[0]));
    }
}

