/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.warn.reg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.earlywarn.EarlyWarnContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.earlywarn.impl.DefaultEarlyWarnBillDataSource;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hdm.business.domain.service.hrpi.IHRPIService;
import kd.hr.hdm.business.reg.domain.service.common.IRuleEngineService;
import kd.hr.hdm.business.reg.domain.service.earlywarn.IRegEarlyWarnService;
import kd.hr.hdm.business.repository.RegNearPreDateRepository;

public class NearPreRegDateEarlyWarnDataSource
extends DefaultEarlyWarnBillDataSource {
    private static final Log LOGGER = LogFactory.getLog(NearPreRegDateEarlyWarnDataSource.class);

    public DynamicObjectCollection getData(String dataSource, List<QFilter> filterList, EarlyWarnContext context) {
        LOGGER.info("NearPreRegDateEarlyWarnDataSource.getData start");
        RegNearPreDateRepository repository = RegNearPreDateRepository.getRepository();
        int deleteCount = repository.deleteByFilter(new QFilter[]{new QFilter("id", "!=", (Object)0L)});
        LOGGER.info("NearPreRegDateEarlyWarnDataSource.getData deleteCount:{}", (Object)deleteCount);
        DynamicObjectCollection trailPeriodCollection = super.getData(dataSource, filterList, context);
        if (trailPeriodCollection.isEmpty()) {
            LOGGER.warn("trailPeriodCollection is empty");
            return trailPeriodCollection;
        }
        DynamicObjectCollection collection = new DynamicObjectCollection();
        HashMap<Long, Long> erManFileIdMap = new HashMap<Long, Long>(trailPeriodCollection.size());
        Map<Long, String> earlyWarnLevelMap = this.ruleEngineFilterHandler(trailPeriodCollection, collection, erManFileIdMap);
        context.putCustomData("earlyWarnLevelMap", earlyWarnLevelMap);
        context.putCustomData("erManFileIdMap", erManFileIdMap);
        Map<String, Set<Long>> receiverUserIdMap = IRegEarlyWarnService.getInstance().batchGetReceiver(collection, true, true, true, true);
        context.putCustomData("receiverMap", receiverUserIdMap);
        LOGGER.info("NearPreRegDateEarlyWarnDataSource.getData end");
        return collection;
    }

    private Map<Long, String> ruleEngineFilterHandler(DynamicObjectCollection trialPeriodCollection, DynamicObjectCollection collection, Map<Long, Long> erManFileIdMap) {
        int batchSize = 500;
        int dataSize = trialPeriodCollection.size();
        HashMap<Long, String> earlyWarnLevelMap = new HashMap<Long, String>(dataSize);
        int batch = dataSize / batchSize;
        for (int i = 0; i < batch + 1; ++i) {
            int indexStart = i * batchSize;
            int indexEnd = Math.min(indexStart + batchSize, dataSize);
            LOGGER.info("batchSize:{} i:{} indexStart:{} indexEnd:{}", new Object[]{batchSize, i, indexStart, indexEnd});
            List trialPeriods = trialPeriodCollection.subList(indexStart, indexEnd);
            List<Long> personIds = trialPeriods.stream().filter(dy -> !HRObjectUtils.isEmpty((Object)dy.get("person"))).map(dy -> dy.getLong("person.id")).collect(Collectors.toList());
            Map<Long, DynamicObject> erManFileDyMap = IHRPIService.getInstance().queryPrimaryErManFileByPersonIds(new String[]{"id", "org", "person"}, personIds);
            if (erManFileDyMap.isEmpty()) {
                LOGGER.warn("erManFileDyMap is empty");
                break;
            }
            Map<Long, String> resultMap = IRuleEngineService.getInstance().batchCallRegNearPreDateRuleEngine(new ArrayList<DynamicObject>(erManFileDyMap.values()));
            earlyWarnLevelMap.putAll(resultMap);
            Map<Long, Long> personErManFileIdMap = erManFileDyMap.values().stream().filter(dy -> resultMap.containsKey(dy.getLong("id"))).collect(Collectors.toMap(dy -> dy.getLong("person.id"), dy -> dy.getLong("id"), (v1, v2) -> v2));
            erManFileIdMap.putAll(personErManFileIdMap);
            collection.addAll((Collection)trialPeriods.stream().filter(trialPeriod -> personErManFileIdMap.containsKey(trialPeriod.getLong("person.id"))).collect(Collectors.toList()));
        }
        return earlyWarnLevelMap;
    }
}

