/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.opplugin.database;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hlcm.business.domian.service.hrcs.IHRCSKeywordMappingService;
import kd.hr.hlcm.common.constants.HLCMTemplateConstants;
import kd.hr.hlcm.opplugin.validator.TemplateSubmitValidator;

public class TemplateSaveOp
extends HRDataBaseOp {
    private boolean isExist;

    public void onPreparePropertys(PreparePropertysEventArgs evt) {
        List fieldKeys = evt.getFieldKeys();
        fieldKeys.add("status");
        fieldKeys.add("enable");
        fieldKeys.add("varmap_entryentity");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new TemplateSubmitValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        boolean exists;
        DynamicObject[] dataEntities = e.getDataEntities();
        this.isExist = exists = this.isExists(dataEntities[0]);
        if (exists) {
            return;
        }
        for (DynamicObject dataEntity : dataEntities) {
            HRBaseServiceHelper hisServiceHelper = new HRBaseServiceHelper("hlcm_contracttemplatehis");
            DynamicObject dynamicObject = hisServiceHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)dataEntity, (DynamicObject)dynamicObject, (Set)HLCMTemplateConstants.IGNORE_KEYS);
            long conTempId = dataEntity.getLong("id");
            dynamicObject.set("vid", (Object)conTempId);
            dynamicObject.set("iscurrentversion", (Object)"1");
            dynamicObject.set("id", (Object)dataEntity.getLong("futurevid"));
            dynamicObject = (DynamicObject)hisServiceHelper.saveOne(dynamicObject);
            long hisId = dynamicObject.getLong("id");
            dataEntity.set("vid", (Object)hisId);
        }
        DynamicObject dataEntity = dataEntities[0];
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("varmap_entryentity");
        long id = dataEntity.getLong("id");
        long vid = dataEntity.getLong("vid");
        try (TXHandle txHandle = TX.notSupported();){
            IHRCSKeywordMappingService.getInstance().saveKeyMapping(entryEntity, vid, id);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        if (!this.isExist) {
            DynamicObject[] dataEntities = e.getDataEntities();
            DynamicObject dataEntity = dataEntities[0];
            String pkId = dataEntity.getString("id");
            HRBaseServiceHelper attachmentService = new HRBaseServiceHelper("bos_attachment");
            QFilter[] filters = new QFilter[]{new QFilter("fbilltype", "=", (Object)"hlcm_contracttemplate"), new QFilter("finterid", "=", (Object)pkId)};
            DynamicObject[] queryAtt = attachmentService.loadDynamicObjectArray(filters);
            ArrayList<DynamicObject> attachments = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> preattachments = new ArrayList<DynamicObject>();
            for (DynamicObject att : queryAtt) {
                DynamicObject dynamicObject = attachmentService.generateEmptyDynamicObject();
                HRDynamicObjectUtils.copy((DynamicObject)att, (DynamicObject)dynamicObject, (Set)HLCMTemplateConstants.IGNORE_KEYS);
                dynamicObject.set("fbilltype", (Object)"hlcm_contracttemplatehis");
                dynamicObject.set("finterid", (Object)String.valueOf(dataEntity.getLong("vid")));
                String number = String.join((CharSequence)"-", "rc-upload", "templatehis", dynamicObject.getString("finterid"));
                dynamicObject.set("FNUMBER", (Object)number);
                attachments.add(dynamicObject);
                String preNumber = String.join((CharSequence)"-", "rc-upload", "template", att.getString("finterid"));
                att.set("FNUMBER", (Object)preNumber);
                preattachments.add(att);
            }
            if (attachments.size() > 0) {
                attachmentService.save(attachments.toArray(new DynamicObject[0]));
                attachmentService.save(preattachments.toArray(new DynamicObject[0]));
            }
        }
    }

    private boolean isExists(DynamicObject dataEntity) {
        Object pkValue = dataEntity.getPkValue();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hlcm_contracttemplate");
        return serviceHelper.isExists(pkValue);
    }
}

