/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.opplugin.validator;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.vaildator.ContractSignValidatorFactory;
import kd.hr.hlcm.business.vaildator.SignCompanyContractSubjectValidator;
import kd.hr.hlcm.business.vaildator.SubmitEffectSignWayValidator;
import kd.hr.hlcm.business.vaildator.ValidatorBase;
import kd.hr.hlcm.business.vaildator.ValidatorHolder;
import kd.hr.hlcm.common.enums.BusinessTypeEnum;

public class ContractBaseSaveValidator
extends AbstractValidator {
    private static final Set<String> NOVALIDATE_OFBUSINESSTYPE = Sets.newHashSet((Object[])new String[]{BusinessTypeEnum.CANCEL.getCombKey(), BusinessTypeEnum.STOP.getCombKey()});

    public void validate() {
        if (Lists.newArrayList((Object[])new String[]{"submit", "submiteffect"}).contains(this.getOperateKey()) && !this.getValidateContext().getValidateResults().getValidateErrors().isEmpty()) {
            return;
        }
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        Map<ExtendedDataEntity, String> validateResultMap = this.checkPersonContractBatch(dataEntities, this.getOperateKey());
        validateResultMap.entrySet().stream().forEach(entry -> {
            ExtendedDataEntity dataEntity = (ExtendedDataEntity)entry.getKey();
            String errMsg = (String)entry.getValue();
            this.addFatalErrorMessage(dataEntity, errMsg);
        });
    }

    public Map<ExtendedDataEntity, String> checkPersonContractBatch(ExtendedDataEntity[] dataEntities, String operateKey) {
        ArrayList dyList = new ArrayList();
        HashMap dyToDataEntityMap = new HashMap();
        ConcurrentHashMap<ExtendedDataEntity, String> resultMap = new ConcurrentHashMap<ExtendedDataEntity, String>();
        Arrays.stream(dataEntities).forEach(bill -> {
            DynamicObject dataEntity = bill.getDataEntity();
            dyList.add(dataEntity);
            dyToDataEntityMap.put(dataEntity, bill);
        });
        RefObject val = new RefObject();
        boolean isImportType = this.getOption().tryGetVariableValue("importtype", val);
        Map validatorHolderMap = isImportType ? ContractSignValidatorFactory.getImportValidatorHolderMap(dyList) : ContractSignValidatorFactory.getManualBatchValidatorHolder(dyList);
        if ("presubmit".equals(operateKey)) {
            validatorHolderMap.values().stream().forEach(holder -> holder.setValidateAll(true));
        }
        validatorHolderMap.entrySet().stream().forEach(entry -> {
            Object error;
            DynamicObject dynamicObject = (DynamicObject)entry.getKey();
            ValidatorHolder holder = (ValidatorHolder)entry.getValue();
            String businessType = dynamicObject.getString("businesstype");
            if (!NOVALIDATE_OFBUSINESSTYPE.contains(businessType)) {
                holder.addValidator((ValidatorBase)(HRStringUtils.equals((String)this.getOperateKey(), (String)"submiteffect") || HRStringUtils.equals((String)this.getOperateKey(), (String)"presubmiteffect") ? new SubmitEffectSignWayValidator() : new SignCompanyContractSubjectValidator()));
            }
            if ((error = holder.startValidate()) != null) {
                String errorMsg = (String)String.class.cast(error);
                ExtendedDataEntity dataEntity = (ExtendedDataEntity)dyToDataEntityMap.get(dynamicObject);
                resultMap.put(dataEntity, errorMsg);
            }
        });
        return resultMap;
    }
}

