/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.opplugin.validator;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.utils.ContractSignUtils;
import kd.hr.hlcm.common.enums.ContractPeriodTypeEnum;
import kd.hr.hlcm.common.enums.ProtocolTypeEnum;
import kd.hr.hlcm.common.enums.SignWayEnum;

public class ContractTemplatePropValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity extendedDataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject contractTemplDy;
            DynamicObject signBill = extendedDataEntity.getDataEntity();
            if (!ProtocolTypeEnum.CON.getCombKey().equals(signBill.getString("protocoltype"))) continue;
            String signWay = signBill.getString("signway");
            Long eConfigId = null;
            if (SignWayEnum.ELECTRONIC.getCombKey().equals(signWay) && HRStringUtils.equals((String)ContractSignUtils.getSignModeVal(), (String)"single_task")) {
                eConfigId = 0L;
            }
            if ((contractTemplDy = signBill.getDynamicObject("contractemplate")) != null) {
                DynamicObject econfig;
                boolean error;
                boolean bl = error = !this.isMatch(signWay, contractTemplDy.getString("signway"));
                if (!error) {
                    DynamicObject type = signBill.getDynamicObject("contracttype");
                    DynamicObject templType = contractTemplDy.getDynamicObject("contracttype");
                    boolean bl2 = error = type != null && templType != null && !HRObjectUtils.equals((Object)templType, (Object)type);
                }
                if (error) {
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u5408\u540c\u6a21\u677f%s\u7684\u5408\u540c\u7c7b\u578b\u548c\u7b7e\u7f72\u65b9\u5f0f\u5c5e\u6027\u4e0e\u5355\u636e\u4e2d\u7ef4\u62a4\u7684\u8be5\u5b57\u6bb5\u503c\u4e0d\u4e00\u81f4\u3002", (String)"ContractTemplatePropValidator_0", (String)"hr-hlcm-opplugin", (Object[])new Object[0]), contractTemplDy.getString("name")));
                }
                if (eConfigId != null && (econfig = contractTemplDy.getDynamicObject("econtemplate")) != null) {
                    eConfigId = econfig.getLong("id");
                }
            }
            if (!signBill.getBoolean("issignother") && !signBill.getBoolean("issignprotocol")) continue;
            DynamicObjectCollection dys = signBill.getDynamicObjectCollection("entryentity");
            for (DynamicObject dy : dys) {
                DynamicObject periodTypeDy;
                DynamicObject entryTemplDy = dy.getDynamicObject("contracttemplate");
                if (entryTemplDy != null) {
                    boolean error;
                    boolean bl = error = !this.isMatch(signWay, entryTemplDy.getString("signway"));
                    if (!error) {
                        DynamicObject type = dy.getDynamicObject("entrycontracttype");
                        DynamicObject templType = entryTemplDy.getDynamicObject("contracttype");
                        boolean bl3 = error = type != null && templType != null && !HRObjectUtils.equals((Object)templType, (Object)type);
                    }
                    if (error) {
                        this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u5408\u540c\u6a21\u677f\u201c%s\u201d\u7684\u5408\u540c\u7c7b\u578b\u53ca\u7b7e\u7f72\u65b9\u5f0f\u5fc5\u987b\u4e0e\u5206\u5f55\u4e2d\u5408\u540c\u7c7b\u578b\u53ca\u5355\u636e\u4e2d\u7b7e\u7f72\u65b9\u5f0f\u4fdd\u6301\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u4fdd\u5b58\u3002", (String)"ContractTemplatePropValidator_1", (String)"hr-hlcm-opplugin", (Object[])new Object[0]), entryTemplDy.getString("name")));
                    }
                    if (eConfigId != null) {
                        DynamicObject econfig = entryTemplDy.getDynamicObject("econtemplate");
                        if (eConfigId == 0L) {
                            eConfigId = econfig.getLong("id");
                        } else if (!eConfigId.equals(econfig.getLong("id"))) {
                            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u7535\u5b50\u7b7e\u7f72\u4e2d\uff0c\u591a\u4efd\u5408\u540c\u6a21\u677f\u7684\u7535\u5b50\u7b7e\u7f72\u914d\u7f6e\u9700\u4fdd\u6301\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ContractTemplatePropValidator_3", (String)"hr-hlcm-opplugin", (Object[])new Object[0]), new Object[0]));
                        }
                    }
                }
                if ((periodTypeDy = dy.getDynamicObject("entryperiodtype")) != null && ContractPeriodTypeEnum.FIXED.getPkId() == periodTypeDy.getLong("id") && (dy.getBigDecimal("entryperiod").compareTo(new BigDecimal("0.0")) <= 0 || HRStringUtils.isEmpty((String)dy.getString("entryperiodunit")) || dy.get("entryenddate") == null)) {
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u5408\u540c\u671f\u9650\u7c7b\u578b\u4e3a\u56fa\u5b9a\u671f\u9650\u65f6\uff0c\u5fc5\u987b\u586b\u5199\u5408\u540c\u671f\u9650\u3001\u671f\u9650\u5355\u4f4d\u548c\u5408\u540c\u7ed3\u675f\u65e5\u671f\u3002", (String)"ContractTemplatePropValidator_2", (String)"hr-hlcm-opplugin", (Object[])new Object[0]), new Object[0]));
                }
                if (periodTypeDy == null || ContractPeriodTypeEnum.COMPTASK.getPkId() != periodTypeDy.getLong("id")) continue;
                BigDecimal period = dy.getBigDecimal("entryperiod");
                Date endDate = dy.getDate("entryenddate");
                if ((HRObjectUtils.isEmpty((Object)period) || period.compareTo(BigDecimal.ZERO) == 0) && endDate != null) {
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u5408\u540c\u671f\u9650\u4e0e\u5408\u540c\u7ed3\u675f\u65e5\u671f\u9700\u540c\u65f6\u6709\u503c\u6216\u65e0\u503c\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ContractTemplatePropValidator_4", (String)"hr-hlcm-opplugin", (Object[])new Object[0]), new Object[0]));
                }
                if (HRObjectUtils.isEmpty((Object)period) || period.compareTo(BigDecimal.ZERO) == 0) continue;
                if (endDate == null) {
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u5408\u540c\u671f\u9650\u4e0e\u5408\u540c\u7ed3\u675f\u65e5\u671f\u9700\u540c\u65f6\u6709\u503c\u6216\u65e0\u503c\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ContractTemplatePropValidator_4", (String)"hr-hlcm-opplugin", (Object[])new Object[0]), new Object[0]));
                }
                if (!HRStringUtils.isEmpty((String)dy.getString("entryperiodunit"))) continue;
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u5408\u540c\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ContractTemplatePropValidator_5", (String)"hr-hlcm-opplugin", (Object[])new Object[0]), new Object[0]));
            }
        }
    }

    private boolean isMatch(String signWay, String signWayMulti) {
        if (HRStringUtils.isEmpty((String)signWay) || HRStringUtils.isEmpty((String)signWayMulti)) {
            return true;
        }
        return Arrays.stream(signWayMulti.split(",")).collect(Collectors.toSet()).contains(signWay);
    }
}

