/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.opplugin.validator;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.common.HLCMCommonRepository;
import kd.hr.hlcm.business.utils.ProxyUtils;
import kd.hr.hlcm.common.enums.BusinessTypeEnum;
import kd.hr.hlcm.common.enums.ContractTypeCatEnum;
import kd.hr.hlcm.common.enums.ProtocolTypeEnum;
import kd.hr.hlcm.common.enums.SignWayEnum;

public class MustMainContractValidator
extends AbstractValidator {
    public void validate() {
        if (!ProxyUtils.isEntryEntitySingleSelect()) {
            return;
        }
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashSet contractTypeIdSet = Sets.newHashSetWithExpectedSize((int)dataEntities.length);
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            if (this.isIgnore(dataEntity)) continue;
            DynamicObjectCollection entryEntityCollection = dataEntity.getDynamicObjectCollection("entryentity");
            Set set = entryEntityCollection.stream().map(dy -> dy.getLong("contracttemplate.contracttype.id")).collect(Collectors.toSet());
            contractTypeIdSet.addAll(set);
        }
        QFilter filter = new QFilter("id", "in", (Object)contractTypeIdSet);
        DynamicObject[] contractTypes = HLCMCommonRepository.queryDynamicObjects((String)"hbss_contracttypes", (String)"group", (QFilter[])new QFilter[]{filter});
        HashMap contractTypesMap = Maps.newHashMapWithExpectedSize((int)contractTypes.length);
        for (DynamicObject dynamicObject : contractTypes) {
            contractTypesMap.put(dynamicObject.getLong("id"), dynamicObject.getLong("group.id"));
        }
        for (DynamicObject dynamicObject : dataEntities) {
            DynamicObject dataEntity = dynamicObject.getDataEntity();
            DynamicObjectCollection entryEntityCollection = dataEntity.getDynamicObjectCollection("entryentity");
            String protocolType = dataEntity.getString("protocoltype");
            String signWay = dataEntity.getString("signway");
            if (entryEntityCollection.size() > 1 && HRStringUtils.equals((String)signWay, (String)SignWayEnum.ELECTRONIC.getCombKey()) && !HRStringUtils.equals((String)protocolType, (String)ProtocolTypeEnum.CON.getCombKey())) {
                String errorMsg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5f53\u524d\u7b7e\u7f72\u65b9\u5f0f\u4e3a\u7535\u5b50\u7b7e\u7f72\uff0c\u5408\u540c\u6a21\u677f\u4e3a\u5fc5\u9009\u4e14\u53ea\u80fd\u9009\u62e91\u4efd\u3002", (String)"MustMainContractValidator_5", (String)"hr-hlcm-opplugin", (Object[])new Object[0]);
                this.addFatalErrorMessage((ExtendedDataEntity)dynamicObject, errorMsg);
                continue;
            }
            if (this.isIgnore(dataEntity)) continue;
            ContractTypeCatEnum contractTypeCatEnum = ContractTypeCatEnum.CON;
            String contractTypeCatStr = ResManager.loadKDString((String)"\u52b3\u52a8\u5408\u540c\u5927\u7c7b", (String)"MustMainContractValidator_1", (String)"hr-hlcm-opplugin", (Object[])new Object[0]);
            if (HRStringUtils.equals((String)protocolType, (String)ProtocolTypeEnum.YG.getCombKey())) {
                contractTypeCatStr = ResManager.loadKDString((String)"\u7528\u5de5\u534f\u8bae\u5927\u7c7b", (String)"MustMainContractValidator_2", (String)"hr-hlcm-opplugin", (Object[])new Object[0]);
                contractTypeCatEnum = ContractTypeCatEnum.EMP;
            }
            ContractTypeCatEnum finalContractTypeCatEnum = contractTypeCatEnum;
            Set contractTemplateNumberSet = entryEntityCollection.stream().filter(entryEntityDy -> {
                long contractTypeId = entryEntityDy.getLong("contracttemplate.contracttype.id");
                Long groupId = (Long)contractTypesMap.get(contractTypeId);
                return Objects.equals(groupId, finalContractTypeCatEnum.getPkId());
            }).map(entryEntityDy -> entryEntityDy.getString("contracttemplate.number")).collect(Collectors.toSet());
            String contractTemplateNumbers = String.join((CharSequence)",", contractTemplateNumberSet);
            if (contractTemplateNumberSet.size() <= 1) continue;
            this.addFatalErrorMessage((ExtendedDataEntity)dynamicObject, String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\u5747\u4e3a%2$s\u7684\u5408\u540c\u6a21\u677f\uff0c\u8bf7\u4fdd\u75591\u4e2a\u3002", (String)"MustMainContractValidator_3", (String)"hr-hlcm-opplugin", (Object[])new Object[0]), contractTemplateNumbers, contractTypeCatStr));
        }
    }

    private boolean isIgnore(DynamicObject dataEntity) {
        String businessType = dataEntity.getString("businesstype");
        String protocolType = dataEntity.getString("protocoltype");
        return !Lists.newArrayList((Object[])new String[]{BusinessTypeEnum.NEW.getCombKey(), BusinessTypeEnum.RENEW.getCombKey(), BusinessTypeEnum.CHANGE.getCombKey()}).contains(businessType) || HRStringUtils.equals((String)protocolType, (String)ProtocolTypeEnum.FS.getCombKey());
    }
}

