/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.activtity;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.domian.service.activity.ISignActivity;

public class ActivityConsumer
implements MessageConsumer {
    private static final Log LOGGER = LogFactory.getLog(ActivityConsumer.class);

    public void onMessage(Object message, String messageId, boolean resend, MessageAcker messageAcker) {
        String msgStr = JSON.toJSONString((Object)message);
        LOGGER.info("ActivityConsumer receive  message {}", (Object)msgStr);
        if (!(message instanceof Map)) {
            LOGGER.warn("messageId is null or message is not type of map");
            messageAcker.discard(messageId);
            return;
        }
        try {
            JSONObject messageMap = JSON.parseObject((String)msgStr);
            String eventType = messageMap.getString("eventType");
            if (HRStringUtils.isEmpty((String)eventType)) {
                ISignActivity.getInstance().handleMessage(messageMap);
            }
            messageAcker.ack(messageId);
            LOGGER.info("ActivityConsumer handleMessage success {}", (Object)msgStr);
        }
        catch (Exception exp) {
            LOGGER.error("handleMessage error", (Throwable)exp);
            messageAcker.deny(messageId);
        }
    }
}

