/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.domian.repository;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRObjectUtils;

public class BosUserRepository {
    HRBaseServiceHelper SERVICE_HELPER = new HRBaseServiceHelper("bos_user");
    private static final BosUserRepository BOSUSER_REPOSITORY = new BosUserRepository();

    private BosUserRepository() {
    }

    public static BosUserRepository getInstance() {
        return BOSUSER_REPOSITORY;
    }

    public DynamicObject[] query(String fields, QFilter[] filters) {
        return this.SERVICE_HELPER.query(fields, filters);
    }

    public DynamicObject queryOne(String fields, QFilter[] filters) {
        return this.SERVICE_HELPER.queryOne(fields, filters);
    }

    public Map<String, String> getPictures(List<Long> ids) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", ids)};
        DynamicObject[] dys = this.SERVICE_HELPER.query("id,picturefield", filters);
        HashMap map = Maps.newHashMapWithExpectedSize((int)dys.length);
        for (DynamicObject dy : dys) {
            map.put(dy.getString("id"), HRImageUrlUtil.getImageFullUrl((String)dy.getString("picturefield")));
        }
        return map;
    }

    public static List<Long> getBosUserIds(List<String> personNumberList) {
        QFilter numberFilter = new QFilter("number", "in", personNumberList);
        QFilter enabelFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] bosUsers = BosUserRepository.getInstance().query("id", new QFilter[]{numberFilter, enabelFilter});
        ArrayList<Long> bosUserIdList = new ArrayList<Long>(bosUsers.length);
        for (DynamicObject bosUser : bosUsers) {
            bosUserIdList.add(bosUser.getLong("id"));
        }
        return bosUserIdList;
    }

    public static Long getBosUserId(String number) {
        DynamicObject bosUser = BosUserRepository.getInstance().queryOne("id", new QFilter[]{new QFilter("number", "=", (Object)number), new QFilter("enable", "=", (Object)"1")});
        return HRObjectUtils.isEmpty((Object)bosUser) ? 0L : bosUser.getLong("id");
    }
}

