/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.domian.repository;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hlcm.business.domian.repository.CommonRepository;

public class ContractApplyRepository {
    HRBaseServiceHelper SERVICE_HELPER = new HRBaseServiceHelper("hlcm_contractapplybase");
    private static final ContractApplyRepository CONTRACT_APPLY_REPOSITORY = new ContractApplyRepository();

    private ContractApplyRepository() {
    }

    public static ContractApplyRepository getInstance() {
        return CONTRACT_APPLY_REPOSITORY;
    }

    public DynamicObject[] getPersonIdsDataByApplyIds(Object[] applyIds) {
        DynamicObject[] contractApplys = this.SERVICE_HELPER.query("person.id", new QFilter[]{new QFilter("id", "in", (Object)applyIds)});
        return contractApplys;
    }

    public List<List> getEmployeeWhereInSigning(Object[] employeeIds) {
        ArrayList originalPersonIdList = Lists.newArrayList((Object[])employeeIds);
        ArrayList<List> result = new ArrayList<List>();
        QFilter personIdQFilter = new QFilter("employee.id", "in", (Object)originalPersonIdList);
        DynamicObject[] existContractApplys = this.SERVICE_HELPER.query("employee.id", new QFilter[]{personIdQFilter});
        List<Object> existContractApplyPersonIds = this.transferDymsToEmployeeIdList(existContractApplys);
        List<Object> notStartPersonIds = this.filterPersonIds(originalPersonIdList, existContractApplyPersonIds);
        DynamicObject[] toCommitContractApplys = this.getEmployeeToCommitContractApplys(existContractApplyPersonIds);
        List<Object> toCommitContractApplyPersonIds = this.transferDymsToEmployeeIdList(toCommitContractApplys);
        List<Object> remainPersonIds = this.filterPersonIds(existContractApplyPersonIds, toCommitContractApplyPersonIds);
        DynamicObject[] inProcessContractApplys = this.getEmployeeInProcessContractApplys(remainPersonIds);
        List<Object> inProcessPersonIds = this.transferDymsToEmployeeIdList(inProcessContractApplys);
        remainPersonIds = this.filterPersonIds(remainPersonIds, inProcessPersonIds);
        DynamicObject[] terminateContractApplys = this.getEmployeeLatestTerminateContractApplys(remainPersonIds);
        List<Object> terminatePersonIds = this.transferDymsToEmployeeIdList(terminateContractApplys);
        List<Object> archivedPerosnIds = this.filterPersonIds(remainPersonIds, terminatePersonIds);
        result.add(notStartPersonIds);
        result.add(toCommitContractApplyPersonIds);
        result.add(inProcessPersonIds);
        result.add(terminatePersonIds);
        result.add(archivedPerosnIds);
        return result;
    }

    public List<List> getPersonsWhereInSigning(Object[] personIds) {
        ArrayList originalPersonIdList = Lists.newArrayList((Object[])personIds);
        ArrayList<List> result = new ArrayList<List>();
        QFilter personIdQFilter = new QFilter("person.id", "in", (Object)originalPersonIdList);
        DynamicObject[] existContractApplys = this.SERVICE_HELPER.query("person.id", new QFilter[]{personIdQFilter});
        List<Object> existContractApplyPersonIds = this.transferDymsToPersonIdList(existContractApplys);
        List<Object> notStartPersonIds = this.filterPersonIds(originalPersonIdList, existContractApplyPersonIds);
        DynamicObject[] toCommitContractApplys = this.getToCommitContractApplys(existContractApplyPersonIds);
        List<Object> toCommitContractApplyPersonIds = this.transferDymsToPersonIdList(toCommitContractApplys);
        List<Object> remainPersonIds = this.filterPersonIds(existContractApplyPersonIds, toCommitContractApplyPersonIds);
        DynamicObject[] inProcessContractApplys = this.getInProcessContractApplys(remainPersonIds);
        List<Object> inProcessPersonIds = this.transferDymsToPersonIdList(inProcessContractApplys);
        remainPersonIds = this.filterPersonIds(remainPersonIds, inProcessPersonIds);
        DynamicObject[] terminateContractApplys = this.getLatestTerminateContractApplys(remainPersonIds);
        List<Object> terminatePersonIds = this.transferDymsToPersonIdList(terminateContractApplys);
        List<Object> archivedPerosnIds = this.filterPersonIds(remainPersonIds, terminatePersonIds);
        result.add(notStartPersonIds);
        result.add(toCommitContractApplyPersonIds);
        result.add(inProcessPersonIds);
        result.add(terminatePersonIds);
        result.add(archivedPerosnIds);
        return result;
    }

    public DynamicObject[] getToCommitContractApplys(List personIds) {
        QFilter personIdQFilter2 = new QFilter("person.id", "in", (Object)personIds);
        QFilter toCommitQFilter = new QFilter("handlestatus", "=", (Object)"1");
        return this.SERVICE_HELPER.query("person.id", new QFilter[]{personIdQFilter2, toCommitQFilter});
    }

    public DynamicObject[] getEmployeeToCommitContractApplys(List employeeIds) {
        QFilter employeeIdQFilter2 = new QFilter("employee.id", "in", (Object)employeeIds);
        QFilter toCommitQFilter = new QFilter("handlestatus", "=", (Object)"1");
        return this.SERVICE_HELPER.query("employee.id", new QFilter[]{employeeIdQFilter2, toCommitQFilter});
    }

    public DynamicObject[] getInProcessContractApplys(List personIds) {
        QFilter personIdQFilter2 = new QFilter("person.id", "in", (Object)personIds);
        QFilter toCommitQFilter = new QFilter("handlestatus", "=", (Object)"2");
        return this.SERVICE_HELPER.query("person.id", new QFilter[]{personIdQFilter2, toCommitQFilter});
    }

    public DynamicObject[] getEmployeeInProcessContractApplys(List employeeIds) {
        QFilter employeeIdQFilter2 = new QFilter("employee.id", "in", (Object)employeeIds);
        QFilter toCommitQFilter = new QFilter("handlestatus", "=", (Object)"2");
        return this.SERVICE_HELPER.query("employee.id", new QFilter[]{employeeIdQFilter2, toCommitQFilter});
    }

    public DynamicObject queryByContractNo(String contractNo) {
        return CommonRepository.queryOne("hlcm_contractapplybase", null, new QFilter[]{new QFilter("entryentity.contractno", "=", (Object)contractNo)});
    }

    public DynamicObject[] getLatestTerminateContractApplys(List personIds) {
        QFilter personIdQFilter2 = new QFilter("person.id", "in", (Object)personIds);
        QFilter toCommitQFilter = new QFilter("handlestatus", "=", (Object)"3");
        String orderBy = "id desc";
        DynamicObject[] originArray = this.SERVICE_HELPER.query("person.id", new QFilter[]{personIdQFilter2, toCommitQFilter}, orderBy);
        ArrayList result = new ArrayList();
        HashSet personIdSet = new HashSet();
        Arrays.stream(originArray).forEach(dynamicObject -> {
            if (personIdSet.add(dynamicObject.get("person.id"))) {
                result.add(dynamicObject);
            }
        });
        return result.toArray(new DynamicObject[0]);
    }

    public DynamicObject[] getEmployeeLatestTerminateContractApplys(List employeeIds) {
        QFilter employeeIdQFilter2 = new QFilter("employee.id", "in", (Object)employeeIds);
        QFilter toCommitQFilter = new QFilter("handlestatus", "=", (Object)"3");
        String orderBy = "id desc";
        DynamicObject[] originArray = this.SERVICE_HELPER.query("employee.id", new QFilter[]{employeeIdQFilter2, toCommitQFilter}, orderBy);
        ArrayList result = new ArrayList();
        HashSet employeeIdSet = new HashSet();
        Arrays.stream(originArray).forEach(dynamicObject -> {
            if (employeeIdSet.add(dynamicObject.get("employee.id"))) {
                result.add(dynamicObject);
            }
        });
        return result.toArray(new DynamicObject[0]);
    }

    private List<Object> filterPersonIds(List<Object> originPersonIds, List<Object> beSubPersonIds) {
        return originPersonIds.stream().filter(obj -> !beSubPersonIds.contains(obj)).collect(Collectors.toList());
    }

    private List<Object> transferDymsToEmployeeIdList(DynamicObject[] toCommitContractApplys) {
        return Arrays.stream(toCommitContractApplys).map(dynamicObject -> dynamicObject.get("employee.id")).collect(Collectors.toList());
    }

    private List<Object> transferDymsToPersonIdList(DynamicObject[] toCommitContractApplys) {
        return Arrays.stream(toCommitContractApplys).map(dynamicObject -> dynamicObject.get("person.id")).collect(Collectors.toList());
    }
}

