/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.domian.repository;

import com.alibaba.fastjson.JSON;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.bussiness.cert.HRCertCommonHelper;
import kd.hr.hbp.bussiness.cert.HRCertPromptInfoTypeEnum;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hpfs.business.service.cert.HRCertValidateServiceHelper;

public class LicenseRepository {
    private static final Log LOGGER = LogFactory.getLog(LicenseRepository.class);
    private static final LicenseRepository LICENSE_REPOSITORY = new LicenseRepository();

    private LicenseRepository() {
    }

    public static LicenseRepository getInstance() {
        return LICENSE_REPOSITORY;
    }

    public boolean verifyCertCount(IFormView formView, String pageNumber) {
        Map verifyResult = HRCertCommonHelper.verifyCertCount((String)"1WXBXYCLS05D", (String)pageNumber);
        LOGGER.info("LicenseRepository verifyCertCount|{}", (Object)JSON.toJSONString((Object)verifyResult));
        String verifyCertInfoType = (String)verifyResult.get("infoType");
        boolean ifShowMessage = Boolean.parseBoolean((String)verifyResult.get("showMessage"));
        boolean isForbidden = HRStringUtils.equals((String)HRCertPromptInfoTypeEnum.FORBIDDEN.getName(), (String)verifyCertInfoType);
        boolean isExceed = HRStringUtils.equals((String)HRCertPromptInfoTypeEnum.EXCEED.getName(), (String)verifyCertInfoType);
        if (ifShowMessage) {
            String verifyCertMessage = (String)verifyResult.get("message");
            if (isForbidden) {
                formView.showErrorNotification(verifyCertMessage);
            } else if (isExceed && !(formView instanceof IListView)) {
                formView.showTipNotification(verifyCertMessage);
            }
        }
        return !isForbidden;
    }

    public Map<String, String> verifyCertCountForForm(String pageNumber) {
        return HRCertCommonHelper.verifyCertCount((String)"1WXBXYCLS05D", (String)pageNumber);
    }

    public String checkPersonLicenses(DynamicObject dynamicObject) {
        LOGGER.info("LicenseRepository.checkPersonLicenses={}", HRObjectUtils.isEmpty((Object)dynamicObject) ? null : Long.valueOf(dynamicObject.getLong("ermanfile.person.id")));
        long personId = dynamicObject.getLong("ermanfile.person.id");
        String protocolType = dynamicObject.getString("protocoltype");
        String protocolMsg = null;
        switch (protocolType) {
            case "1": {
                protocolMsg = ResManager.loadKDString((String)"\u52b3\u52a8\u5408\u540c\u65b0\u7b7e", (String)"LicenseRepository_1", (String)"hr-hlcm-business", (Object[])new Object[0]);
                break;
            }
            case "2": {
                protocolMsg = ResManager.loadKDString((String)"\u7528\u5de5\u534f\u8bae\u65b0\u7b7e", (String)"LicenseRepository_2", (String)"hr-hlcm-business", (Object[])new Object[0]);
                break;
            }
            case "3": {
                protocolMsg = ResManager.loadKDString((String)"\u5176\u4ed6\u9644\u5c5e\u534f\u8bae\u65b0\u7b7e", (String)"LicenseRepository_3", (String)"hr-hlcm-business", (Object[])new Object[0]);
            }
        }
        String validateMsg = HRCertValidateServiceHelper.getValidataMsg((Long)personId, protocolMsg);
        LOGGER.info("HRCertValidateServiceHelper.getValidataMsg={}", (Object)validateMsg);
        return validateMsg;
    }

    public Map<Long, Map<String, Object>> batchCheckPersonLicenses(List<Long> personIds) {
        Map longMapMap = HRCertValidateServiceHelper.checkPersonLicenses(personIds);
        return longMapMap;
    }
}

