/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.domian.service.activity.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.workflow.api.IWorkflowService;
import kd.bos.workflow.engine.ManagementService;
import kd.bos.workflow.service.WorkflowService;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.util.HRBaseDataConfigUtil;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.common.HLCMCommonRepository;
import kd.hr.hlcm.business.domian.repository.ActivityRepository;
import kd.hr.hlcm.business.domian.repository.CommonRepository;
import kd.hr.hlcm.business.domian.service.activity.ISignActivity;
import kd.hr.hlcm.business.domian.service.signmgt.ISignManageService;
import kd.hr.hlcm.business.utils.ActivityUtils;
import kd.hr.hlcm.common.enums.BusinessStatusEnum;
import kd.hr.hlcm.common.enums.HandleStatusEnum;
import kd.hr.hlcm.common.enums.ProcessStatusEnum;
import kd.hr.hlcm.common.enums.SignStatusEnum;
import kd.hr.hlcm.common.enums.SignTabEnum;
import kd.sdk.hr.hlcm.business.activity.ISignActivityExt;
import org.apache.commons.lang3.tuple.Pair;

public class SignActivity
implements ISignActivity {
    private static final Log LOGGER = LogFactory.getLog(SignActivity.class);
    private static final String ACTIVITY_ID = "activityId";
    private static final String INSTANCE_ID = "instanceId";
    private static final String BIZ_BILL_ID = "bizBillId";
    private static final String SLA = "sla";
    private static final HRBaseServiceHelper ACTIVITY_SERVICE_HELPER = new HRBaseServiceHelper("hlcm_activity");
    private static final HRBaseServiceHelper APPLY_SERVICE_HELPER = new HRBaseServiceHelper("hlcm_contractapplybase");
    private static final String ACTIVITY_PLAN_SELECT_PROPERTIES = "actschemeentry.activity,actschemeentry.actbizobj";

    @Override
    public void initAllActivity(Long signApplyId, List<Long> activityIds) {
        LOGGER.info("init all activity signApplyId:{}", (Object)signApplyId);
        try (TXHandle txHandle = TX.required();){
            DynamicObject signApply = APPLY_SERVICE_HELPER.loadSingle((Object)signApplyId);
            Pair scheme = (Pair)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSActivityService", (String)"getSchemeFromWorkflow", (Object[])new Object[]{signApply});
            LOGGER.info("get activity scheme:{}", (Object)scheme);
            DynamicObject activityPlan = (DynamicObject)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSActivityService", (String)"getActivitySchemeByNumberAndVersion", (Object[])new Object[]{ACTIVITY_PLAN_SELECT_PROPERTIES, scheme.getKey(), scheme.getValue()});
            LOGGER.info("get activity plan:{}", (Object)activityPlan.getLong("id"));
            ArrayList<DynamicObject> activities = new ArrayList<DynamicObject>(activityIds.size());
            QFilter signBillFilter = new QFilter("signapply", "=", (Object)signApplyId);
            if (ACTIVITY_SERVICE_HELPER.isExists(signBillFilter)) {
                LOGGER.warn("sign bill pkId|{} isExists activity deletePreActivity by system", (Object)signApplyId);
                this.deletePreActivity(signApplyId);
            }
            long currUserId = RequestContext.get().getCurrUserId();
            Date now = new Date();
            for (Long activityId : activityIds) {
                DynamicObject activity = ACTIVITY_SERVICE_HELPER.generateEmptyDynamicObject();
                activity.set("signapply", (Object)signApplyId);
                activity.set("activity", (Object)activityId);
                activity.set("creator", (Object)currUserId);
                activity.set("createtime", (Object)now);
                activity.set("modifier", (Object)currUserId);
                activity.set("modifytime", (Object)now);
                activity.set("person", signApply.get("person"));
                activity.set("org", signApply.get("org"));
                activity.set("adminororg", signApply.get("adminororg"));
                activity.set("ermanperorg", signApply.get("ermanperorg"));
                activities.add(activity);
            }
            ACTIVITY_SERVICE_HELPER.save(activities.toArray(new DynamicObject[0]));
            signApply.set("activityplan", (Object)activityPlan.getLong("id"));
            APPLY_SERVICE_HELPER.updateOne(signApply);
        }
    }

    @Override
    public void handleMessage(JSONObject message) {
        Long activityId = message.getLong(ACTIVITY_ID);
        Long instanceId = message.getLong(INSTANCE_ID);
        Long bizBillId = message.getLong(BIZ_BILL_ID);
        String sla = message.getString(SLA);
        BusinessStatusEnum businessStatusEnum = ActivityUtils.getBusinessStatus(activityId);
        DynamicObject signBill = APPLY_SERVICE_HELPER.queryOne("billno,businessstatus,deadline,signstatus,activityins", (Object)bizBillId);
        QFilter signBillFilter = new QFilter("signapply", "=", (Object)bizBillId);
        QFilter activityFilter = new QFilter("activity", "=", (Object)activityId);
        DynamicObject curActivity = ACTIVITY_SERVICE_HELPER.queryOne("activityins,deadline,processstatus", new QFilter[]{signBillFilter, activityFilter});
        if (businessStatusEnum != null) {
            LOGGER.info("handleMessage bizBillId:{},activityId:{},businessStatus:{}", new Object[]{bizBillId, activityId, businessStatusEnum.getCombKey()});
            if (businessStatusEnum == BusinessStatusEnum.CHECK) {
                signBill.set("signstatus", (Object)SignStatusEnum.COMPLETE_SIGN.getCombKey());
            }
            signBill.set("businessstatus", (Object)businessStatusEnum.getCombKey());
        } else {
            LOGGER.info("handleMessage bizBillId:{},activityId:{},businessStatus:{}", new Object[]{bizBillId, activityId, "null"});
        }
        signBill.set("activityins", (Object)instanceId);
        curActivity.set("activityins", (Object)instanceId);
        curActivity.set("processstatus", (Object)ProcessStatusEnum.PENDING.getValue());
        if (HRStringUtils.isNotEmpty((String)sla) && Long.parseLong(sla) != 0L) {
            Date deadline = HRDateTimeUtils.addHour((Date)new Date(), (long)Long.parseLong(sla));
            signBill.set("deadline", (Object)deadline);
            curActivity.set("deadline", (Object)deadline);
        } else {
            signBill.set("deadline", null);
        }
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, ISignActivityExt.class, (String)"kd.sdk.hr.hlcm.business.activity.ISignActivityExt", null);
        hrPluginProxy.callReplace(hrPlugin -> {
            hrPlugin.setSignBillValue(signBill, message);
            hrPlugin.setCurActivityValue(curActivity, message);
            return null;
        });
        ACTIVITY_SERVICE_HELPER.updateOne(curActivity);
        APPLY_SERVICE_HELPER.updateOne(signBill);
        try (TXHandle notSupported = TX.notSupported();){
            String taskSwitch = message.getString("taskSwitch");
            LOGGER.info("impl.SignActivity.handleMessage.taskSwitch:{}", (Object)taskSwitch);
            String paramId = "";
            paramId = HRStringUtils.equals((String)"3", (String)taskSwitch) ? String.valueOf(curActivity.getLong("id")) : String.valueOf(bizBillId);
            HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSActivityService", (String)"updateTaskBindBillInfo", (Object[])new Object[]{instanceId, paramId, signBill.get("billno")});
        }
        LOGGER.info("handleMessage end bizBillId:{},activityId:{}", (Object)bizBillId, (Object)activityId);
    }

    @Override
    public void batchTerminateActivities(List<Long> signBillIds) {
        signBillIds.forEach(this::abandonForce);
    }

    @Override
    public void terminateActivity(DynamicObject signApplyDy) {
        long pkValue = signApplyDy.getLong("id");
        this.handleProcessStatus(pkValue);
        this.cancel(signApplyDy);
        this.abandonForce(pkValue);
    }

    @Override
    public void terminateActivity(DynamicObject signApplyDy, String formId) {
        long pkValue = signApplyDy.getLong("id");
        try {
            this.terminateOrDeleteTask(signApplyDy, formId, null);
        }
        catch (Exception exe) {
            LOGGER.error("SignActivity.terminateActivity.terminateOrDeleteTask", (Throwable)exe);
        }
        this.handleProcessStatus(pkValue);
        this.cancel(signApplyDy);
        this.abandonForce(pkValue);
    }

    @Override
    public void terminateOrDeleteTask(DynamicObject signApplyDy, String formId, String showWay) {
        LOGGER.info("SignActivity.terminateOrDeleteTask.signApplyDy={},formId={}", (Object)signApplyDy, (Object)formId);
        boolean openHrssc = HRBaseDataConfigUtil.getOpenhrssc();
        if (!openHrssc) {
            LOGGER.warn("hlcm.SignActivity.terminateOrDeleteTask, openHrssc is false");
            return;
        }
        HashMap billIdMap = new HashMap(2);
        HashMap<String, Long> billInfo = new HashMap<String, Long>(2);
        billInfo.put("currentPersonId", 0L);
        billIdMap.put(signApplyDy.getLong("id"), billInfo);
        HashMap<String, Long> params = new HashMap<String, Long>(2);
        params.put("operatorId", RequestContext.get().getCurrUserId());
        if (HRStringUtils.equals((String)"hstc", (String)showWay)) {
            params.put("operatorId", null);
        }
        LOGGER.info("terminateOrDeleteTask.HRMServiceHelper.invokeBizService.params={}", params);
        Object result = HRMServiceHelper.invokeBizService((String)"ssc", (String)"hstc", (String)"ITaskService", (String)"terminateOrDeleteTask", (Object[])new Object[]{formId, billIdMap, params});
        LOGGER.info("SignActivity.terminateOrDeleteTask={}", result);
    }

    private void cancel(DynamicObject signApplyDy) {
        try (TXHandle notSupported = TX.notSupported();){
            ISignManageService.getInstance().cancel(signApplyDy);
        }
    }

    @Override
    public void deletePreActivity(Object ... signApplyIds) {
        QFilter billFilter = new QFilter("signapply", "in", (Object)signApplyIds);
        ACTIVITY_SERVICE_HELPER.deleteByFilter(new QFilter[]{billFilter});
        QFilter idFilter = new QFilter("id", "in", (Object)signApplyIds);
        DynamicObject[] signBills = APPLY_SERVICE_HELPER.query("activityplan", new QFilter[]{idFilter});
        Stream.of(signBills).forEach(entity -> entity.set("activityplan", (Object)0L));
        APPLY_SERVICE_HELPER.update(signBills);
    }

    @Override
    public void assignTask(Long activityInsId, List<Long> handlerIds) {
        if (HRObjectUtils.isEmpty((Object)activityInsId) || this.isShare(activityInsId)) {
            LOGGER.info("assignTask activityInsId:{} is isEmpty or Share", (Object)activityInsId);
            return;
        }
        LOGGER.info("assignTask activityInsId:{},handlerIds:{}", (Object)activityInsId, (Object)handlerIds.toString());
        try (TXHandle notSupported = TX.notSupported();){
            HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSActivityService", (String)"assignTask", (Object[])new Object[]{activityInsId, handlerIds, ""});
        }
        LOGGER.info("assignTask end");
    }

    @Override
    public void batchAssignTask(List<Long> activityInsIds, List<Long> handlerIds) {
        if (activityInsIds == null || activityInsIds.size() == 0) {
            return;
        }
        Map<Long, Boolean> shareMap = this.isShare(activityInsIds);
        LOGGER.info("batchAssignTask shareMap:{}", shareMap);
        Set<Long> keys = shareMap.keySet();
        keys.removeIf(shareMap::get);
        activityInsIds = Lists.newArrayList(keys);
        LOGGER.info("batchAssignTask activityInsIds:{},handlerIds:{}", (Object)activityInsIds, (Object)handlerIds.toString());
        try (TXHandle notSupported = TX.notSupported();){
            HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSActivityService", (String)"batchAssignTask", (Object[])new Object[]{activityInsIds, handlerIds, ""});
        }
        LOGGER.info("batchAssignTask end");
    }

    @Override
    public void assignAndConsentTask(Long activityInsId, String formId) {
        Long currUserId = RequestContext.get().getCurrUserId();
        this.assignAndConsentTask(activityInsId, currUserId, formId);
    }

    @Override
    public void batchAssignAndConsentTask(List<Long> activityInsIds, String formId) {
        Long currUserId = RequestContext.get().getCurrUserId();
        this.batchAssignAndConsentTask(activityInsIds, currUserId, formId);
    }

    @Override
    public void assignAndConsentTask(Long activityInsId, Long userId, String formId) {
        LOGGER.info("assignAndConsentTask activityInsId:{},userId:{},formId:{}", new Object[]{activityInsId, userId, formId});
        if (HRObjectUtils.isEmpty((Object)activityInsId)) {
            return;
        }
        if (!CommonRepository.isExists("hrcs_activityins", new QFilter[]{new QFilter("id", "=", (Object)activityInsId), new QFilter("bindbizkey", "=", (Object)formId)})) {
            return;
        }
        this.assignTask(activityInsId, Lists.newArrayList((Object[])new Long[]{userId}));
        try (TXHandle notSupported = TX.notSupported();){
            HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSActivityService", (String)"consentTask", (Object[])new Object[]{activityInsId, ""});
        }
        LOGGER.info("assignAndConsentTask end");
    }

    @Override
    public void batchAssignAndConsentTask(List<Long> activityInsIds, Long userId, String formId) {
        LOGGER.info("batchAssignAndConsentTask activityInsIds:{},userId:{},formId:{}", new Object[]{activityInsIds, userId, formId});
        if (activityInsIds == null || activityInsIds.size() == 0) {
            return;
        }
        DynamicObject[] activityIns = CommonRepository.query("hrcs_activityins", "id", new QFilter[]{new QFilter("id", "in", activityInsIds), new QFilter("bindbizkey", "=", (Object)formId)});
        if (activityIns.length == 0) {
            return;
        }
        this.handlebatchAssignAndConsentTask(activityInsIds, userId);
        LOGGER.info("batchAssignAndConsentTask end");
    }

    @Override
    public void assignAndConsentTask(Long activityInsId, SignTabEnum signTabEnum) {
        Long currUserId = RequestContext.get().getCurrUserId();
        this.assignAndConsentTask(activityInsId, currUserId, signTabEnum);
    }

    @Override
    public void batchAssignAndConsentTask(List<Long> activityInsIds, SignTabEnum signTabEnum) {
        Long currUserId = RequestContext.get().getCurrUserId();
        this.batchAssignAndConsentTask(activityInsIds, currUserId, signTabEnum);
    }

    @Override
    public void assignAndConsentTask(Long activityInsId, Long userId, SignTabEnum signTabEnum) {
        LOGGER.info("assignAndConsentTask activityInsId:{},userId:{},signTabEnum:{}", new Object[]{activityInsId, userId, signTabEnum});
        if (HRObjectUtils.isEmpty((Object)activityInsId)) {
            return;
        }
        if (!CommonRepository.isExists("hrcs_activityins", new QFilter[]{new QFilter("id", "=", (Object)activityInsId), new QFilter("activity.id", "=", (Object)signTabEnum.getActivityId())})) {
            return;
        }
        this.assignTask(activityInsId, Lists.newArrayList((Object[])new Long[]{userId}));
        try (TXHandle notSupported = TX.notSupported();){
            HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSActivityService", (String)"consentTask", (Object[])new Object[]{activityInsId, ""});
        }
        LOGGER.info("assignAndConsentTask end");
    }

    @Override
    public void batchAssignAndConsentTask(List<Long> activityInsIds, Long userId, SignTabEnum signTabEnum) {
        LOGGER.info("batchAssignAndConsentTask activityInsIds:{},userId:{},signTabEnum:{}", new Object[]{activityInsIds, userId, signTabEnum});
        if (activityInsIds == null || activityInsIds.size() == 0) {
            return;
        }
        DynamicObject[] activityIns = CommonRepository.query("hrcs_activityins", "id", new QFilter[]{new QFilter("id", "in", activityInsIds), new QFilter("activity.id", "=", (Object)signTabEnum.getActivityId())});
        if (activityIns.length == 0) {
            return;
        }
        this.handlebatchAssignAndConsentTask(activityInsIds, userId);
        LOGGER.info("batchAssignAndConsentTask end");
    }

    private void handlebatchAssignAndConsentTask(List<Long> activityInsIds, Long userId) {
        this.batchAssignTask(activityInsIds, Lists.newArrayList((Object[])new Long[]{userId}));
        try (TXHandle notSupported = TX.notSupported();){
            HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSActivityService", (String)"batchConsentTask", (Object[])new Object[]{activityInsIds, ""});
        }
        DynamicObject[] activities = ACTIVITY_SERVICE_HELPER.query(String.join((CharSequence)",", "processstatus", "processtime"), new QFilter[]{new QFilter("activityins", "in", activityInsIds)});
        Arrays.stream(activities).forEach(activity -> {
            activity.set("processstatus", (Object)ProcessStatusEnum.PROCESSED.getValue());
            activity.set("processtime", (Object)new Date());
        });
        ACTIVITY_SERVICE_HELPER.update(activities);
    }

    private void abandonForce(Long businessKey) {
        LOGGER.info("begin abandonForce businessKey|{}", (Object)businessKey);
        if (Objects.isNull(businessKey)) {
            LOGGER.warn("abandonForce businessKey is null");
            return;
        }
        DynamicObject dy = APPLY_SERVICE_HELPER.queryOne("activityins.id", (Object)businessKey);
        long activityIns = dy.getLong("activityins.id");
        if (activityIns != 0L) {
            this.assignTask(activityIns, Lists.newArrayList((Object[])new Long[]{RequestContext.get().getCurrUserId()}));
            try (TXHandle notSupported = TX.notSupported();){
                HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSActivityService", (String)"terminateTask", (Object[])new Object[]{activityIns, ""});
            }
        }
        WorkflowService workflowService = (WorkflowService)ServiceFactory.getService(IWorkflowService.class);
        ManagementService managementService = workflowService.getManagementService();
        Long procInstId = workflowService.getProcessInstanceIdByBusinessKey(businessKey.toString());
        if (HRObjectUtils.isEmpty((Object)procInstId) || procInstId == 0L) {
            return;
        }
        try (TXHandle notSupported = TX.notSupported();){
            managementService.abandonProInstance(procInstId.longValue());
        }
        catch (Exception exp) {
            LOGGER.error("abandonForce businessKey|{} error", (Object)businessKey, (Object)exp);
        }
        LOGGER.info("abandonForce businessKey|{} success", (Object)businessKey);
    }

    @Override
    public Map<DynamicObject, DynamicObject> getNextActivityMap(DynamicObject[] signBills) {
        ArrayList<Long> ids = new ArrayList<Long>(signBills.length);
        HashMap signBillMap = new HashMap(signBills.length);
        Arrays.stream(signBills).forEach(signBill -> {
            long id = signBill.getLong("id");
            ids.add(id);
            signBillMap.put(id, signBill);
        });
        DynamicObject[] activityArray = ActivityRepository.getInstance().querySignApplyActivities(ids);
        Map<DynamicObject, List<DynamicObject>> signApplyActivitiesMap = Arrays.stream(activityArray).collect(Collectors.groupingBy(activity -> activity.getDynamicObject("signapply")));
        HashMap<DynamicObject, DynamicObject> nextActivityMap = new HashMap<DynamicObject, DynamicObject>(signBills.length);
        signApplyActivitiesMap.forEach((signBillToBase, activities) -> {
            DynamicObject signBill = (DynamicObject)signBillMap.get(signBillToBase.getLong("id"));
            nextActivityMap.put(signBill, this.getNextActivity(signBill, (List<DynamicObject>)activities));
        });
        return nextActivityMap;
    }

    @Override
    public boolean isExistActivity(long signBillId, String formId) {
        QFilter[] filters = new QFilter[]{new QFilter("activity.bizobj.number", "=", (Object)formId), new QFilter("signapply", "=", (Object)signBillId)};
        return HLCMCommonRepository.exist("hlcm_activity", filters);
    }

    @Override
    public void batchRevocation(List<String> bizBillIds, Long userId) {
        HRBaseServiceHelper insHelper = new HRBaseServiceHelper("hrcs_activityins");
        DynamicObject[] queryResult = insHelper.query(BIZ_BILL_ID, new QFilter[]{new QFilter(BIZ_BILL_ID, "in", bizBillIds)});
        List bizBillIdsWithIns = Stream.of(queryResult).map(dy -> dy.getString(BIZ_BILL_ID)).collect(Collectors.toList());
        LOGGER.info("batchRevocation_bizBillIdsWithIns_size:{}", (Object)bizBillIds.toString());
        if (CollectionUtils.isEmpty(bizBillIdsWithIns)) {
            LOGGER.info("batchRevocation_bizBillIdsWithIns_null");
            return;
        }
        try (TXHandle txHandle = TX.notSupported();){
            OperationResult result = (OperationResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSActivityService", (String)"batchRevocation", (Object[])new Object[]{bizBillIdsWithIns, userId});
            LOGGER.info("IHRCSActivityService_batchRevocation_result|{}", (Object)JSON.toJSONString((Object)result));
            if (!result.isSuccess()) {
                LOGGER.error("IHRCSActivityService_batchRevocation_result_message|{}", (Object)result.getMessage());
            }
        }
        catch (Exception exp) {
            LOGGER.error("batchRevocation_bizBillIds_error", (Throwable)exp);
        }
    }

    @Override
    public void batchDealShareCenterTask() {
    }

    private DynamicObject getNextActivity(DynamicObject signBill, List<DynamicObject> activities) {
        activities.sort((e1, e2) -> e1.getString("activity.number").compareToIgnoreCase(e2.getString("activity.number")));
        long activityInsId = signBill.getLong("activityins.id");
        String handStatus = signBill.getString("handlestatus");
        if (HRStringUtils.equals((String)handStatus, (String)HandleStatusEnum.PROCESSEND.getCombKey()) || HRStringUtils.equals((String)handStatus, (String)HandleStatusEnum.ARCHIVE.getCombKey())) {
            return null;
        }
        if (activityInsId == 0L && HRStringUtils.equals((String)handStatus, (String)HandleStatusEnum.PROCESSIN.getCombKey())) {
            return activities.get(0);
        }
        for (int i = 0; i < activities.size() - 1; ++i) {
            if (activityInsId != activities.get(i).getLong("activityins.id")) continue;
            return activities.get(i + 1);
        }
        return null;
    }

    private void handleProcessStatus(long pkValue) {
        QFilter signApplyIdFilter = new QFilter("signapply", "=", (Object)pkValue);
        ArrayList activityStatusList = Lists.newArrayList((Object[])new String[]{ProcessStatusEnum.PENDING.getValue(), ProcessStatusEnum.PROCESSING.getValue(), ProcessStatusEnum.PROCESSING_FAIL.getValue()});
        QFilter processStatusFilter = new QFilter("processstatus", "in", (Object)activityStatusList);
        DynamicObject[] activities = CommonRepository.query("hlcm_activity", "processstatus", new QFilter[]{signApplyIdFilter, processStatusFilter});
        if (activities.length == 0) {
            return;
        }
        Stream.of(activities).forEach(activity -> activity.set("processstatus", (Object)ProcessStatusEnum.TERMINATED.getValue()));
        CommonRepository.updateDynamicObject("hlcm_activity", activities);
    }

    private Map<Long, Boolean> isShare(List<Long> activityInsIds) {
        DynamicObject[] taskSwitchDys = CommonRepository.queryByIds("hrcs_activityins", "taskswitch", activityInsIds);
        HashMap result = Maps.newHashMapWithExpectedSize((int)taskSwitchDys.length);
        for (DynamicObject taskSwitchDy : taskSwitchDys) {
            Boolean isShare = Boolean.FALSE;
            if (taskSwitchDy.getDataEntityType().getProperties().containsKey((Object)"taskswitch")) {
                isShare = HRStringUtils.equals((String)taskSwitchDy.getString("taskswitch"), (String)"3");
            }
            result.put(taskSwitchDy.getLong("id"), isShare);
        }
        return result;
    }

    private boolean isShare(Long activityInsId) {
        Map<Long, Boolean> result = this.isShare(Lists.newArrayList((Object[])new Long[]{activityInsId}));
        return result.getOrDefault(activityInsId, Boolean.FALSE);
    }
}

