/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.domian.service.common;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.domian.service.common.MulSelectConfirmTemplate;
import kd.hr.hlcm.business.domian.service.common.TemplateAnnotation;
import kd.hr.hlcm.business.domian.service.common.template.ArchiveTemplate;
import kd.hr.hlcm.business.domian.service.common.template.BeginSignTemplate;
import kd.hr.hlcm.business.domian.service.common.template.CompanySignTemplate;
import kd.hr.hlcm.business.domian.service.common.template.CompleteSignTemplate;
import kd.hr.hlcm.business.domian.service.common.template.ConfirmArchiveTemplate;
import kd.hr.hlcm.business.domian.service.common.template.SubmitContractApplyTemplate;
import kd.hr.hlcm.business.domian.service.common.template.SubmitEffectContractApplyTemplate;
import kd.hr.hlcm.business.domian.service.common.template.UnSubmitContractApplyTemplate;

public enum MulSelectConfirmEnum {
    INSTANCE;

    private static final Map<String, MulSelectConfirmTemplate> TEMPLATE_MAP;
    private static final Log LOGGER;

    public static MulSelectConfirmTemplate getTemplate(String operateKey) {
        if (HRStringUtils.isEmpty((String)operateKey)) {
            return null;
        }
        return TEMPLATE_MAP.get(operateKey);
    }

    static {
        TEMPLATE_MAP = new HashMap<String, MulSelectConfirmTemplate>(8);
        LOGGER = LogFactory.getLog(MulSelectConfirmEnum.class);
        HashSet<Class> set = new HashSet<Class>(8);
        set.add(BeginSignTemplate.class);
        set.add(CompanySignTemplate.class);
        set.add(CompleteSignTemplate.class);
        set.add(ConfirmArchiveTemplate.class);
        set.add(ArchiveTemplate.class);
        set.add(SubmitContractApplyTemplate.class);
        set.add(SubmitEffectContractApplyTemplate.class);
        set.add(UnSubmitContractApplyTemplate.class);
        try {
            for (Class dict : set) {
                Constructor constructor = dict.getDeclaredConstructor(new Class[0]);
                TemplateAnnotation templateAnnotation = dict.getAnnotation(TemplateAnnotation.class);
                TEMPLATE_MAP.put(templateAnnotation.operateKey(), (MulSelectConfirmTemplate)constructor.newInstance(new Object[0]));
            }
        }
        catch (Exception e) {
            LOGGER.error("init template map error", (Throwable)e);
        }
        LOGGER.info("init template keys:{}", TEMPLATE_MAP.keySet());
    }
}

