/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.domian.service.common;

import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hlcm.business.domian.repository.CommonRepository;

public interface MulSelectConfirmTemplate {
    public static final Log LOGGER = LogFactory.getLog(MulSelectConfirmTemplate.class);

    public String getName();

    public String getFileName();

    public String getEmptySelectMessage();

    public String getSingleOkSuccessMessage();

    public Map<Long, String> validate(DynamicObject[] var1);

    public Map<Long, String> doOperation(List<Long> var1);

    public void singleOkCancelBox(IFormView var1, Object var2, ConfirmCallBackListener var3);

    public void multiOkCancelBox(IFormView var1, ConfirmCallBackListener var2);

    public List<HRExportHeadObject> getMulSelectConfirmExcelHead(String var1);

    public List<HRExportHeadObject> getConfirmResultExcelHead(String var1);

    public List<Map<String, Object>> getMulSelectConfirmExportData(Object[] var1, Map<Object, String> var2, String var3);

    public List<Map<String, Object>> getConfirmResultExportData(Object[] var1, Map<Object, String> var2, String var3);

    default public String invokeOperation(IFormView formView, String operationKey, Object[] pkValues) {
        try {
            String billFormId = null;
            if (formView instanceof IListView) {
                billFormId = ((IListView)formView).getBillFormId();
            } else if (formView instanceof IBillView) {
                billFormId = formView.getEntityId();
            } else {
                LOGGER.warn("billFormId is not instanceof IListView or IBillView");
            }
            LOGGER.info("invoke operation billFormId:{},operationKey:{},pkValues:{}", new Object[]{billFormId, operationKey, pkValues});
            String appId = formView.getFormShowParameter().getAppId();
            LOGGER.info("invoke operation appId|{}", (Object)appId);
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("currbizappid", appId);
            OperationResult operationResult = formView instanceof IListView ? OperationServiceHelper.executeOperate((String)operationKey, (String)billFormId, (Object[])pkValues, (OperateOption)operateOption) : formView.invokeOperation(operationKey, operateOption);
            if (operationResult != null && !operationResult.isSuccess()) {
                List validateErrors = operationResult.getAllErrorOrValidateInfo();
                if (validateErrors.size() > 0) {
                    return ((IOperateInfo)validateErrors.get(0)).getMessage();
                }
                return operationResult.getMessage();
            }
        }
        catch (Exception e) {
            LOGGER.error("invoke operation error", (Throwable)e);
            return e.getMessage();
        }
        return null;
    }

    default public String getActivityEmpName(IFormView formView, Object pkValue) {
        String empName;
        if (formView instanceof IListView) {
            DynamicObject activity = CommonRepository.queryById("hlcm_activity", "signapply", (Long)pkValue);
            empName = activity.getDynamicObject("signapply").getString("empname");
        } else {
            empName = formView.getModel().getDataEntity().getString("empname");
        }
        return empName;
    }

    default public String getEmpName(IFormView formView, Object pkValue) {
        String empName;
        if (formView instanceof IListView) {
            DynamicObject dynamicObject = CommonRepository.queryById("hlcm_contractapplybase", "empname", (Long)pkValue);
            empName = dynamicObject.getString("empname");
        } else {
            empName = formView.getModel().getDataEntity().getString("empname");
        }
        return empName;
    }

    default public Boolean isShowComment() {
        return Boolean.FALSE;
    }
}

