/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.domian.service.common.template;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.base.utils.msg.MultiLangEnumBridge;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.domian.repository.ActivityRepository;
import kd.hr.hlcm.business.domian.repository.CommonRepository;
import kd.hr.hlcm.business.domian.service.common.MulSelectConfirmTemplate;
import kd.hr.hlcm.business.domian.service.common.TemplateAnnotation;
import kd.hr.hlcm.business.domian.service.signmgt.ISignManageService;
import kd.hr.hlcm.common.enums.ActivityProcessStatusEnum;

@TemplateAnnotation(operateKey="companysign")
public class CompanySignTemplate
implements MulSelectConfirmTemplate {
    @Override
    public String getName() {
        return ResManager.loadKDString((String)"\u4f01\u4e1a\u7b7e\u7f72", (String)"CompanySignTemplate_0", (String)"hr-hlcm-business", (Object[])new Object[0]);
    }

    @Override
    public String getFileName() {
        return ResManager.loadKDString((String)"\u4f01\u4e1a\u7b7e\u7f72\u6570\u636e", (String)"CompanySignTemplate_1", (String)"hr-hlcm-business", (Object[])new Object[0]);
    }

    @Override
    public String getEmptySelectMessage() {
        return ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u8fdb\u884c\u4f01\u4e1a\u7b7e\u7f72\u7684\u5355\u636e\u3002", (String)"CompanySignTemplate_2", (String)"hr-hlcm-business", (Object[])new Object[0]);
    }

    @Override
    public String getSingleOkSuccessMessage() {
        return ResManager.loadKDString((String)"\u5df2\u53d1\u8d77\u4f01\u4e1a\u7b7e\u7f72\uff0c\u8bf7\u7a0d\u540e\u5237\u65b0\u67e5\u770b\u3002", (String)"CompanySignTemplate_15", (String)"hr-hlcm-business", (Object[])new Object[0]);
    }

    @Override
    public Boolean isShowComment() {
        return Boolean.TRUE;
    }

    @Override
    public Map<Long, String> validate(DynamicObject[] dynamicObjects) {
        HashMap<Long, String> resultMap = new HashMap<Long, String>(dynamicObjects.length);
        DynamicObject[] activities = ActivityRepository.getInstance().queryCompanySignActivities(Arrays.stream(dynamicObjects).map(dy -> dy.getLong("id")).collect(Collectors.toList()));
        Map<Long, ActivityProcessStatusEnum> activityStatusEnumMap = ISignManageService.getInstance().getActivityProcessStatusEnumMap(activities);
        HashSet companySignStatusSet = Sets.newHashSet((Object[])new Object[]{ActivityProcessStatusEnum.E_CSIGN_PENDING, ActivityProcessStatusEnum.E_CSIGN_PROCESSING, ActivityProcessStatusEnum.E_CSIGN_PROCESSING_FAIL});
        Arrays.stream(dynamicObjects).forEach(signBill -> {
            Long id = signBill.getLong("id");
            ActivityProcessStatusEnum activityProcessStatusEnum = (ActivityProcessStatusEnum)activityStatusEnumMap.get(id);
            String activityStatus = Optional.ofNullable(activityProcessStatusEnum).map(ActivityProcessStatusEnum::getDesc).map(MultiLangEnumBridge::loadKDString).orElse(null);
            String result = null;
            if (!companySignStatusSet.contains(activityProcessStatusEnum)) {
                result = activityStatus != null ? String.format(Locale.ROOT, ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5f53\u524d\u6d3b\u52a8\u72b6\u6001\u4e3a%s\uff0c\u4e0d\u53ef\u64cd\u4f5c\u4f01\u4e1a\u7b7e\u7f72\u3002", (String)"CompanySignTemplate_4", (String)"hr-hlcm-business", (Object[])new Object[0]), activityStatus) : ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5f53\u524d\u6d3b\u52a8\u72b6\u6001\u5b58\u5728\u5f02\u5e38\uff0c\u4e0d\u53ef\u64cd\u4f5c\u4f01\u4e1a\u7b7e\u7f72\u3002", (String)"CompanySignTemplate_13", (String)"hr-hlcm-business", (Object[])new Object[0]);
            }
            resultMap.put(id, result);
        });
        return resultMap;
    }

    @Override
    public Map<Long, String> doOperation(List<Long> ids) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)ids.size());
        DynamicObject[] signBills = CommonRepository.queryByIds("hlcm_contractapplybase", null, ids);
        Arrays.stream(signBills).forEach(signBill -> {
            String result = ISignManageService.getInstance().companySignHandler((DynamicObject)signBill);
            if (HRStringUtils.isNotEmpty((String)result)) {
                resultMap.put(signBill.getLong("id"), result);
            }
        });
        return resultMap;
    }

    @Override
    public void singleOkCancelBox(IFormView formView, Object pkValue, ConfirmCallBackListener confirmCallBackListener) {
        formView.showConfirm(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5c06\u4e3a%s\u7684\u5408\u540c\u53d1\u8d77\u4f01\u4e1a\u7b7e\u7f72\uff0c\u53d1\u8d77\u6210\u529f\u540e\u53ef\u5237\u65b0\u9875\u9762\u67e5\u770b\u7b7e\u7f72\u7ed3\u679c\u3002\u82e5\u7b7e\u7f72\u6210\u529f\u3002\u6d3b\u52a8\u72b6\u6001\u5c06\u66f4\u65b0\u4e3a\u201c\u5df2\u7b7e\u7f72\u201d\u4e14\u65e0\u6cd5\u64a4\u9500\uff1b\u82e5\u7b7e\u7f72\u5931\u8d25\u53ef\u91cd\u65b0\u53d1\u8d77\u7b7e\u7f72\u3002\u8bf7\u52a1\u5fc5\u4ed4\u7ec6\u6838\u5bf9\uff0c\u786e\u5b9a\u7ee7\u7eed\u5417\uff1f", (String)"CompanySignTemplate_5", (String)"hr-hlcm-business", (Object[])new Object[0]), this.getActivityEmpName(formView, pkValue)), MessageBoxOptions.OKCancel, confirmCallBackListener);
    }

    @Override
    public void multiOkCancelBox(IFormView formView, ConfirmCallBackListener confirmCallBackListener) {
        formView.showConfirm(ResManager.loadKDString((String)"\u5c06\u4e3a\u6240\u9009\u5458\u5de5\u7684\u5408\u540c\u53d1\u8d77\u4f01\u4e1a\u7b7e\u7f72\uff0c\u53d1\u8d77\u6210\u529f\u540e\u53ef\u5237\u65b0\u9875\u9762\u67e5\u770b\u7b7e\u7f72\u7ed3\u679c\u3002\u82e5\u7b7e\u7f72\u6210\u529f\uff0c\u6d3b\u52a8\u72b6\u6001\u5c06\u66f4\u65b0\u4e3a\u201c\u5df2\u7b7e\u7f72\u201d\u4e14\u65e0\u6cd5\u64a4\u9500\uff1b\u82e5\u7b7e\u7f72\u5931\u8d25\u53ef\u91cd\u65b0\u53d1\u8d77\u3002\u8bf7\u52a1\u5fc5\u4ed4\u7ec6\u6838\u5bf9\uff0c\u786e\u5b9a\u7ee7\u7eed\u5417\uff1f", (String)"CompanySignTemplate_3", (String)"hr-hlcm-business", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
    }

    @Override
    public List<HRExportHeadObject> getMulSelectConfirmExcelHead(String formId) {
        List<HRExportHeadObject> headObjectList = ISignManageService.getInstance().getMulSelectConfirmExcelHead(formId);
        headObjectList.add(new HRExportHeadObject("islegal", ResManager.loadKDString((String)"\u662f\u5426\u53ef\u64cd\u4f5c\u4f01\u4e1a\u7b7e\u7f72", (String)"CompanySignTemplate_7", (String)"hr-hlcm-business", (Object[])new Object[0])));
        headObjectList.add(new HRExportHeadObject("reason", ResManager.loadKDString((String)"\u4e0d\u53ef\u64cd\u4f5c\u4f01\u4e1a\u7b7e\u7f72\u539f\u56e0\u3002", (String)"CompanySignTemplate_8", (String)"hr-hlcm-business", (Object[])new Object[0])));
        return headObjectList;
    }

    @Override
    public List<HRExportHeadObject> getConfirmResultExcelHead(String formId) {
        List<HRExportHeadObject> headObjectList = ISignManageService.getInstance().getMulSelectConfirmExcelHead(formId);
        headObjectList.add(new HRExportHeadObject("islegal", ResManager.loadKDString((String)"\u662f\u5426\u53d1\u8d77\u6210\u529f", (String)"CompanySignTemplate_11", (String)"hr-hlcm-business", (Object[])new Object[0])));
        headObjectList.add(new HRExportHeadObject("reason", ResManager.loadKDString((String)"\u53d1\u8d77\u4f01\u4e1a\u7b7e\u7f72\u5931\u8d25\u539f\u56e0", (String)"CompanySignTemplate_12", (String)"hr-hlcm-business", (Object[])new Object[0])));
        return headObjectList;
    }

    @Override
    public List<Map<String, Object>> getMulSelectConfirmExportData(Object[] pkValues, Map<Object, String> preErrorInfoMap, String formId) {
        return ISignManageService.getInstance().activityPreValidateExportData(pkValues, preErrorInfoMap);
    }

    @Override
    public List<Map<String, Object>> getConfirmResultExportData(Object[] pkValues, Map<Object, String> errorMap, String formId) {
        return ISignManageService.getInstance().activityPreValidateExportData(pkValues, errorMap);
    }
}

