/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.domian.service.common.template;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.base.utils.msg.MultiLangEnumBridge;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.domian.repository.ActivityRepository;
import kd.hr.hlcm.business.domian.repository.CommonRepository;
import kd.hr.hlcm.business.domian.service.activity.ISignActivity;
import kd.hr.hlcm.business.domian.service.common.MulSelectConfirmTemplate;
import kd.hr.hlcm.business.domian.service.common.TemplateAnnotation;
import kd.hr.hlcm.business.domian.service.signmgt.ISignManageService;
import kd.hr.hlcm.common.enums.ActivityProcessStatusEnum;

@TemplateAnnotation(operateKey="compsign")
public class CompleteSignTemplate
implements MulSelectConfirmTemplate {
    @Override
    public String getName() {
        return ResManager.loadKDString((String)"\u5b8c\u6210\u7b7e\u7f72", (String)"CompleteSignTemplate_0", (String)"hr-hlcm-business", (Object[])new Object[0]);
    }

    @Override
    public String getFileName() {
        return ResManager.loadKDString((String)"\u5b8c\u6210\u7b7e\u7f72\u6570\u636e", (String)"CompleteSignTemplate_1", (String)"hr-hlcm-business", (Object[])new Object[0]);
    }

    @Override
    public String getEmptySelectMessage() {
        return ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u5b8c\u6210\u7b7e\u7f72\u7684\u5355\u636e\u3002", (String)"CompleteSignTemplate_2", (String)"hr-hlcm-business", (Object[])new Object[0]);
    }

    @Override
    public String getSingleOkSuccessMessage() {
        return ResManager.loadKDString((String)"\u5b8c\u6210\u7b7e\u7f72\u6210\u529f\u3002", (String)"CompleteSignTemplate_15", (String)"hr-hlcm-business", (Object[])new Object[0]);
    }

    @Override
    public Map<Long, String> validate(DynamicObject[] dynamicObjects) {
        HashMap<Long, String> resultMap = new HashMap<Long, String>(dynamicObjects.length);
        DynamicObject[] activities = ActivityRepository.getInstance().queryCompSignActivities(Arrays.stream(dynamicObjects).map(dy -> dy.getLong("id")).collect(Collectors.toList()));
        Map<Long, ActivityProcessStatusEnum> activityProcessStatusEnumMap = ISignManageService.getInstance().getActivityProcessStatusEnumMap(activities);
        Arrays.stream(dynamicObjects).forEach(signBill -> {
            long id = signBill.getLong("id");
            ActivityProcessStatusEnum activityProcessStatusEnum = (ActivityProcessStatusEnum)activityProcessStatusEnumMap.get(id);
            String activityStatus = Optional.ofNullable(activityProcessStatusEnum).map(ActivityProcessStatusEnum::getDesc).map(MultiLangEnumBridge::loadKDString).orElse(null);
            String result = null;
            if (activityProcessStatusEnum != ActivityProcessStatusEnum.P_COMP_PENDING) {
                result = activityStatus != null ? String.format(Locale.ROOT, ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5f53\u524d\u6d3b\u52a8\u72b6\u6001\u4e3a%s\uff0c\u4e0d\u53ef\u64cd\u4f5c\u5b8c\u6210\u7b7e\u7f72\u3002", (String)"CompleteSignTemplate_4", (String)"hr-hlcm-business", (Object[])new Object[0]), activityStatus) : ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5f53\u524d\u6d3b\u52a8\u72b6\u6001\u5b58\u5728\u5f02\u5e38\uff0c\u4e0d\u53ef\u64cd\u4f5c\u5b8c\u6210\u7b7e\u7f72\u3002", (String)"CompleteSignTemplate_13", (String)"hr-hlcm-business", (Object[])new Object[0]);
            }
            resultMap.put(id, result);
        });
        return resultMap;
    }

    @Override
    public Map<Long, String> doOperation(List<Long> ids) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)ids.size());
        DynamicObject[] signBills = CommonRepository.queryByIds("hlcm_contractapplybase", null, ids);
        Map<DynamicObject, DynamicObject> nextActivityMap = ISignActivity.getInstance().getNextActivityMap(signBills);
        nextActivityMap.forEach((signBill, nextActivity) -> {
            String result = ISignManageService.getInstance().completeSignHandler((DynamicObject)signBill, (DynamicObject)nextActivity);
            if (HRStringUtils.isNotEmpty((String)result)) {
                resultMap.put(signBill.getLong("id"), result);
            }
        });
        return resultMap;
    }

    @Override
    public void singleOkCancelBox(IFormView formView, Object pkValue, ConfirmCallBackListener confirmCallBackListener) {
        formView.showConfirm(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u540e\uff0c\u5c06\u66f4\u65b0%s\u5408\u540c\u7684\u7b7e\u7f72\u72b6\u6001\u4e3a\u201c\u5df2\u5b8c\u6210\u7b7e\u7f72\u201d\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"CompleteSignTemplate_5", (String)"hr-hlcm-business", (Object[])new Object[]{this.getActivityEmpName(formView, pkValue)}), MessageBoxOptions.OKCancel, confirmCallBackListener);
    }

    @Override
    public void multiOkCancelBox(IFormView formView, ConfirmCallBackListener confirmCallBackListener) {
        formView.showConfirm(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u540e\uff0c\u5c06\u66f4\u65b0\u6240\u9009\u5458\u5de5\u5408\u540c\u7684\u7b7e\u7f72\u72b6\u6001\u4e3a\u201c\u5df2\u5b8c\u6210\u7b7e\u7f72\u201d\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"CompleteSignTemplate_3", (String)"hr-hlcm-business", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
    }

    @Override
    public List<HRExportHeadObject> getMulSelectConfirmExcelHead(String formId) {
        List<HRExportHeadObject> headObjectList = ISignManageService.getInstance().getMulSelectConfirmExcelHead(formId);
        headObjectList.add(new HRExportHeadObject("islegal", ResManager.loadKDString((String)"\u662f\u5426\u53ef\u5b8c\u6210\u7b7e\u7f72", (String)"CompleteSignTemplate_7", (String)"hr-hlcm-business", (Object[])new Object[0])));
        headObjectList.add(new HRExportHeadObject("reason", ResManager.loadKDString((String)"\u4e0d\u53ef\u5b8c\u6210\u7b7e\u7f72\u539f\u56e0", (String)"CompleteSignTemplate_8", (String)"hr-hlcm-business", (Object[])new Object[0])));
        return headObjectList;
    }

    @Override
    public List<HRExportHeadObject> getConfirmResultExcelHead(String formId) {
        List<HRExportHeadObject> headObjectList = ISignManageService.getInstance().getMulSelectConfirmExcelHead(formId);
        headObjectList.add(new HRExportHeadObject("islegal", ResManager.loadKDString((String)"\u662f\u5426\u5b8c\u6210\u7b7e\u7f72", (String)"CompleteSignTemplate_11", (String)"hr-hlcm-business", (Object[])new Object[0])));
        headObjectList.add(new HRExportHeadObject("reason", ResManager.loadKDString((String)"\u672a\u5b8c\u6210\u7b7e\u7f72\u539f\u56e0", (String)"CompleteSignTemplate_12", (String)"hr-hlcm-business", (Object[])new Object[0])));
        return headObjectList;
    }

    @Override
    public List<Map<String, Object>> getMulSelectConfirmExportData(Object[] pkValues, Map<Object, String> preErrorInfoMap, String formId) {
        return ISignManageService.getInstance().activityPreValidateExportData(pkValues, preErrorInfoMap);
    }

    @Override
    public List<Map<String, Object>> getConfirmResultExportData(Object[] pkValues, Map<Object, String> errorMap, String formId) {
        return ISignManageService.getInstance().activityPreValidateExportData(pkValues, errorMap);
    }
}

