/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.domian.service.hismodel.abs;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.Assert;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.VersionChangeRespData;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hlcm.business.common.HLCMCommonRepository;
import kd.hr.hlcm.business.domian.repository.PreWarnRepository;
import kd.hr.hlcm.business.domian.service.hismodel.abs.GetDyHis;
import kd.hr.hlcm.business.domian.service.hismodel.abs.impl.CancelGetDyHis;
import kd.hr.hlcm.business.domian.service.hismodel.abs.impl.ChangeGetDyHis;
import kd.hr.hlcm.business.domian.service.hismodel.abs.impl.NewGetDyHis;
import kd.hr.hlcm.business.domian.service.hismodel.abs.impl.RenewGetDyHis;
import kd.hr.hlcm.business.domian.service.hismodel.abs.vo.DyHisVO;
import kd.hr.hlcm.business.domian.service.hismodel.helper.ContractHisHelper;
import kd.hr.hlcm.business.domian.service.hismodel.impl.ContractHisModel;
import kd.hr.hlcm.common.enums.BusinessTypeEnum;
import kd.hr.hlcm.common.enums.ContractStatusEnum;

public class GenContractService {
    private static final Log LOGGER = LogFactory.getLog(ContractHisModel.class);
    private static final String ENUM_PREFIX = "GET_DY_HIS_ENUM_";
    private static final String DEL_PRE_WARN_TASK = "del_pre_warn_task";
    private Map<Long, DynamicObject> oldContractMap = new HashMap<Long, DynamicObject>();
    private Map<String, List<DynamicObject>> futureContractMap = new HashMap<String, List<DynamicObject>>();
    private DynamicObject[] signBills;

    public DynamicObject[] getSignBills() {
        return this.signBills;
    }

    public GenContractService init(DynamicObject[] signBills) {
        DynamicObject[] oldContracts;
        this.signBills = signBills;
        this.initFutureContractMap(signBills);
        Object[] oldContractPkValues = Stream.of(signBills).map(signBill -> signBill.getDynamicObject("oldcontract")).filter(oldContract -> !HRObjectUtils.isEmpty((Object)oldContract)).map(DataEntityBase::getPkValue).toArray();
        for (DynamicObject oldContract2 : oldContracts = HLCMCommonRepository.queryDynamicObjectByPks("hlcm_contractsource", null, oldContractPkValues)) {
            this.oldContractMap.put(oldContract2.getLong("id"), oldContract2);
        }
        return this;
    }

    private void initFutureContractMap(DynamicObject[] signBills) {
        Set personIdSet = Arrays.stream(signBills).filter(signBill -> Lists.newArrayList((Object[])new String[]{BusinessTypeEnum.CANCEL.getCombKey(), BusinessTypeEnum.STOP.getCombKey()}).contains(signBill.getString("businesstype"))).map(dy -> dy.getLong(String.format(Locale.ROOT, "%s_id", "person"))).collect(Collectors.toSet());
        QFilter fixedFilter = new QFilter("iscurrentversion", "=", (Object)"1").and(new QFilter("contractstatus", "=", (Object)ContractStatusEnum.STATUS_PENDING.getCode()));
        QFilter personFilter = new QFilter("person", "in", personIdSet);
        DynamicObject[] futureContracts = HLCMCommonRepository.queryDynamicObjects("hlcm_contractsource", null, fixedFilter.and(personFilter));
        Map<String, List<DynamicObject>> futureContractGroup = Arrays.stream(futureContracts).collect(Collectors.groupingBy(this::makeKey));
        for (DynamicObject signBill2 : signBills) {
            String businessType = signBill2.getString("businesstype");
            if (!Lists.newArrayList((Object[])new String[]{BusinessTypeEnum.CANCEL.getCombKey(), BusinessTypeEnum.STOP.getCombKey()}).contains(businessType)) continue;
            String key = this.makeKey(signBill2);
            List<DynamicObject> futureContractList = futureContractGroup.get(key);
            if (!futureContractGroup.containsKey(key)) continue;
            this.futureContractMap.put(key, futureContractList);
        }
    }

    private String makeKey(DynamicObject futureContract) {
        long personId = futureContract.getLong(String.format(Locale.ROOT, "%s_id", "person"));
        long podTypeId = futureContract.getLong(String.format(Locale.ROOT, "%s_id", "postype"));
        String protocolType = futureContract.getString("protocoltype");
        return String.format(Locale.ROOT, "%d_%d_%s", personId, podTypeId, protocolType);
    }

    private void afterGenContract() {
        for (DynamicObject signBill : this.getSignBills()) {
            long personId = signBill.getLong(String.format(Locale.ROOT, "%s_id", "person"));
            long posTypeId = signBill.getLong(String.format(Locale.ROOT, "%s_id", "postype"));
            String protocolType = signBill.getString("protocoltype");
            try {
                PreWarnRepository.getInstance().deletePreWarn2(personId, posTypeId, protocolType);
            }
            catch (Exception exp) {
                LOGGER.error("deletePreWarn2 error", (Throwable)exp);
            }
        }
    }

    public void genContract() {
        DynamicObject[] signBills = this.getSignBills();
        ArrayList<DynamicObject> hisDynList = new ArrayList<DynamicObject>(signBills.length);
        for (DynamicObject signBill : signBills) {
            String businessType = signBill.getString("businesstype");
            LOGGER.info("the contract businesstype|{}", (Object)businessType);
            Assert.hasText((String)businessType, (String)"param businesstype is null or empty");
            Assert.isTrue((boolean)Arrays.asList("1", "2", "3", "4", "5").contains(businessType), (String)"param businesstype must 1~5");
            Optional<DynamicObject> oldContractOptional = Optional.ofNullable(signBill.getDynamicObject("oldcontract"));
            if (Arrays.asList("2", "3", "4", "5").contains(businessType)) {
                Assert.isTrue((boolean)oldContractOptional.isPresent(), (String)String.format(Locale.ROOT, "when businessType=%s oldcontract must be not null", businessType));
            }
            Long oldContractPkValue = oldContractOptional.map(bill -> bill.getLong("id")).orElse(0L);
            DynamicObject oldContract = this.oldContractMap.get(oldContractPkValue);
            List<DynamicObject> futureContracts = this.futureContractMap.get(this.makeKey(signBill));
            GetDyHisEnum getDyHisEnum = GetDyHisEnum.valueOf(ENUM_PREFIX.concat(businessType));
            DyHisVO dyHisVO = new DyHisVO(signBill, oldContract, futureContracts);
            hisDynList.addAll(getDyHisEnum.getDyHisHandler().getDyHis(dyHisVO));
        }
        if (!hisDynList.isEmpty()) {
            DynamicObject[] hisDyns = hisDynList.toArray(new DynamicObject[0]);
            LOGGER.info("hisDyns length|{}", (Object)hisDyns.length);
            HisResponse<VersionChangeRespData> response = ContractHisHelper.getInstance().callHisModel(hisDyns);
            if (!"200".equals(response.getCode())) {
                throw new KDBizException(response.getErrorMessage());
            }
            ThreadPools.executeOnce((String)DEL_PRE_WARN_TASK, this::afterGenContract);
        }
    }

    static enum GetDyHisEnum {
        GET_DY_HIS_ENUM_1(new NewGetDyHis()),
        GET_DY_HIS_ENUM_2(new RenewGetDyHis()),
        GET_DY_HIS_ENUM_3(new ChangeGetDyHis()),
        GET_DY_HIS_ENUM_4(new CancelGetDyHis()),
        GET_DY_HIS_ENUM_5(new CancelGetDyHis());

        private GetDyHis getDyHis;

        private GetDyHisEnum(GetDyHis getDyHis) {
            this.getDyHis = getDyHis;
        }

        public GetDyHis getDyHisHandler() {
            return this.getDyHis;
        }
    }
}

