/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.domian.service.hismodel.contract;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.VersionChangeRespData;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.mservice.HRMServiceResult;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.domian.service.hbpm.IHbpmService;
import kd.hr.hlcm.business.domian.service.hismodel.contract.valid.AbstractContractValidator;
import kd.hr.hlcm.business.domian.service.hismodel.helper.ContractHisHelper;
import kd.hr.hlcm.business.domian.service.hspm.IHSPMFileService;
import kd.hr.hlcm.business.utils.HLCMImportUtils;
import kd.hr.hlcm.common.entity.ErManQueryParam;
import kd.hr.hlcm.common.entity.ErManQueryResult;
import kd.hr.hlcm.common.enums.ContractCategoryEnum;
import kd.hr.hlcm.common.enums.ProtocolTypeEnum;

public abstract class AbstractContractService {
    private static final Log LOGGER = LogFactory.getLog(AbstractContractService.class);
    private Map<Long, Map<String, Object>> erManFileInfoMap;
    private Map<ErManQueryParam, Long> erManQueryParamInfoMap = Maps.newHashMap();
    private Map<Long, Long> adminOrgHisMap;
    private Map<Long, Long> hisPosMap;
    private Map<Long, Long> hisStdPosMap;
    private Map<Long, Long> jobHisMap;
    private Map<Long, Long> companyHisMap;
    private Map<Long, Map> perCreMap;
    private Map<Long, List<Map>> perAddressMap;
    private Map<Long, String> noErManFileMap = Maps.newHashMap();
    protected final HRBaseServiceHelper contractHelper = new HRBaseServiceHelper("hlcm_contractsource");
    private final List<String> signStatusList = Lists.newArrayList((Object[])new String[]{"4", "5"});
    private static final int INIT_BATCH = 1000001;

    private void initData(List<DynamicObject> dyList) {
        this.initErManFile(dyList);
        ArrayList erManFileIdList = Lists.newArrayList(this.erManQueryParamInfoMap.values());
        this.erManFileInfoMap = Maps.newHashMapWithExpectedSize((int)dyList.size());
        List<Map<String, Object>> erManFileInfoList = IHSPMFileService.getInstance().getAllCardFieldByErManFileIds(erManFileIdList);
        HashSet departIds = Sets.newHashSetWithExpectedSize((int)dyList.size());
        HashSet positionIds = Sets.newHashSetWithExpectedSize((int)dyList.size());
        HashSet stdPositionIds = Sets.newHashSetWithExpectedSize((int)dyList.size());
        HashSet jobIds = Sets.newHashSetWithExpectedSize((int)dyList.size());
        HashSet companyIds = Sets.newHashSetWithExpectedSize((int)dyList.size());
        HashSet personIds = Sets.newHashSetWithExpectedSize((int)dyList.size());
        erManFileInfoList.forEach(erManFileInfo -> {
            this.erManFileInfoMap.put((Long)erManFileInfo.get("id"), (Map<String, Object>)erManFileInfo);
            personIds.add((Long)erManFileInfo.get("person_id"));
            departIds.add((Long)erManFileInfo.get("adminorg_id"));
            companyIds.add((Long)erManFileInfo.get("company_id"));
            positionIds.add((Long)erManFileInfo.get("position_id"));
            stdPositionIds.add((Long)erManFileInfo.get("stdposition_id"));
            jobIds.add((Long)erManFileInfo.get("job_id"));
        });
        IHbpmService instance = IHbpmService.getInstance();
        this.adminOrgHisMap = instance.getAdminOrgHis(Lists.newArrayList((Iterable)departIds));
        this.hisPosMap = instance.getPosHis(Lists.newArrayList((Iterable)positionIds));
        this.hisStdPosMap = instance.getStdPosHis(Lists.newArrayList((Iterable)stdPositionIds));
        this.jobHisMap = instance.getJobHis(Lists.newArrayList((Iterable)jobIds));
        this.companyHisMap = instance.getAdminOrgHis(Lists.newArrayList((Iterable)companyIds));
        ArrayList personParamList = Lists.newArrayList((Iterable)personIds);
        List perCreList = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"listBatchPersonAttachs", (Object[])new Object[]{personParamList, null, "hrpi_percre"});
        List perAddressList = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"listBatchPersonAttachs", (Object[])new Object[]{personParamList, null, "hrpi_peraddress"});
        this.perCreMap = Maps.newHashMapWithExpectedSize((int)dyList.size());
        perCreList.forEach(perCre -> this.perCreMap.put((Long)perCre.get("person_id"), (Map)perCre));
        this.perAddressMap = perAddressList.stream().collect(Collectors.groupingBy(perAddress -> (Long)perAddress.get("person_id")));
    }

    protected abstract List<Long> getErManFileIdList(List<DynamicObject> var1);

    protected abstract void setValue(DynamicObject var1);

    protected abstract AbstractContractValidator getAbstractValidator(List<DynamicObject> var1);

    private void initErManFile(List<DynamicObject> dyList) {
        List<ErManQueryParam> erManQueryParams = dyList.stream().map(this::buildErManQueryParam).collect(Collectors.toList());
        Map<ErManQueryParam, ErManQueryResult> erManQueryParamErManQueryResultMap = HLCMImportUtils.queryInitErManFile(erManQueryParams);
        dyList.forEach(dy -> {
            ErManQueryParam erManQueryParam = this.buildErManQueryParam((DynamicObject)dy);
            ErManQueryResult erManQueryResult = (ErManQueryResult)erManQueryParamErManQueryResultMap.get(erManQueryParam);
            Optional.ofNullable(erManQueryResult).map(ErManQueryResult::getErManFileId).ifPresent(erManFileId -> this.erManQueryParamInfoMap.put(erManQueryParam, (Long)erManFileId));
        });
    }

    private ErManQueryParam buildErManQueryParam(DynamicObject dy) {
        String empNumber = dy.getString("empnumber");
        DynamicObject deptDy = dy.getDynamicObject("curdept");
        String departmentName = deptDy.getString("number");
        DynamicObject positionDy = dy.getDynamicObject("curpostion");
        DynamicObject stdPositionDy = dy.getDynamicObject("curstdpostion");
        DynamicObject jobDy = dy.getDynamicObject("curjob");
        String position = null;
        String stdPosition = null;
        String job = null;
        if (!HRObjectUtils.isEmpty((Object)positionDy)) {
            position = positionDy.getString("number");
        }
        if (!HRObjectUtils.isEmpty((Object)stdPositionDy)) {
            stdPosition = stdPositionDy.getString("number");
        }
        if (!HRObjectUtils.isEmpty((Object)jobDy)) {
            job = jobDy.getString("number");
        }
        return new ErManQueryParam(empNumber, departmentName, position, stdPosition, job);
    }

    private List<DynamicObject> convert(List<DynamicObject> dyList) {
        this.initData(dyList);
        ArrayList newDyList = Lists.newArrayListWithCapacity((int)dyList.size());
        for (DynamicObject dy : dyList) {
            DynamicObject newDy = this.contractHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)dy, (DynamicObject)newDy);
            newDy.set("id", dy.get("id"));
            this.setCommonRelatedValue(newDy);
            this.buildErManFileRelated(newDy);
            this.setCommonValue(newDy);
            this.setValue(newDy);
            newDyList.add(newDy);
        }
        return newDyList;
    }

    private void setCommonRelatedValue(DynamicObject newDy) {
        String protocolType = newDy.getString("protocoltype");
        if (HRStringUtils.equals((String)protocolType, (String)ProtocolTypeEnum.FS.getCombKey())) {
            newDy.set("oldcontract", null);
        } else {
            newDy.set("maincontract", null);
        }
    }

    private void buildErManFileRelated(DynamicObject newDy) {
        List<Map> perAddressList;
        Map creMap;
        Long erManFileId = this.erManQueryParamInfoMap.get(this.buildErManQueryParam(newDy));
        if (Objects.isNull(erManFileId) || erManFileId == 0L) {
            String errMsg = ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u8be5\u5458\u5de5\u7684\u5de5\u53f7\u3001\u6240\u5c5e\u5c97\u4f4d\u3001\u6807\u51c6\u5c97\u4f4d\u3001\u804c\u4f4d\u3001\u90e8\u95e8\u662f\u5426\u6b63\u786e\u3002", (String)"AbstractContractService_0", (String)"hr-hlcm-business", (Object[])new Object[0]);
            this.noErManFileMap.put(newDy.getLong("id"), errMsg);
            return;
        }
        if (CollectionUtils.isEmpty(this.erManFileInfoMap)) {
            return;
        }
        Map<String, Object> erManFileInfo = this.erManFileInfoMap.get(erManFileId);
        if (CollectionUtils.isEmpty(erManFileInfo)) {
            return;
        }
        newDy.set("ermanfile", (Object)erManFileId);
        long posTypeValue = HRJSONUtils.getLongValOfCustomParam((Object)erManFileInfo.get("postype_id"));
        newDy.set("postype", (Object)posTypeValue);
        if (posTypeValue == 1010L) {
            newDy.set("contractcategory", (Object)ContractCategoryEnum.MAIN.getCombKey());
        } else if (posTypeValue == 1040L) {
            newDy.set("contractcategory", (Object)ContractCategoryEnum.OUTER.getCombKey());
        } else {
            LOGGER.warn("posTypeValue |{}", (Object)posTypeValue);
        }
        Long personId = (Long)erManFileInfo.get("person_id");
        newDy.set("person_id", (Object)personId);
        newDy.set("employee_id", erManFileInfo.get("employee_id"));
        if (HRStringUtils.isEmpty((String)newDy.getString("empphone"))) {
            newDy.set("empphone", erManFileInfo.get("phone"));
        }
        newDy.set("baselocation", erManFileInfo.get("location_id"));
        newDy.set("ermanperorg", erManFileInfo.get("empgroup_id"));
        newDy.set("org", erManFileInfo.get("org_id"));
        newDy.set("adminororg", erManFileInfo.get("affiliateadminorg_id"));
        Long companyId = (Long)erManFileInfo.get("company_id");
        newDy.set("signedcompany", (Object)companyId);
        newDy.set("ermanorg", erManFileInfo.get("org_id"));
        Long adminOrgId = (Long)erManFileInfo.get("adminorg_id");
        newDy.set("department_id", (Object)this.adminOrgHisMap.get(adminOrgId));
        newDy.set("curdept", (Object)adminOrgId);
        newDy.set("signedcompany_id", (Object)this.companyHisMap.get(companyId));
        newDy.set("curcompany", (Object)companyId);
        Long positionId = (Long)erManFileInfo.get("position_id");
        newDy.set("position_id", (Object)this.hisPosMap.get(positionId));
        newDy.set("curpostion", (Object)positionId);
        Long stdPositionId = (Long)erManFileInfo.get("stdposition_id");
        newDy.set("stdposition_id", (Object)this.hisStdPosMap.get(stdPositionId));
        newDy.set("curstdpostion", (Object)stdPositionId);
        Long jobId = (Long)erManFileInfo.get("job_id");
        newDy.set("job_id", (Object)this.jobHisMap.get(jobId));
        newDy.set("curjob", (Object)jobId);
        newDy.set("name", erManFileInfo.get("name"));
        if (newDy.get("cardtype") == null && HRStringUtils.isEmpty((String)newDy.getString("cardnumber")) && (creMap = this.perCreMap.get(personId)) != null) {
            newDy.set("cardtype", creMap.get("credentialstype_id"));
            newDy.set("cardnumber", creMap.get("number"));
        }
        if (!CollectionUtils.isEmpty(perAddressList = this.perAddressMap.get(personId))) {
            perAddressList.forEach(perAddress -> {
                Long addressTypeId = (Long)perAddress.get("addresstype_id");
                if (1020L == addressTypeId) {
                    newDy.set("householdregister", perAddress.get("addressinfo"));
                } else if (1030L == addressTypeId) {
                    newDy.set("residentialaddress", perAddress.get("addressinfo"));
                }
            });
        }
    }

    private void setEntryEntity(DynamicObject dy) {
        DynamicObjectCollection templates = dy.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)templates)) {
            return;
        }
        Date date = new Date();
        for (DynamicObject template : templates) {
            DynamicObject contractTemplate = template.getDynamicObject("contracttemplate");
            if (contractTemplate == null) continue;
            template.set("texthis", (Object)contractTemplate.getLong("vid"));
            template.set("opperson", (Object)RequestContext.get().getCurrUserId());
            template.set("opdate", (Object)date);
        }
    }

    public HRMServiceResult execute(List<DynamicObject> dyList) {
        Map<Long, String> error = this.valid(dyList);
        Predicate<DynamicObject> predicate = dy -> !error.containsKey(dy.getLong("id"));
        List<DynamicObject> passValid = dyList.stream().filter(predicate).collect(Collectors.toList());
        List<DynamicObject> list = this.convert(passValid);
        error.putAll(this.noErManFileMap);
        if (!CollectionUtils.isEmpty(error)) {
            HRMServiceResult result = HRMServiceResult.fail(null);
            result.setReturnData(error);
            return result;
        }
        DynamicObject[] hisDys = (DynamicObject[])list.stream().filter(predicate).toArray(DynamicObject[]::new);
        LOGGER.info("hisDys length|{}", (Object)hisDys.length);
        HisResponse<VersionChangeRespData> response = ContractHisHelper.getInstance().callHisModel(hisDys);
        if (!"200".equals(response.getCode())) {
            return HRMServiceResult.fail((String)response.getErrorMessage(), (String)"fail");
        }
        return HRMServiceResult.success();
    }

    private Map<Long, String> valid(List<DynamicObject> list) {
        AbstractContractValidator validator = this.getAbstractValidator(list);
        validator.valid();
        return validator.getResult();
    }

    private void setCommonValue(DynamicObject newDy) {
        DynamicObject actualDy = newDy.getDynamicObject("actualsigncompany");
        if (actualDy != null) {
            newDy.set("actualsigncompanyhis", actualDy.get("vid"));
        }
        this.setEntryEntity(newDy);
        if (HRStringUtils.isEmpty((String)newDy.getString("changedescription"))) {
            newDy.set("changedescription", (Object)"newData");
        }
        this.setTemplateValue(newDy);
        this.setActualEndDate(newDy);
        Date actualEndDate = HRDateTimeUtils.truncateDate((Date)newDy.getDate("actualenddate"));
        ContractHisHelper.getInstance().setContractStatus(HRDateTimeUtils.truncateDate((Date)newDy.getDate("startdate")), actualEndDate == null ? HRDateTimeUtils.truncateDate((Date)newDy.getDate("enddate")) : actualEndDate, newDy);
    }

    private void setTemplateValue(DynamicObject dy) {
        this.setBsed(dy);
        dy.set("status", (Object)"C");
        dy.set("enable", (Object)"1");
        dy.set("initstatus", (Object)"2");
        dy.set("initdatasource", (Object)"2");
        dy.set("initbatch", (Object)1000001);
    }

    private void setBsed(DynamicObject dy) {
        Date startDate = HRDateTimeUtils.truncateDate((Date)dy.getDate("startdate"));
        Date today = HRDateTimeUtils.truncateDate((Date)new Date());
        dy.set("bsed", (Object)(today.before(startDate) ? today : startDate));
    }

    private void setActualEndDate(DynamicObject dy) {
        String signStatus;
        Date endDate = HRDateTimeUtils.truncateDate((Date)dy.getDate("enddate"));
        Date actualEndDate = dy.getDate("actualenddate");
        Date today = HRDateTimeUtils.truncateDate((Date)new Date());
        if (endDate != null && actualEndDate == null && endDate.before(today)) {
            dy.set("actualenddate", (Object)endDate);
        }
        if (this.signStatusList.contains(signStatus = dy.getString("signstatus")) && actualEndDate != null && !actualEndDate.before(today)) {
            dy.set("planenddate", (Object)actualEndDate);
            dy.set("actualenddate", null);
        }
    }
}

