/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.domian.service.hspm.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hlcm.business.domian.service.hspm.IHSPMFileService;

public class IHSPMFileFileServiceImpl
implements IHSPMFileService {
    private static final Log LOGGER = LogFactory.getLog(IHSPMFileFileServiceImpl.class);

    @Override
    public List<Map<String, Object>> getAllCardFieldByErManFileIds(List<Long> erManFileIDs) {
        LOGGER.info("erManFileIDs|{}", (Object)JSON.toJSONString(erManFileIDs));
        try {
            List result = (List)HRMServiceHelper.invokeHRService((String)"hspm", (String)"IHSPMService", (String)"getCardFields", (Object[])new Object[]{erManFileIDs});
            if (CollectionUtils.isEmpty((Collection)result)) {
                LOGGER.info("call getCardFields is empty");
            }
            LOGGER.info("call getCardFields success.");
            return result;
        }
        catch (Exception exp) {
            LOGGER.error("call getCardFields error.", (Throwable)exp);
            return new ArrayList<Map<String, Object>>();
        }
    }

    @Override
    public Map<String, Object> getCardFieldByErManFileId(Long erManFileID) {
        List<Map<String, Object>> response = this.getAllCardFieldByErManFileIds(Lists.newArrayList((Object[])new Long[]{erManFileID}));
        if (CollectionUtils.isEmpty(response)) {
            return new HashMap<String, Object>();
        }
        Map result = response.stream().findFirst().orElseGet(HashMap::new);
        ArrayList filterProperties = Lists.newArrayList((Object[])new String[]{"identitynumber"});
        return result;
    }

    @Override
    public List<Map<String, Object>> getAllErmanFileIdByEmporgRel(List<Map<String, Object>> params) {
        return (List)HRMServiceHelper.invokeHRService((String)"hspm", (String)"IHSPMService", (String)"getAllErmanFileIdByEmporgRel", (Object[])new Object[]{params});
    }

    @Override
    public Map<Long, Long> getNewestErmanByEmployee(List<Long> empIds, Boolean needQuit) {
        LOGGER.info("getNewestErmanByEmployee.empIds:{}", empIds);
        Map resultMap = (Map)HRMServiceHelper.invokeHRService((String)"hspm", (String)"IHSPMService", (String)"getErmanFileIdByEmployeeId", (Object[])new Object[]{empIds, needQuit});
        LOGGER.info("getNewestErmanByEmployee.resultMap:{}", (Object)resultMap);
        return resultMap;
    }

    @Override
    public DynamicObject[] getEmpposrelByErmanId(List<Long> ermanIds) {
        HRBaseServiceHelper ermanFileServiceHelper = new HRBaseServiceHelper("hspm_ermanfile");
        QFilter idFilter = new QFilter("id", "in", ermanIds.stream().distinct().collect(Collectors.toList()));
        DynamicObject[] ermanFiles = ermanFileServiceHelper.query("employee,empposrel.id,empentrel.id", new QFilter[]{idFilter});
        return ermanFiles;
    }

    @Override
    public Optional<Long> queryAndCompareReviseLog(String entityNumber, List<Long> reviseRecordIdList) {
        LOGGER.info("param entityNumber|{},reviseRecordIdList|{}", (Object)entityNumber, reviseRecordIdList);
        Map response = (Map)HRMServiceHelper.invokeHRService((String)"hspm", (String)"IReviseRecordService", (String)"queryAndCompareReviseLog", (Object[])new Object[]{entityNumber, reviseRecordIdList});
        LOGGER.info("response |{}", (Object)response);
        if (Objects.equals(response.get("success"), Boolean.FALSE)) {
            return Optional.empty();
        }
        Map data = (Map)response.get("data");
        List reviseBoList = (List)data.get("reviseBoList");
        if (CollectionUtils.isEmpty((Collection)reviseBoList)) {
            return Optional.empty();
        }
        return reviseBoList.stream().map(bo -> bo.get("employee")).filter(Objects::nonNull).map(Object::toString).map(Long::parseLong).findFirst();
    }
}

