/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.domian.service.initdata.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.domian.repository.ContractRepository;
import kd.hr.hlcm.business.domian.service.initdata.CommonInitDomainDataService;
import kd.hr.hlcm.common.entity.ContractEntity;
import kd.hr.hlcm.common.entity.ErManQueryResult;
import kd.hr.hlcm.common.enums.ContractFileSignStatusEnum;
import kd.hr.hlcm.common.enums.LabRelTypeEnum;
import kd.hr.hlcm.common.enums.ProtocolTypeEnum;

public class EmpprotolInitDomainDataService
extends CommonInitDomainDataService {
    private static final Log LOGGER = LogFactory.getLog(EmpprotolInitDomainDataService.class);

    @Override
    protected String doCheckErManFile(Long posTypeId, List<Long> laborRelTypeClsId, Long labrelStatusPrdId) {
        StringBuilder stringBuilder = new StringBuilder();
        LOGGER.info("EmpprotolInitDomainDataService_doCheckErManFile_param#posTypeId:{},labrelStatusPrdId{},laborRelTypeClsId:{}", new Object[]{posTypeId, labrelStatusPrdId, laborRelTypeClsId});
        ArrayList list = Lists.newArrayList((Object[])new Long[]{LabRelTypeEnum.INTERNSHIP.getCombKey(), LabRelTypeEnum.LABORSERVICE.getCombKey(), LabRelTypeEnum.REEMPLOYMENT.getCombKey(), LabRelTypeEnum.OUTERCLASS.getCombKey()});
        if (CollectionUtils.isEmpty(laborRelTypeClsId) || !list.contains(laborRelTypeClsId.get(0))) {
            stringBuilder.append(ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u7684\u7528\u5de5\u7c7b\u578b\u5206\u7c7b\u4e0d\u662f\u5b9e\u4e60\u7c7b/\u52b3\u52a1\u7c7b/\u8fd4\u8058\u7c7b/\u5916\u90e8\u7c7b\uff0c\u8bf7\u4fee\u6539\u5458\u5de5\u7684\u6240\u5c5e\u5c97\u4f4d\u3001\u6807\u51c6\u5c97\u4f4d\u3001\u804c\u4f4d\u6216\u90e8\u95e8\uff1b", (String)"EmpprotolInitDomainDataService_1", (String)"hr-hlcm-business", (Object[])new Object[0]));
        }
        return stringBuilder.toString();
    }

    @Override
    protected void preSetFields(Map<Long, DynamicObject> targetMap) {
        targetMap.values().stream().forEach(dy -> {
            dy.set("protocoltype", (Object)"2");
            dy.set("signstatus", (Object)(dy.getString("signstatus") != null ? dy.getString("signstatus") : dy.getString("signstatustmp")));
            if (HRStringUtils.isEmpty((String)dy.getString("signway"))) {
                dy.set("signway", (Object)"2");
            }
            if (HRStringUtils.isEmpty((String)dy.getString("empnumber"))) {
                dy.set("empnumber", (Object)dy.getString("person.number"));
            }
        });
    }

    @Override
    protected void difBusinessValid(Map<Long, ErManQueryResult> midResultMap, Map<Long, DynamicObject> targetMap, Map<Long, String> failMap) {
        for (Map.Entry<Long, DynamicObject> entry : targetMap.entrySet()) {
            ErManQueryResult erManQueryResult;
            StringBuilder msg = new StringBuilder();
            DynamicObject dy = entry.getValue();
            Long key = entry.getKey();
            this.checkEndDate(msg, dy);
            Date actualEndDate = HRDateTimeUtils.truncateDate((Date)dy.getDate("actualenddate"));
            String signStatus = dy.getString("signstatus");
            if (Lists.newArrayList((Object[])new String[]{"4", "5"}).contains(signStatus) && actualEndDate == null) {
                msg.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5408\u540c\u7b7e\u8ba2\u72b6\u6001\u4e3a\u201c%1$s\u201d\u65f6\uff0c\u5408\u540c\u5b9e\u9645\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\uff1b", (String)"CommonInitDomainDataService_6", (String)"hr-hlcm-business", (Object[])new Object[0]), ContractFileSignStatusEnum.getValueByKey((String)signStatus)));
            }
            if (!HRObjectUtils.isEmpty((Object)(erManQueryResult = midResultMap.get(key)))) {
                msg.append(this.doCheckErManFile(erManQueryResult.getPosTypeId(), erManQueryResult.getLaborRelTypeClsId(), erManQueryResult.getLabrelStatusPrdId()));
            }
            this.buildErrMsgMap(failMap, msg, key);
        }
        this.removeCheckedBadData(targetMap, failMap);
    }

    @Override
    protected void businessValidByErman(Map<Long, DynamicObject> targetMap, Map<Long, String> failMap) {
        targetMap = targetMap.entrySet().stream().sorted(Comparator.comparing(entry -> ((DynamicObject)entry.getValue()).getDate("startdate"), Comparator.naturalOrder())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (x1, x2) -> x2, LinkedHashMap::new));
        HashMap<Long, Map<String, ContractEntity>> excelMap = new HashMap<Long, Map<String, ContractEntity>>(targetMap.size());
        this.buildExcelMap(targetMap, excelMap);
        HashMap<Long, Map<String, ContractEntity>> dataBaseMap = new HashMap<Long, Map<String, ContractEntity>>(targetMap.size());
        this.buildDataBaseMap(excelMap, dataBaseMap);
        this.rangeExcAndDataMap(excelMap, dataBaseMap);
        this.checkDateCross(targetMap, failMap, excelMap);
    }

    private void rangeExcAndDataMap(Map<Long, Map<String, ContractEntity>> excelMap, Map<Long, Map<String, ContractEntity>> dataBaseMap) {
        if (!CollectionUtils.isEmpty(dataBaseMap)) {
            for (Map.Entry<Long, Map<String, ContractEntity>> entry : dataBaseMap.entrySet()) {
                long ermanId = entry.getKey();
                Map<String, ContractEntity> inDataBaseMap = entry.getValue();
                Map inExcelMap = excelMap.get(ermanId);
                if (CollectionUtils.isEmpty(inExcelMap)) {
                    excelMap.put(ermanId, inDataBaseMap);
                    continue;
                }
                inExcelMap.putAll(inDataBaseMap);
                inExcelMap = inExcelMap.entrySet().stream().sorted(Comparator.comparing(e -> ((ContractEntity)e.getValue()).getStartDate(), Comparator.naturalOrder())).collect(Collectors.toMap(x -> (String)x.getKey(), x -> (ContractEntity)x.getValue(), (x1, x2) -> x2, LinkedHashMap::new));
                excelMap.put(ermanId, inExcelMap);
            }
        }
    }

    private void buildDataBaseMap(Map<Long, Map<String, ContractEntity>> excelMap, Map<Long, Map<String, ContractEntity>> dataBaseMap) {
        DynamicObject[] dys;
        HashSet<String> type = new HashSet<String>(2);
        type.add(ProtocolTypeEnum.YG.getCombKey());
        for (DynamicObject dy : dys = ContractRepository.getInstance().findContractsByErmanId(excelMap.keySet(), "ermanfile.id", type)) {
            long ermanfileId = dy.getLong("ermanfile.id");
            String number = dy.getString("number");
            if (ermanfileId == 0L) continue;
            Date endDate = HRDateTimeUtils.truncateDate((Date)(dy.getDate("actualenddate") == null ? dy.getDate("enddate") : dy.getDate("actualenddate")));
            Date startDate = HRDateTimeUtils.truncateDate((Date)dy.getDate("startdate"));
            ContractEntity contractEntity = new ContractEntity("0", startDate, endDate);
            Map<String, ContractEntity> contractMap = dataBaseMap.get(ermanfileId);
            if (CollectionUtils.isEmpty(contractMap)) {
                HashMap<String, ContractEntity> map = new HashMap<String, ContractEntity>(1);
                map.put(number, contractEntity);
                dataBaseMap.put(ermanfileId, map);
                continue;
            }
            contractMap.put(number, contractEntity);
            dataBaseMap.put(ermanfileId, contractMap);
        }
    }

    private void buildExcelMap(Map<Long, DynamicObject> targetMap, Map<Long, Map<String, ContractEntity>> excelMap) {
        for (Map.Entry<Long, DynamicObject> entry : targetMap.entrySet()) {
            DynamicObject dy = entry.getValue();
            Long ermanfileId = dy.getLong("ermanfile");
            String number = dy.getString("number");
            Date endDate = HRDateTimeUtils.truncateDate((Date)(dy.getDate("actualenddate") == null ? dy.getDate("enddate") : dy.getDate("actualenddate")));
            Date startDate = HRDateTimeUtils.truncateDate((Date)dy.getDate("startdate"));
            Map<String, ContractEntity> entityMap = excelMap.get(ermanfileId);
            ContractEntity contractEntity = new ContractEntity("0", startDate, endDate);
            if (CollectionUtils.isEmpty(entityMap)) {
                HashMap<String, ContractEntity> map = new HashMap<String, ContractEntity>(1);
                map.put(number, contractEntity);
                excelMap.put(ermanfileId, map);
                continue;
            }
            entityMap.put(number, contractEntity);
            excelMap.put(ermanfileId, entityMap);
        }
    }

    @Override
    protected void assembleDifFields(DynamicObject dy) {
        Date actualDate = dy.getDate("actualenddate");
        Date endDate = dy.getDate("enddate");
        String signStatus = dy.getString("signstatus");
        if (Lists.newArrayList((Object[])new String[]{ContractFileSignStatusEnum.CANCEL_SIGN.getCombKey(), ContractFileSignStatusEnum.STOP_SIGNED.getCombKey()}).contains(signStatus)) {
            if (actualDate != null && HRDateTimeUtils.dayAfter((Date)HRDateTimeUtils.truncateDate((Date)new Date()), (Date)HRDateTimeUtils.truncateDate((Date)actualDate))) {
                dy.set("actualenddate", (Object)actualDate);
            } else {
                dy.set("planenddate", (Object)actualDate);
                dy.set("actualenddate", null);
            }
        }
        if (actualDate == null && endDate != null && "1".equals(signStatus) && HRDateTimeUtils.dayAfter((Date)HRDateTimeUtils.truncateDate((Date)new Date()), (Date)HRDateTimeUtils.truncateDate((Date)endDate))) {
            dy.set("actualenddate", (Object)endDate);
        }
        dy.set("signeddate", (Object)dy.getDate("signeddatetmp"));
    }

    private void checkDateCross(Map<Long, DynamicObject> targetMap, Map<Long, String> failMap, Map<Long, Map<String, ContractEntity>> excelOrDataBaseMap) {
        block0: for (Map.Entry<Long, DynamicObject> entry : targetMap.entrySet()) {
            StringBuilder msg = new StringBuilder();
            DynamicObject dy = entry.getValue();
            Long ermanfileId = dy.getLong("ermanfile");
            String targetNum = dy.getString("number");
            Long midId = entry.getKey();
            Date endDate = HRDateTimeUtils.truncateDate((Date)(dy.getDate("actualenddate") == null ? dy.getDate("enddate") : dy.getDate("actualenddate")));
            Date startDate = HRDateTimeUtils.truncateDate((Date)dy.getDate("startdate"));
            Map<String, ContractEntity> inExcelMap = excelOrDataBaseMap.get(ermanfileId);
            if (CollectionUtils.isEmpty(inExcelMap)) continue;
            for (Map.Entry<String, ContractEntity> inExcelMapEntry : inExcelMap.entrySet()) {
                String number = inExcelMapEntry.getKey();
                if (targetNum.equals(number)) continue;
                ContractEntity inDataEntity = inExcelMapEntry.getValue();
                Date excelStartDate = inDataEntity.getStartDate();
                Date excelEndDate = inDataEntity.getEndDate();
                if (endDate != null && excelEndDate != null) {
                    if (endDate.before(excelStartDate) || startDate.after(excelEndDate)) continue;
                    msg.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8be5\u5408\u540c\u4e0e\u5408\u540c\u7f16\u53f7\u4e3a\u201c%1$s\u201d\u7684\u5408\u540c\u5b58\u5728\u5408\u540c\u65e5\u671f\u4ea4\u53c9\uff0c\u8bf7\u4fee\u6539\u3002", (String)"EmpprotolInitDomainDataService_3", (String)"hr-hlcm-business", (Object[])new Object[0]), number));
                    this.buildErrMsgMap(failMap, msg, midId);
                    continue block0;
                }
                if (endDate == null && excelEndDate != null) {
                    if (!startDate.before(excelEndDate)) continue;
                    msg.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8be5\u5408\u540c\u4e0e\u5408\u540c\u7f16\u53f7\u4e3a\u201c%1$s\u201d\u7684\u5408\u540c\u5b58\u5728\u5408\u540c\u65e5\u671f\u4ea4\u53c9\uff0c\u8bf7\u4fee\u6539\u3002", (String)"EmpprotolInitDomainDataService_3", (String)"hr-hlcm-business", (Object[])new Object[0]), number));
                    this.buildErrMsgMap(failMap, msg, midId);
                    continue block0;
                }
                if (excelEndDate == null && endDate != null) {
                    if (!endDate.after(excelStartDate)) continue;
                    msg.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8be5\u5408\u540c\u4e0e\u5408\u540c\u7f16\u53f7\u4e3a\u201c%1$s\u201d\u7684\u5408\u540c\u5b58\u5728\u5408\u540c\u65e5\u671f\u4ea4\u53c9\uff0c\u8bf7\u4fee\u6539\u3002", (String)"EmpprotolInitDomainDataService_3", (String)"hr-hlcm-business", (Object[])new Object[0]), number));
                    this.buildErrMsgMap(failMap, msg, midId);
                    continue block0;
                }
                LOGGER.info("excelEndDate,endDate are all null");
            }
        }
    }

    @Override
    protected void difDistinct(Map<Long, DynamicObject> targetMap, Map<Long, String> failMap) {
    }
}

