/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.domian.service.initdata.initfile.impl;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.domian.repository.BosAttachmentRepository;
import kd.hr.hlcm.business.domian.service.initdata.initfile.InitFileService;

public class InitFileServiceImpl
implements InitFileService {
    private static final Log LOGGER = LogFactory.getLog(InitFileServiceImpl.class);

    @Override
    public Map<String, Object> queryInitContractWithoutFile(int pageIndex, int pageSize) {
        LOGGER.info("queryInitContractWithoutFile.param.is={}={}", (Object)pageIndex, (Object)pageSize);
        try {
            HRBaseServiceHelper contractServiceHelper = new HRBaseServiceHelper("hlcm_contractsource");
            QFilter statusFilter = new QFilter("initstatus", "=", (Object)"2");
            QFilter batchFilter = new QFilter("initbatch", "!=", (Object)0L);
            QFilter isCurrentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
            QFilter signwayFilter = new QFilter("signway", "=", (Object)"2");
            QFilter[] qFilters = new QFilter[]{statusFilter, isCurrentFilter, batchFilter, signwayFilter};
            DynamicObject[] allInitContracts = contractServiceHelper.query("id", qFilters);
            LOGGER.info("allInitContracts.size={}", (Object)allInitContracts.length);
            if (allInitContracts == null || allInitContracts.length == 0) {
                HashMap<String, Object> resultMap = new HashMap<String, Object>();
                resultMap.put("success", Boolean.TRUE);
                resultMap.put("errormsg", "no init data in db");
                resultMap.put("code", "203");
                resultMap.put("data", this.countMap(pageIndex, pageSize, 0));
                return resultMap;
            }
            Map<String, Boolean> allInterMap = this.checkFile(allInitContracts);
            int count = 0;
            if (CollectionUtils.isEmpty(allInterMap)) {
                count = allInitContracts.length;
                LOGGER.info("allInitContracts.do.not.have.files and allInitContracts.size.is={}", (Object)count);
            } else {
                List allWithoutFileList = Arrays.stream(allInitContracts).filter(contract -> (Boolean)allInterMap.get(String.valueOf(contract.getLong("id"))) == false).collect(Collectors.toList());
                count = allWithoutFileList.size();
                LOGGER.info("some.of.allInitContracts.do.not.have.file.and.there.are.={}.do not have file", (Object)count);
                if (CollectionUtils.isEmpty(allWithoutFileList)) {
                    HashMap<String, Object> resultMap = new HashMap<String, Object>();
                    resultMap.put("success", Boolean.TRUE);
                    resultMap.put("errormsg", "all the init data have file already.");
                    resultMap.put("code", "205");
                    resultMap.put("data", this.countMap(pageIndex, pageSize, count));
                    return resultMap;
                }
            }
            DynamicObject[] pageContracts = BusinessDataServiceHelper.load((String)"hlcm_contractsource", (String)"id,empnumber,name,number,signway,protocoltype", (QFilter[])qFilters, (String)"id", (int)(pageIndex > 0 ? pageIndex - 1 : pageIndex), (int)pageSize);
            LOGGER.info("according.to.the.pageIndex={}.and.pageSize={},we.get={}.from db", new Object[]{pageIndex, pageSize, pageContracts.length});
            if (pageContracts == null || pageContracts.length == 0) {
                HashMap<String, Object> resultMap = new HashMap<String, Object>();
                resultMap.put("success", Boolean.TRUE);
                resultMap.put("errormsg", "can not find any data,maybe it is last page");
                resultMap.put("code", "202");
                resultMap.put("data", this.countMap(pageIndex, pageSize, count));
                return resultMap;
            }
            Map<String, Boolean> interMap = this.checkFile(pageContracts);
            List<Object> dataList = new ArrayList();
            if (CollectionUtils.isEmpty(interMap)) {
                dataList = this.dyTransferMap(pageContracts);
                LOGGER.info("according.to.the.pageIndex={}.and.pageSize={},we.get={}.all.this.data.that.do.not.have.file", new Object[]{pageIndex, pageSize, dataList.size()});
            } else {
                List<DynamicObject> withoutFileList = Arrays.stream(pageContracts).filter(contract -> (Boolean)interMap.get(String.valueOf(contract.getLong("id"))) == false).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(withoutFileList)) {
                    LOGGER.info("according.to.the.pageIndex={}.and.pageSize={},we.get={}.some.of.this.page.data.that.have.file.already", new Object[]{pageIndex, pageSize, withoutFileList.size()});
                    HashMap<String, Object> resultMap = new HashMap<String, Object>();
                    resultMap.put("success", Boolean.TRUE);
                    resultMap.put("errormsg", "this page's data  have file already.");
                    resultMap.put("code", "201");
                    resultMap.put("data", this.countMap(pageIndex, pageSize, count));
                    return resultMap;
                }
                dataList = this.dyTransferMap(withoutFileList.toArray(new DynamicObject[0]));
                LOGGER.info("according.to.the.pageIndex={}.and.pageSize={},we.get={}.some.of.this.page.data.that.do.not.have.file", new Object[]{pageIndex, pageSize, dataList.size()});
            }
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            int totalPage = (int)Math.ceil((double)count * 1.0 / (double)pageSize);
            dataMap.put("pageIndex", pageIndex);
            dataMap.put("pageSize", pageSize);
            dataMap.put("count", count);
            dataMap.put("totalPage", totalPage);
            dataMap.put("data", dataList);
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put("success", Boolean.TRUE);
            resultMap.put("code", "200");
            resultMap.put("errormsg", "get data success.");
            resultMap.put("data", dataMap);
            return resultMap;
        }
        catch (Exception ex) {
            LOGGER.error("InitFileServiceImpl.queryInitContractWithoutFile.error", (Throwable)ex);
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put("success", Boolean.FALSE);
            resultMap.put("errormsg", ex.getMessage());
            resultMap.put("code", "204");
            resultMap.put("data", new HashMap());
            return resultMap;
        }
    }

    private Map<String, Boolean> checkFile(DynamicObject[] dys) {
        List idList = Arrays.stream(dys).map(contract -> String.valueOf(contract.getLong("id"))).collect(Collectors.toList());
        HRBaseServiceHelper fileServiceHelper = new HRBaseServiceHelper("bos_attachment");
        QFilter interidFilter = new QFilter("finterid", "in", idList);
        HashSet billtypeSet = Sets.newHashSet((Object[])new String[]{"hlcm_contract", "hlcm_contractfileemp", "hlcm_contractfileother"});
        QFilter billtypeFilter = new QFilter("fbilltype", "in", (Object)billtypeSet);
        QFilter attachmentFilter = new QFilter("fattachmentpanel", "=", (Object)"paperattachment");
        QFilter[] fileFilters = new QFilter[]{interidFilter, attachmentFilter, billtypeFilter};
        DynamicObject[] files = fileServiceHelper.query("finterid", fileFilters, "finterid");
        HashMap<String, Boolean> interMap = new HashMap<String, Boolean>(files.length);
        Arrays.stream(dys).forEach(contract -> interMap.put(String.valueOf(contract.getLong("id")), false));
        Arrays.stream(files).forEach(file -> interMap.put(file.getString("finterid"), HRStringUtils.isNotEmpty((String)file.getString("finterid"))));
        for (Map.Entry next : interMap.entrySet()) {
            Boolean value = (Boolean)next.getValue();
            if (!value.booleanValue()) continue;
            return interMap;
        }
        return new HashMap<String, Boolean>();
    }

    private Map<String, Object> countMap(int pageIndex, int pageSize, int count) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("pageIndex", pageIndex);
        dataMap.put("pageSize", pageSize);
        dataMap.put("count", count);
        dataMap.put("totalPage", count == 0 ? 0 : (int)Math.ceil((double)count * 1.0 / (double)pageSize));
        dataMap.put("data", new ArrayList());
        return dataMap;
    }

    private List<Map<String, Object>> dyTransferMap(DynamicObject[] dys) {
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
        Arrays.stream(dys).forEach(dy -> {
            HashMap<String, Object> contractMap = new HashMap<String, Object>();
            contractMap.put("id", dy.getLong("id"));
            contractMap.put("empnumber", dy.getString("empnumber"));
            contractMap.put("name", dy.getString("name"));
            contractMap.put("number", dy.getString("number"));
            contractMap.put("signway", dy.getString("signway"));
            contractMap.put("protocoltype", dy.getString("protocoltype"));
            dataList.add(contractMap);
        });
        return dataList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> updateFileForContractData(Map<String, Object> paramMap) {
        LOGGER.info("updateFileForContractData.param.is={}", paramMap);
        if (CollectionUtils.isEmpty(paramMap)) {
            return new HashMap<String, Object>();
        }
        try (TXHandle txHandle = TX.required();){
            String protocolType = String.valueOf(paramMap.get("protocolType"));
            HRBaseServiceHelper contractServiceHelper = new HRBaseServiceHelper("hlcm_contractsource");
            QFilter protocolFilter = new QFilter("protocolType", "=", (Object)protocolType);
            QFilter numberFilter = new QFilter("number", "=", (Object)String.valueOf(paramMap.get("number")));
            QFilter[] filters = new QFilter[]{protocolFilter, numberFilter};
            DynamicObject[] dataArray = contractServiceHelper.query("id,protocoltype,number,name,iscurrentversion,datastatus", filters);
            HashMap<Long, Map<String, Object>> idMap = new HashMap<Long, Map<String, Object>>(dataArray.length);
            Arrays.stream(dataArray).forEach(dynamicObject -> {
                long id = dynamicObject.getLong("id");
                idMap.put(id, paramMap);
            });
            Set longs = idMap.keySet();
            List stringIds = longs.stream().map(idLong -> String.valueOf(idLong)).collect(Collectors.toList());
            QFilter finterFilter = new QFilter("finterid", "in", stringIds);
            String dataPanelType = BosAttachmentRepository.getInstance().getDataPanelType(protocolType);
            QFilter panelTypeFilter = new QFilter("fbilltype", "=", (Object)dataPanelType);
            QFilter filePanelFilter = new QFilter("fattachmentpanel", "=", (Object)"paperattachment");
            BosAttachmentRepository.getInstance().delAttment(new QFilter[]{finterFilter, panelTypeFilter, filePanelFilter});
            List<DynamicObject> fileObjectList = BosAttachmentRepository.getInstance().assembleFile(idMap);
            BosAttachmentRepository.getInstance().saveAtt(fileObjectList.toArray(new DynamicObject[0]));
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put("errormsg", "file init success.");
            resultMap.put("number", paramMap.get("number"));
            resultMap.put("success", Boolean.TRUE);
            HashMap<String, Object> hashMap = resultMap;
            return hashMap;
        }
    }
}

