/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.domian.service.revise.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.common.HLCMCommonRepository;
import kd.hr.hlcm.business.domian.repository.CommonRepository;
import kd.hr.hlcm.business.domian.service.hbpm.IHbpmService;
import kd.hr.hlcm.business.domian.service.hismodel.helper.ContractHisHelper;
import kd.hr.hlcm.business.domian.service.hrpi.IHrpiService;
import kd.hr.hlcm.business.domian.service.revise.IReviseVersionService;
import kd.hr.hlcm.common.enums.ContractFileSignStatusEnum;
import kd.hr.hlcm.common.enums.ProtocolTypeEnum;

public class ReviseVersionServiceImpl
implements IReviseVersionService {
    private static final Log LOGGER = LogFactory.getLog(ReviseVersionServiceImpl.class);
    private static final String ID_SUBFIX = ".id";

    @Override
    public List<Map<String, Object>> queryContracts(Map<String, Object> filters) {
        ArrayList filterList = Lists.newArrayListWithExpectedSize((int)filters.size());
        filters.forEach((paramName, paramValue) -> {
            switch (paramName) {
                case "signedcompany": 
                case "department": {
                    ArrayList companyIds = Lists.newArrayList((Object[])((Long[])paramValue));
                    Map<Long, Long> adminOrgHis = IHbpmService.getInstance().getAdminOrgHis(companyIds);
                    filterList.add(new QFilter(paramName, "in", adminOrgHis.values()));
                    break;
                }
                case "position": {
                    ArrayList positionIds = Lists.newArrayList((Object[])((Long[])paramValue));
                    Map<Long, Long> posHis = IHbpmService.getInstance().getPosHis(positionIds);
                    filterList.add(new QFilter(paramName, "in", posHis.values()));
                    break;
                }
                case "stdposition": {
                    ArrayList stdPositionIds = Lists.newArrayList((Object[])((Long[])paramValue));
                    Map<Long, Long> stdPosHis = IHbpmService.getInstance().getStdPosHis(stdPositionIds);
                    filterList.add(new QFilter(paramName, "in", stdPosHis.values()));
                    break;
                }
                case "job": {
                    ArrayList jobIds = Lists.newArrayList((Object[])((Long[])paramValue));
                    Map<Long, Long> jobHis = IHbpmService.getInstance().getJobHis(jobIds);
                    filterList.add(new QFilter(paramName, "in", jobHis.values()));
                    break;
                }
                default: {
                    filterList.add(new QFilter(paramName, "in", paramValue));
                }
            }
        });
        QFilter filter = (QFilter)filterList.stream().reduce((f1, f2) -> f1.and(f2)).orElseThrow(() -> new KDBizException("no match param"));
        QFilter isCurrentVersion = new QFilter("iscurrentversion", "=", (Object)"1");
        String selectProperties = "boid,number,signway,businesstype,signstatus,contractstatus,protocoltype,ermanfile.id,name,empnumber,actualsigncompany.id,actualsigncompanyhis.id,contracttype.id,periodtype.id,startdate,enddate,planenddate,actualenddate,period,periodunit,signeddate,signreason,maincontract.id,entryentity.texthis,ermanorg.id,adminororg.id,ermanperorg.id,signedcompany.id,department.id,position.id,stdposition.id,job.id";
        DynamicObject[] queryResult = HLCMCommonRepository.queryDynamicObjects("hlcm_contractsource", selectProperties, filter, isCurrentVersion);
        ArrayList result = Lists.newArrayListWithExpectedSize((int)queryResult.length);
        for (DynamicObject dy : queryResult) {
            LinkedHashMap contract = Maps.newLinkedHashMapWithExpectedSize((int)36);
            contract.put("boid", dy.getLong("boid"));
            contract.put("id", dy.getLong("id"));
            contract.put("number", dy.getString("number"));
            contract.put("empnumber", dy.getString("empnumber"));
            contract.put("name", dy.getString("name"));
            contract.put("signreason", dy.getString("signreason"));
            contract.put("signway", dy.getString("signway"));
            contract.put("businesstype", dy.getString("businesstype"));
            contract.put("signstatus", dy.getString("signstatus"));
            contract.put("contractstatus", dy.getString("contractstatus"));
            contract.put("protocoltype", dy.getString("protocoltype"));
            contract.put("periodunit", dy.getString("periodunit"));
            contract.put("ermanfile", dy.getLong("ermanfile.id"));
            contract.put("actualsigncompany", dy.getLong("actualsigncompany.id"));
            contract.put("actualsigncompanyhis", dy.getLong("actualsigncompanyhis.id"));
            contract.put("contracttype", dy.getLong("contracttype.id"));
            contract.put("periodtype", dy.getLong("periodtype.id"));
            contract.put("maincontract", dy.getString("maincontract.id"));
            contract.put("ermanorg", dy.getLong("ermanorg.id"));
            contract.put("adminororg", dy.getLong("adminororg.id"));
            contract.put("ermanperorg", dy.getLong("ermanperorg.id"));
            contract.put("signedcompany", dy.getLong("signedcompany.id"));
            contract.put("department", dy.getLong("department.id"));
            contract.put("position", dy.getLong("position.id"));
            contract.put("stdposition", dy.getLong("stdposition.id"));
            contract.put("job", dy.getLong("job.id"));
            DynamicObjectCollection textHis = dy.getDynamicObjectCollection("entryentity");
            contract.put("texthis", textHis.stream().map(text -> text.getLong("texthis.id")).toArray(Long[]::new));
            contract.put("startdate", dy.getDate("startdate"));
            contract.put("enddate", dy.getDate("enddate"));
            contract.put("planenddate", dy.getDate("planenddate"));
            contract.put("actualenddate", dy.getDate("actualenddate"));
            contract.put("period", dy.getBigDecimal("period"));
            contract.put("signeddate", dy.getDate("signeddate"));
            result.add(contract);
        }
        return result;
    }

    @Override
    public void reviseVersion(List<Map<String, Object>> reviseInfos) {
        HashMap<Long, Map<String, Object>> reviseInfoMap = new HashMap<Long, Map<String, Object>>();
        for (Map<String, Object> reviseInfo : reviseInfos) {
            Long boId = HRJSONUtils.getLongValOfCustomParam((Object)reviseInfo.get("boid"));
            if (!Objects.nonNull(boId) || Objects.equals(boId, 0L)) continue;
            reviseInfoMap.put(boId, reviseInfo);
        }
        List<Long> companyIds = this.getIds(reviseInfos, "signedcompany");
        List<Long> departments = this.getIds(reviseInfos, "department");
        List<Long> positionIds = this.getIds(reviseInfos, "position");
        List<Long> stdPositionIds = this.getIds(reviseInfos, "stdposition");
        List<Long> jobIds = this.getIds(reviseInfos, "job");
        IHbpmService instance = IHbpmService.getInstance();
        Map<Long, Long> companyIdHisMap = instance.getAdminOrgHis(companyIds);
        Map<Long, Long> departmentIdHisMap = instance.getAdminOrgHis(departments);
        Map<Long, Long> positionIdHisMap = instance.getPosHis(positionIds);
        Map<Long, Long> stdPositionIdHisMap = instance.getStdPosHis(stdPositionIds);
        Map<Long, Long> jobIdHisMap = instance.getJobHis(jobIds);
        QFilter boIdsFilter = new QFilter("boid", "in", reviseInfoMap.keySet());
        DynamicObject[] events = HLCMCommonRepository.queryDynamicObjects("hlcm_busievent", String.join((CharSequence)",", "boid", "sourceentity"), boIdsFilter);
        HashMap entityGroup = Maps.newHashMapWithExpectedSize((int)4);
        for (DynamicObject event : events) {
            long boId = event.getLong("boid");
            String sourceEntity = event.getString("sourceentity");
            ArrayList<Long> list2 = (ArrayList<Long>)entityGroup.get(sourceEntity);
            if (Objects.isNull(list2)) {
                list2 = new ArrayList<Long>();
                entityGroup.put(sourceEntity, list2);
            }
            list2.add(boId);
        }
        QFilter versionFilter = new QFilter("iscurrentversion", "!=", (Object)"1");
        QFilter dataStatusFilter = new QFilter("datastatus", "!=", (Object)"-4");
        entityGroup.forEach((entityNumber, list) -> {
            DynamicObject[] reviseDys;
            for (DynamicObject reviseDy : reviseDys = HLCMCommonRepository.queryDynamicObjects(entityNumber, null, boIdsFilter, versionFilter, dataStatusFilter)) {
                long boId = reviseDy.getLong("boid");
                Map reviseInfo = (Map)reviseInfoMap.get(boId);
                reviseInfo.forEach((property, value) -> {
                    switch (property) {
                        case "boid": {
                            break;
                        }
                        case "signedcompany": {
                            this.setHis(reviseDy, (String)property, value, companyIdHisMap);
                            break;
                        }
                        case "department": {
                            this.setHis(reviseDy, (String)property, value, departmentIdHisMap);
                            break;
                        }
                        case "position": {
                            this.setHis(reviseDy, (String)property, value, positionIdHisMap);
                            break;
                        }
                        case "stdposition": {
                            this.setHis(reviseDy, (String)property, value, stdPositionIdHisMap);
                            break;
                        }
                        case "job": {
                            this.setHis(reviseDy, (String)property, value, jobIdHisMap);
                            break;
                        }
                        default: {
                            Object originalValue = reviseDy.get(String.format(Locale.ROOT, "%s_id", property));
                            if (null == value || Objects.equals(0L, value) || Objects.equals(originalValue, value)) break;
                            reviseDy.set(property, value);
                        }
                    }
                });
            }
            DynamicObject[] reviseDirties = (DynamicObject[])Stream.of(reviseDys).filter(dy -> dy.getDataEntityState().getDataEntityDirty()).toArray(DynamicObject[]::new);
            if (reviseDirties.length == 0) {
                LOGGER.warn("reviseDys length=0 need not reviseVersion");
            } else {
                ContractHisHelper.getInstance().reviseVersion((String)entityNumber, reviseDirties);
            }
        });
    }

    @Override
    public void reviseContractVal(Long afterErmanId, Long beforeErmanId) {
        if (afterErmanId != 0L && beforeErmanId != 0L) {
            String selectFields = "id" + ',' + "org_id" + ',' + "empgroup_id" + ',' + "person_id" + ',' + "affiliateadminorg_id" + ',' + "empposrel";
            QFilter custFilter = new QFilter("id", "=", (Object)afterErmanId);
            DynamicObject[] ermanFileDys = IHrpiService.getInstance().listFieldsFilterInfo(selectFields, custFilter, "hspm_ermanfile");
            if (ermanFileDys == null || ermanFileDys.length == 0) {
                LOGGER.info("===listFieldsFilterInfo ermanFileDys is empty===");
                return;
            }
            DynamicObject ermanDy = ermanFileDys[0];
            QFilter preFilter = new QFilter("datastatus", "=", (Object)"0");
            QFilter currFilter = new QFilter("datastatus", "=", (Object)"1").and("iscurrentversion", "=", (Object)"0");
            HashSet sets = Sets.newHashSet((Object[])new String[]{ContractFileSignStatusEnum.CANCEL_SIGN.getCombKey(), ContractFileSignStatusEnum.STOP_SIGNED.getCombKey()});
            QFilter endFilter = new QFilter("signstatus", "not in", (Object)sets);
            QFilter ermanIdFilter = new QFilter("ermanfile.id", "=", (Object)beforeErmanId);
            String sourceSel = "id" + ',' + "protocoltype";
            DynamicObject[] contracts = CommonRepository.query("hlcm_contractsource", sourceSel, new QFilter[]{preFilter.or(currFilter), endFilter, ermanIdFilter});
            if (contracts == null || contracts.length == 0) {
                LOGGER.info("==contracts is empty==");
                return;
            }
            ArrayList<Long> contractIds = new ArrayList<Long>(contracts.length);
            ArrayList<Long> empIds = new ArrayList<Long>(contracts.length);
            ArrayList<Long> otherIds = new ArrayList<Long>(contracts.length);
            for (DynamicObject dy : contracts) {
                if (HRStringUtils.equals((String)dy.getString("protocoltype"), (String)ProtocolTypeEnum.CON.getCombKey())) {
                    contractIds.add(dy.getLong("id"));
                    continue;
                }
                if (HRStringUtils.equals((String)dy.getString("protocoltype"), (String)ProtocolTypeEnum.YG.getCombKey())) {
                    empIds.add(dy.getLong("id"));
                    continue;
                }
                if (!HRStringUtils.equals((String)dy.getString("protocoltype"), (String)ProtocolTypeEnum.FS.getCombKey())) continue;
                otherIds.add(dy.getLong("id"));
            }
            DynamicObject[] conDys = CommonRepository.queryByIds("hlcm_contract", "", contractIds);
            DynamicObject[] empDys = CommonRepository.queryByIds("hlcm_contractfileemp", "", empIds);
            DynamicObject[] otherDys = CommonRepository.queryByIds("hlcm_contractfileother", "", otherIds);
            this.compareAndReviseCon(ermanDy, conDys, "hlcm_contract");
            this.compareAndReviseCon(ermanDy, empDys, "hlcm_contractfileemp");
            this.compareAndReviseCon(ermanDy, otherDys, "hlcm_contractfileother");
        }
    }

    @Override
    public void compareAndReviseCon(DynamicObject ermanDy, DynamicObject[] conDys, String entityName) {
        if (conDys != null && conDys.length > 0) {
            ArrayList preConList = new ArrayList();
            this.compareSetConValue(ermanDy, conDys);
            List chgContract = Arrays.stream(conDys).filter(dy -> dy.getDataEntityState().getDataEntityDirty()).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(chgContract)) {
                preConList.addAll(chgContract);
            }
            if (!CollectionUtils.isEmpty(preConList)) {
                ContractHisHelper.getInstance().reviseVersion(entityName, preConList.toArray(new DynamicObject[0]));
            }
        }
    }

    private void compareSetConValue(DynamicObject ermanFile, DynamicObject[] conDys) {
        Long ermanId = ermanFile.getLong("id");
        Long ermanOrgId = ermanFile.getLong("org_id");
        Long ermanAdminOrgId = ermanFile.getLong("affiliateadminorg_id");
        Long ermanPerOrgId = ermanFile.getLong("empgroup_id");
        for (DynamicObject contract : conDys) {
            if (contract.getDate("bsed") == null) continue;
            Long conErmanId = contract.getLong("ermanfile_id");
            Long conOrgId = contract.getLong("ermanorg_id");
            Long conAdminOrgId = contract.getLong("adminororg_id");
            Long perOrgId = contract.getLong("ermanperorg_id");
            if (!Objects.equals(ermanId, conErmanId)) {
                contract.set("ermanfile_id", (Object)ermanId);
            }
            if (!Objects.equals(ermanOrgId, conOrgId)) {
                contract.set("ermanorg_id", (Object)ermanOrgId);
            }
            if (!Objects.equals(ermanAdminOrgId, conAdminOrgId)) {
                contract.set("adminororg_id", (Object)ermanAdminOrgId);
            }
            if (Objects.equals(ermanPerOrgId, perOrgId)) continue;
            contract.set("ermanperorg_id", (Object)ermanPerOrgId);
        }
    }

    private void setHis(DynamicObject reviseDy, String property, Object value, Map<Long, Long> hisMap) {
        Object originalValue = reviseDy.get(String.format(Locale.ROOT, "%s_id", property));
        Long longValue = HRJSONUtils.getLongValOfCustomParam((Object)value);
        Long hisValue = hisMap.get(longValue);
        if (!Objects.equals(0L, hisValue) && !Objects.equals(originalValue, hisValue)) {
            reviseDy.set(property, (Object)hisValue);
        }
    }

    private List<Long> getIds(List<Map<String, Object>> reviseInfos, String propertyName) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)reviseInfos.size());
        for (Map<String, Object> reviseInfo : reviseInfos) {
            Long id = HRJSONUtils.getLongValOfCustomParam((Object)reviseInfo.get(propertyName));
            if (null == id || Objects.equals(id, 0L)) continue;
            result.add(id);
        }
        return result;
    }
}

