/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.domian.sharecenter.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.domian.repository.CommonRepository;
import kd.hr.hlcm.business.domian.service.signmgt.ISignManageService;
import kd.hr.hlcm.business.domian.sharecenter.ButtonVisibleService;
import kd.hr.hlcm.common.enums.ActivityStatusEnum;
import kd.hr.hlcm.common.enums.ButtonEnum;
import kd.hr.hlcm.common.enums.HandleStatusEnum;
import kd.hr.hlcm.common.enums.ProcessStatusEnum;
import kd.hr.hlcm.common.enums.SignTabEnum;

public class ButtonVisibleServiceImpl
implements ButtonVisibleService {
    private static final Log LOGGER = LogFactory.getLog(ButtonVisibleServiceImpl.class);
    private static final String BTN_KEY = "btnkey";
    private static final String BTN_NAME = "btnname";
    private static final String OP_KEY = "opkey";

    @Override
    public Map<String, Object> buttonVisible(Map<String, Object> paramMap) {
        LOGGER.info("ButtonVisibleServiceImpl.buttonVisible.begin={}", paramMap);
        try {
            Object activityId = paramMap.get("activityId");
            DynamicObject activityDy = CommonRepository.queryDynamicObjectByPk("hlcm_activity", "signapply,processstatus,activity.id", activityId);
            LOGGER.info("ButtonVisibleServiceImpl.buttonVisible.activity={}", (Object)activityDy);
            if (HRObjectUtils.isEmpty((Object)activityDy)) {
                return this.resultMap("activity.instance.do.not.exit", new HashMap<String, Object>(), Boolean.TRUE, "301");
            }
            LOGGER.info("ButtonVisibleServiceImpl.buttonVisible.activity: id : {};signapply.id : {};processstatus \uff1a {};activity.id \uff1a {}.", new Object[]{activityDy.getLong("id"), activityDy.getLong("signapply.id"), activityDy.getString("processstatus"), activityDy.getLong("activity.id")});
            HRBaseServiceHelper signServiceHelper = new HRBaseServiceHelper("hlcm_contractapplybase");
            DynamicObject signDy = signServiceHelper.loadSingle((Object)activityDy.getLong("signapply.id"));
            String handleStatus = signDy.getString("handlestatus");
            LOGGER.info("ButtonVisibleServiceImpl.buttonVisible.handleStatus={}", (Object)handleStatus);
            String listFormId = String.valueOf(paramMap.get("activityNumber"));
            List<Map<String, String>> btnList = new ArrayList<Map<String, String>>(2);
            this.setDefaultBtn(btnList);
            Map<String, Object> resultMap = this.resultData(activityId, listFormId, btnList);
            if (HRStringUtils.equals((String)handleStatus, (String)HandleStatusEnum.PROCESSEND.getCombKey())) {
                return this.resultMap("success", resultMap, Boolean.TRUE, "300");
            }
            List<String> excludeForm = Arrays.asList(SignTabEnum.P_STOP.getSourceListFormId(), SignTabEnum.P_ARCHIVE.getSourceListFormId(), SignTabEnum.E_STOP.getSourceListFormId(), SignTabEnum.E_ARCHIVE.getSourceListFormId());
            if (excludeForm.contains(listFormId)) {
                LOGGER.info("ButtonVisibleServiceImpl.buttonVisible.excludeForm.listFormId={}", (Object)listFormId);
                return this.resultMap("do not in search range", new HashMap<String, Object>(), Boolean.TRUE, "301");
            }
            SignTabEnum signEnum = SignTabEnum.getTabEnumByActivity((Long)activityDy.getLong("activity.id"));
            String processStatus = activityDy.getString("processstatus");
            switch (signEnum) {
                case P_BEGIN: 
                case E_BEGIN: {
                    btnList = this.stopButtonVisible(btnList, signDy, listFormId, processStatus);
                    LOGGER.info("ButtonVisibleServiceImpl.buttonVisible : Begin : before beginSignVisible btnList = {}", btnList);
                    ActivityStatusEnum activityStatusEnum = ISignManageService.getInstance().getActivityStatusEnum(signDy);
                    boolean beginSignVisible = ISignManageService.getInstance().isAbleBeginSign(activityStatusEnum);
                    LOGGER.info("ButtonVisibleServiceImpl.buttonVisible.beginSignVisible={}", (Object)beginSignVisible);
                    if (beginSignVisible) break;
                    this.setVisibleBtn(btnList, "beginsign");
                    break;
                }
                case P_CHECK: 
                case E_CHECK: {
                    if (!HRStringUtils.equals((String)processStatus, (String)ProcessStatusEnum.PENDING.getValue())) break;
                    Map<String, String> archiveMap = this.setBtnMap("archive");
                    btnList.add(archiveMap);
                    break;
                }
                case P_COMP: 
                case E_CSIGN: {
                    this.stopButtonVisible(btnList, signDy, listFormId, processStatus);
                    LOGGER.info("ButtonVisibleServiceImpl.buttonVisible : Comp or CSign : before setVisibleBtn btnList = {}", btnList);
                    if (HRStringUtils.equals((String)processStatus, (String)ProcessStatusEnum.PENDING.getValue())) break;
                    this.setVisibleBtn(btnList, HRStringUtils.equals((String)"hlcm_electric_csignlist", (String)listFormId) ? "companysign" : "compsign");
                    break;
                }
            }
            LOGGER.info("ButtonVisibleServiceImpl.buttonVisible.btnList={}", btnList);
            return this.resultMap("success", resultMap, Boolean.TRUE, "300");
        }
        catch (Exception exe) {
            LOGGER.error("ButtonVisibleServiceImpl.buttonVisible.error", (Throwable)exe);
            return this.resultMap("fail", new HashMap<String, Object>(), Boolean.FALSE, "302");
        }
    }

    private Map<String, Object> resultMap(String msg, Map<String, Object> dataMap, Boolean isSuccess, String code) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        resultMap.put("message", msg);
        resultMap.put("success", isSuccess);
        resultMap.put("data", dataMap);
        resultMap.put("code", code);
        return resultMap;
    }

    private Map<String, Object> resultData(Object activityId, String listFormId, List<Map<String, String>> btnList) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        resultMap.put("activityId", activityId);
        resultMap.put("showform", SignTabEnum.getFormIdByListFormId((String)listFormId));
        resultMap.put("buttons", btnList);
        return resultMap;
    }

    private List<Map<String, String>> stopButtonVisible(List<Map<String, String>> btnList, DynamicObject signDy, String listFormId, String processStatus) {
        String handleStatus = signDy.getString("handlestatus");
        boolean handleStatusBoolean = HRStringUtils.equals((String)handleStatus, (String)HandleStatusEnum.PROCESSEND.getCombKey());
        if (!handleStatusBoolean) {
            Map<String, String> compMap;
            if (HRStringUtils.equals((String)"hlcm_paper_beginlist", (String)listFormId) || HRStringUtils.equals((String)"hlcm_electric_beginlist", (String)listFormId)) {
                Map<String, String> beginMap = this.setBtnMap("beginsign");
                btnList.add(beginMap);
            }
            if (HRStringUtils.equals((String)"hlcm_paper_complist", (String)listFormId)) {
                compMap = this.setBtnMap("compsign");
                btnList.add(compMap);
            }
            if (HRStringUtils.equals((String)"hlcm_electric_csignlist", (String)listFormId)) {
                compMap = this.setBtnMap("companysign");
                btnList.add(compMap);
            }
        }
        boolean processStatusBoolean = HRStringUtils.equals((String)processStatus, (String)ProcessStatusEnum.PROCESSED.getValue());
        if (!handleStatusBoolean && !processStatusBoolean) {
            Map<String, String> stopMap = this.setBtnMap("stopsign");
            btnList.add(stopMap);
        }
        return btnList;
    }

    private void setVisibleBtn(List<Map<String, String>> btnList, String btnKey) {
        Iterator<Map<String, String>> iterator = btnList.iterator();
        while (iterator.hasNext()) {
            Map<String, String> next = iterator.next();
            if (!HRStringUtils.equals((String)btnKey, (String)next.get(BTN_KEY))) continue;
            iterator.remove();
        }
    }

    private Map<String, String> setBtnMap(String btnKey) {
        HashMap<String, String> btnMap = new HashMap<String, String>(4);
        btnMap.put(BTN_KEY, btnKey);
        btnMap.put(BTN_NAME, ButtonEnum.getValueByKey((String)btnKey));
        btnMap.put(OP_KEY, ButtonEnum.getOpKeyByCombKey((String)btnKey));
        return btnMap;
    }

    private void setDefaultBtn(List<Map<String, String>> btnList) {
        Map<String, String> exitMap = this.setBtnMap("signout");
        Map<String, String> refreshMap = this.setBtnMap("tblrefresh");
        btnList.add(exitMap);
        btnList.add(refreshMap);
    }
}

