/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.domian.sharecenter.impl;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hlcm.business.domian.sharecenter.IShareService;
import kd.hr.hpfs.common.utils.ObjectUtils;
import kd.sdk.hr.ssc.business.mservice.helper.SSCSLAServiceHelper;
import kd.sdk.hr.ssc.common.dto.SLATimeInfoDTO;

public class ShareServiceImpl
implements IShareService {
    private static final Log LOGGER = LogFactory.getLog(ShareServiceImpl.class);

    @Override
    public Map<Long, SLATimeInfoDTO> getSlaInfo(DynamicObjectCollection dyCol) {
        if (dyCol == null || dyCol.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<Long, Long> taskMap = dyCol.stream().filter(dy -> !ObjectUtils.isEmpty((Object)dy.get("activityins.ssctaskid"))).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("activityins.ssctaskid")));
        return this.requestSla(taskMap);
    }

    private Map<Long, SLATimeInfoDTO> requestSla(Map<Long, Long> taskMap) {
        if (taskMap != null && taskMap.size() > 0) {
            ArrayList<Long> taskIds = new ArrayList<Long>(taskMap.values());
            Map map = SSCSLAServiceHelper.getSLAInfoByIds(taskIds);
            LOGGER.info("ShareServiceImpl.getSlaInfo,taskids:{},result:{}", taskIds, (Object)map);
            if (map == null || map.isEmpty()) {
                return Collections.emptyMap();
            }
            HashMap slaMap = Maps.newHashMapWithExpectedSize((int)map.size());
            taskMap.entrySet().forEach(item -> {
                SLATimeInfoDTO slaTimeInfoDTO = (SLATimeInfoDTO)map.get(item.getValue());
                if (slaTimeInfoDTO != null) {
                    slaMap.put(item.getKey(), slaTimeInfoDTO);
                }
            });
            return slaMap;
        }
        return Collections.emptyMap();
    }
}

