/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.mq;

import com.alibaba.fastjson.JSONObject;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.domian.repository.CommonRepository;
import kd.hr.hlcm.common.utils.ComboUtils;

public class MessageTemplateParser {
    private static final Log LOG = LogFactory.getLog(MessageTemplateParser.class);
    private static final String FMT_DATE = "yyyy-MM-dd";
    private static final String DESCRIPTION = "description";
    private static final String CONTENT = "content";
    private static final String TITLE = "title";

    public static Tuple<String, String> getMessageContext(String templateNumber, Long businessId) {
        DynamicObject dynamicObject = CommonRepository.queryDynamicObjectByNumber("msg_template", "", templateNumber);
        if (Objects.isNull(dynamicObject) || HRStringUtils.isEmpty((String)templateNumber)) {
            return Tuple.create((Object)"", (Object)"");
        }
        String msgTemplate = dynamicObject.getLocaleString("msgtemplate").getLocaleValue_zh_CN();
        LOG.info(MessageFormat.format("msgTemplate is: {0},templateNumber is {1},applybill is {2}", msgTemplate, templateNumber, businessId));
        DynamicObject msgEntity = dynamicObject.getDynamicObject("msgentity");
        String dentityid = msgEntity.getString("id");
        DynamicObject businessDynamicObject = CommonRepository.queryDynamicObjectByPk(dentityid, "", businessId);
        ArrayList<String> params = new ArrayList<String>();
        JSONObject templateObject = JSONObject.parseObject((String)msgTemplate);
        String str = MessageTemplateParser.parseMsgTemplate(templateObject.getString(CONTENT), params);
        ArrayList<String> result = new ArrayList<String>();
        for (String param : params) {
            boolean isEnumParams = param.startsWith("absenum");
            if (isEnumParams) {
                param = param.substring(param.indexOf(40) + 1, param.indexOf(41));
            }
            String[] split = param.split("\\.");
            DynamicObject object = MessageTemplateParser.getDynamicObject(split, businessDynamicObject, 1);
            String strId = split[split.length - 1];
            if (Objects.isNull(object)) {
                result.add(strId);
                continue;
            }
            String string = object.get(strId) != null && Timestamp.class.equals(object.get(strId).getClass()) ? HRDateTimeUtils.format((Date)object.getDate(strId), (String)FMT_DATE) : object.getString(strId);
            if (isEnumParams) {
                string = ComboUtils.getComboOptionLocaleName((DynamicObject)object, (String)strId);
            }
            result.add(string);
        }
        return Tuple.create((Object)templateObject.getString(TITLE), (Object)MessageFormat.format(str, result.toArray()));
    }

    public static Tuple<String, String> getMessageContextNoParam(String templateNumber) {
        DynamicObject dynamicObject = CommonRepository.queryDynamicObjectByNumber("msg_template", "", templateNumber);
        if (Objects.isNull(dynamicObject) || HRStringUtils.isEmpty((String)templateNumber)) {
            return Tuple.create((Object)"", (Object)"");
        }
        String msgTemplate = dynamicObject.getLocaleString("msgtemplate").getLocaleValue_zh_CN();
        LOG.info(MessageFormat.format("msgTemplate is: {0},templateNumber is {1}", msgTemplate, templateNumber));
        JSONObject templateObject = JSONObject.parseObject((String)msgTemplate);
        return Tuple.create((Object)templateObject.getString(TITLE), (Object)templateObject.getString(CONTENT));
    }

    public static Tuple<String, String> getMessageContext(String templateNumber, Long businessId, Map<String, String> paramMap) {
        DynamicObject dynamicObject = CommonRepository.queryDynamicObjectByNumber("msg_template", "", templateNumber);
        if (Objects.isNull(dynamicObject) || HRStringUtils.isEmpty((String)templateNumber)) {
            return Tuple.create((Object)"", (Object)"");
        }
        String msgTemplate = dynamicObject.getLocaleString("msgtemplate").getLocaleValue_zh_CN();
        LOG.info(MessageFormat.format("msgTemplate is: {0},templateNumber is {1},applybill is {2}", msgTemplate, templateNumber, businessId));
        DynamicObject msgEntity = dynamicObject.getDynamicObject("msgentity");
        String dentityid = msgEntity.getString("id");
        DynamicObject businessDynamicObject = CommonRepository.queryDynamicObjectByPk(dentityid, "", businessId);
        ArrayList<String> params = new ArrayList<String>();
        JSONObject templateObject = JSONObject.parseObject((String)msgTemplate);
        String str = MessageTemplateParser.parseMsgTemplate(templateObject.getString(CONTENT), params);
        List<String> result = MessageTemplateParser.changeParams(paramMap, businessDynamicObject, params);
        String title = MessageTemplateParser.parseMsgTemplate(templateObject.getString(TITLE), params);
        List<String> titleRes = MessageTemplateParser.changeParams(paramMap, businessDynamicObject, params);
        return Tuple.create((Object)MessageFormat.format(title, titleRes.toArray()), (Object)MessageFormat.format(str, result.toArray()));
    }

    private static List<String> changeParams(Map<String, String> paramMap, DynamicObject businessDynamicObject, List<String> params) {
        ArrayList<String> result = new ArrayList<String>();
        for (String param : params) {
            String[] split = param.split("\\.");
            DynamicObject object = MessageTemplateParser.getDynamicObject(split, businessDynamicObject, 1);
            String strId = split[split.length - 1];
            if (Objects.isNull(object)) {
                result.add(strId);
                continue;
            }
            String string = object.getDataEntityType().getProperties().containsKey((Object)strId) ? (object.get(strId) != null && Timestamp.class.equals(object.get(strId).getClass()) ? HRDateTimeUtils.format((Date)object.getDate(strId), (String)FMT_DATE) : object.getString(strId)) : HRStringUtils.cnulls((String)paramMap.get(strId), (String)"");
            result.add(string);
        }
        return result;
    }

    private static DynamicObject getDynamicObject(String[] split, DynamicObject dynamicObject, int index) {
        if (index < split.length - 1) {
            DynamicObject dynamicObject1 = dynamicObject.getDynamicObject(split[index]);
            return MessageTemplateParser.getDynamicObject(split, dynamicObject1, index + 1);
        }
        return dynamicObject;
    }

    private static String parseMsgTemplate(String msgTemplate, List<String> params) {
        if (HRStringUtils.isEmpty((String)msgTemplate)) {
            return "";
        }
        String result = msgTemplate;
        String[] split = msgTemplate.split("\\{");
        if (split.length <= 1) {
            return result;
        }
        for (int i = 1; i < split.length; ++i) {
            String s = split[i];
            params.add(s.substring(0, s.indexOf(125)));
            result = result.replace('{' + s.substring(0, s.indexOf(125)) + '}', '{' + String.valueOf(i - 1) + '}');
        }
        return result;
    }
}

