/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.prewarn;

import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.common.HLCMCommonRepository;
import kd.hr.hlcm.business.domian.repository.ContractApplyRepository;
import kd.hr.hlcm.business.domian.repository.HiredPersonRepository;
import kd.hr.hlcm.common.enums.BusinessTypeEnum;
import kd.hr.hlcm.common.enums.LabRelTypeEnum;
import kd.hr.hlcm.common.enums.PreWarnPersonStatusEnum;
import kd.hr.hlcm.common.enums.PreWarnTypeEnum;
import kd.hr.hlcm.common.enums.ProtocolTypeEnum;
import kd.hr.hlcm.common.enums.StartStatusEnum;

public class SyncStartStatusService {
    private static final Log LOGGER = LogFactory.getLog(SyncStartStatusService.class);

    public static SyncStartStatusService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private void setHirePersonStartStatus(Long employeeId, DynamicObject hiredPerson) {
        List<List> personsWhereInSigning = ContractApplyRepository.getInstance().getEmployeeWhereInSigning(new Object[]{employeeId});
        if (personsWhereInSigning.get(0).contains(employeeId)) {
            hiredPerson.set("startstatus", (Object)PreWarnPersonStatusEnum.NOTSTART.getCombKey());
        } else if (personsWhereInSigning.get(1).contains(employeeId)) {
            hiredPerson.set("startstatus", (Object)PreWarnPersonStatusEnum.TOSUBMIT.getCombKey());
        } else if (personsWhereInSigning.get(2).contains(employeeId)) {
            hiredPerson.set("startstatus", (Object)PreWarnPersonStatusEnum.PROCESSIN.getCombKey());
        } else if (personsWhereInSigning.get(3).contains(employeeId)) {
            hiredPerson.set("startstatus", (Object)PreWarnPersonStatusEnum.PROCESSEND.getCombKey());
        } else {
            hiredPerson.set("startstatus", (Object)PreWarnPersonStatusEnum.ARCHIVE.getCombKey());
        }
    }

    public void saveHirePerson(Long personId) {
        DynamicObject ermanFile = (DynamicObject)HRMServiceHelper.invokeHRService((String)"hspm", (String)"IHSPMService", (String)"getPrimaryErmanfFile", (Object[])new Object[]{personId});
        DynamicObject hiredPerson = HiredPersonRepository.getInstance().generateEmptyDynamicObject();
        hiredPerson.set("person", (Object)personId);
        hiredPerson.set("ermanfile", ermanFile.getPkValue());
        hiredPerson.set("ermanorg", (Object)ermanFile.getLong("org_id"));
        hiredPerson.set("adminororg", (Object)ermanFile.getLong("affiliateadminorg_id"));
        hiredPerson.set("ermanperorg", (Object)ermanFile.getLong("empgroup_id"));
        hiredPerson.set("empposrel", ermanFile.get("empposrel"));
        hiredPerson.set("empentrel", ermanFile.get("empentrel"));
        hiredPerson.set("personname", ermanFile.get("name"));
        hiredPerson.set("empnumber", ermanFile.get("number"));
        long employeeId = ermanFile.getLong("employee.id");
        hiredPerson.set("employee", (Object)employeeId);
        this.setHirePersonStartStatus(employeeId, hiredPerson);
        HiredPersonRepository.getInstance().save(hiredPerson);
    }

    public void syncHirePersonStartStatus(DynamicObject ... signBills) {
        List employeeIds = Stream.of(signBills).filter(signBill -> HRStringUtils.equals((String)signBill.getString("businesstype"), (String)BusinessTypeEnum.NEW.getCombKey())).map(signBill -> signBill.getLong("employee.id")).collect(Collectors.toList());
        if (employeeIds.isEmpty()) {
            return;
        }
        QFilter filters = new QFilter("employee", "in", employeeIds);
        ThreadPools.executeOnce((String)"syncHirePersonStartStatus", () -> this.modifyHirePersonStartStatus(Optional.of(filters)));
    }

    public void syncHirePersonStartStatus() {
        this.modifyHirePersonStartStatus(Optional.empty());
    }

    private void modifyHirePersonStartStatus(Optional<QFilter> filterOptional) {
        QFilter filter = new QFilter("startstatus", "!=", (Object)StartStatusEnum.ARCHIVE.getCombKey());
        filterOptional.ifPresent(arg_0 -> ((QFilter)filter).and(arg_0));
        String property = "empentrel.laborreltype.laborreltypecls";
        QFilter conFilter = new QFilter(property, "=", (Object)LabRelTypeEnum.EMPLOYMENT.getCombKey());
        QFilter empFilter = new QFilter(property, "in", (Object)Lists.newArrayList((Object[])new Long[]{LabRelTypeEnum.INTERNSHIP.getCombKey(), LabRelTypeEnum.LABORSERVICE.getCombKey(), LabRelTypeEnum.REEMPLOYMENT.getCombKey(), LabRelTypeEnum.OUTERCLASS.getCombKey()}));
        String selectProperties = "employee,person.id,startstatus";
        Object[] contractWarns = HLCMCommonRepository.queryDynamicObjects("hlcm_hiredperson", selectProperties, filter, conFilter);
        this.modifyStartStatus(Lists.newArrayList((Object[])contractWarns), ProtocolTypeEnum.CON);
        Object[] empWarns = HLCMCommonRepository.queryDynamicObjects("hlcm_hiredperson", selectProperties, filter, empFilter);
        this.modifyStartStatus(Lists.newArrayList((Object[])empWarns), ProtocolTypeEnum.YG);
    }

    private void modifyStartStatus(List<DynamicObject> contractWarns, ProtocolTypeEnum protocolTypeEnum) {
        if (CollectionUtils.isEmpty(contractWarns)) {
            return;
        }
        Set employeeIds = contractWarns.stream().map(con -> con.getLong("employee.id")).collect(Collectors.toSet());
        QFilter filters = new QFilter("employee", "in", employeeIds);
        filters.and("protocoltype", "=", (Object)protocolTypeEnum.getCombKey());
        filters.and("businesstype", "=", (Object)BusinessTypeEnum.NEW.getCombKey());
        if (protocolTypeEnum == ProtocolTypeEnum.CON) {
            filters.and("postype", "=", (Object)1010L);
        }
        DynamicObject[] signBills = HLCMCommonRepository.queryDynamicObjects("hlcm_contractapplybase", String.join((CharSequence)",", "handlestatus", "person.id", "employee"), "startdate", filters);
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        QFilter versionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        DynamicObject[] contracts = HLCMCommonRepository.queryDynamicObjects("hlcm_contract", String.join((CharSequence)",", "handlestatus", "person.id", "employee"), filters, initStatusFilter, versionFilter);
        Set existContractPersonSets = Stream.of(contracts).map(dy -> dy.getLong("employee.id")).collect(Collectors.toSet());
        Map<Long, String> personStartStatusMap = Stream.of(signBills).collect(Collectors.toMap(signBill -> signBill.getLong("employee.id"), signBill -> signBill.getString("handlestatus"), (v1, v2) -> v2));
        contractWarns.forEach(contractWarn -> {
            long employeeId = contractWarn.getLong("employee.id");
            if (existContractPersonSets.contains(employeeId)) {
                contractWarn.set("startstatus", (Object)StartStatusEnum.ARCHIVE.getCombKey());
            } else {
                contractWarn.set("startstatus", (Object)Optional.ofNullable(personStartStatusMap.get(employeeId)).orElseGet(() -> ((StartStatusEnum)StartStatusEnum.TOINITIATED).getCombKey()));
            }
        });
        HLCMCommonRepository.updateDynamicObjects("hlcm_hiredperson", contractWarns.toArray(new DynamicObject[0]));
    }

    public void deletePreWarn(Long personId) {
        try {
            QFilter personFilter = new QFilter("person", "=", (Object)personId);
            HRBaseServiceHelper hiredPersonHelper = new HRBaseServiceHelper("hlcm_hiredperson");
            HRBaseServiceHelper preWarnHelper = new HRBaseServiceHelper("hlcm_prewarn");
            hiredPersonHelper.deleteByFilter(new QFilter[]{personFilter});
            preWarnHelper.deleteByFilter(new QFilter[]{personFilter});
        }
        catch (Exception exp) {
            LOGGER.error("deletePreWarn error", (Throwable)exp);
        }
    }

    public String calPreWarnStartStatus(DynamicObject contract, PreWarnTypeEnum preWarnType) {
        String protocolType = contract.getString("protocoltype");
        Date startDate = contract.getDate("startdate");
        QFilter personFilter = new QFilter("person", "=", (Object)contract.getLong(String.format(Locale.ROOT, "%s_id", "person")));
        QFilter posTypeFilter = new QFilter("postype", "=", (Object)contract.getLong(String.format(Locale.ROOT, "%s_id", "postype")));
        QFilter startDateFilter = new QFilter("startdate", ">", (Object)startDate);
        HRBaseServiceHelper signBillHelper = new HRBaseServiceHelper("hlcm_contractapplybase");
        if (preWarnType == PreWarnTypeEnum.EXPIRED || preWarnType == PreWarnTypeEnum.SOON_EXPIRE) {
            if (HRStringUtils.equals((String)protocolType, (String)ProtocolTypeEnum.CON.getCombKey())) {
                QFilter protocolTypeFilter = new QFilter("protocoltype", "=", (Object)ProtocolTypeEnum.CON.getCombKey());
                QFilter businessTypeFilter = new QFilter("businesstype", "=", (Object)BusinessTypeEnum.RENEW.getCombKey());
                DynamicObject signBill = signBillHelper.queryOne("handlestatus", new QFilter[]{personFilter, posTypeFilter, startDateFilter, protocolTypeFilter, businessTypeFilter}, "id desc");
                return this.getStartStatusFromSignBill(signBill);
            }
            return this.getYGSignBillStatus(protocolType, personFilter, posTypeFilter, startDateFilter, signBillHelper);
        }
        if (preWarnType == PreWarnTypeEnum.SIGN_COMPANY_CHANGE) {
            if (HRStringUtils.equals((String)protocolType, (String)ProtocolTypeEnum.CON.getCombKey())) {
                QFilter protocolTypeFilter = new QFilter("protocoltype", "=", (Object)ProtocolTypeEnum.CON.getCombKey());
                QFilter businessTypeFilter = new QFilter("businesstype", "=", (Object)BusinessTypeEnum.CHANGE.getCombKey());
                DynamicObject signBill = signBillHelper.queryOne("handlestatus", new QFilter[]{personFilter, posTypeFilter, startDateFilter, protocolTypeFilter, businessTypeFilter}, "id desc");
                return this.getStartStatusFromSignBill(signBill);
            }
            return this.getYGSignBillStatus(protocolType, personFilter, posTypeFilter, startDateFilter, signBillHelper);
        }
        return "0";
    }

    public void syncSignBillHandleStatusToPreWarn(DynamicObject[] signBills) {
        ThreadPools.executeOnce((String)"syncSignBillHandleStatusToPreWarn", () -> Stream.of(signBills).forEach(this::syncSignBillHandleStatusToPreWarn));
    }

    public void syncSignBillHandleStatusToPreWarn(DynamicObject signBill) {
        this.syncSignBillHandleStatusToPreWarn(signBill, false);
    }

    public void deleteSignBillToPreWarn(DynamicObject[] signBills) {
        ThreadPools.executeOnce((String)"deleteSignBillToPreWarn", () -> Stream.of(signBills).forEach(signBill -> this.syncSignBillHandleStatusToPreWarn((DynamicObject)signBill, true)));
    }

    private void syncSignBillHandleStatusToPreWarn(DynamicObject signBill, boolean isDelete) {
        if (isDelete) {
            this.syncBillToPreWarn(signBill, dy -> "0");
        } else {
            this.syncBillToPreWarn(signBill, this::getStartStatusFromSignBill);
        }
    }

    private void syncBillToPreWarn(DynamicObject signBill, Function<DynamicObject, String> startStatusFunction) {
        String protocolType = signBill.getString("protocoltype");
        QFilter protocolTypeFilter = new QFilter("protocoltype", "=", (Object)protocolType);
        QFilter personFilter = new QFilter("person", "=", (Object)signBill.getLong(String.format(Locale.ROOT, "%s_id", "person")));
        long posTypeId = signBill.getLong(String.format(Locale.ROOT, "%s_id", "postype"));
        String contractPosType = String.format(Locale.ROOT, "%s.%s", "contract", "postype");
        QFilter posTypeFilter = new QFilter(contractPosType, "=", (Object)posTypeId);
        HRBaseServiceHelper preWarnHelper = new HRBaseServiceHelper("hlcm_prewarn");
        String businessType = signBill.getString("businesstype");
        String startStatus = startStatusFunction.apply(signBill);
        if (HRStringUtils.equals((String)protocolType, (String)ProtocolTypeEnum.CON.getCombKey()) && HRStringUtils.equals((String)businessType, (String)BusinessTypeEnum.RENEW.getCombKey())) {
            QFilter preWarnTypeFilter = new QFilter("warntype", "in", (Object)new String[]{PreWarnTypeEnum.EXPIRED.getCombKey(), PreWarnTypeEnum.SOON_EXPIRE.getCombKey()});
            QFilter[] filters = new QFilter[]{protocolTypeFilter, personFilter, posTypeFilter, preWarnTypeFilter};
            this.handlePreWarn(preWarnHelper, startStatus, filters);
            return;
        }
        if (HRStringUtils.equals((String)protocolType, (String)ProtocolTypeEnum.CON.getCombKey()) && HRStringUtils.equals((String)businessType, (String)BusinessTypeEnum.CHANGE.getCombKey())) {
            QFilter preWarnTypeFilter = new QFilter("warntype", "=", (Object)PreWarnTypeEnum.SIGN_COMPANY_CHANGE.getCombKey());
            QFilter[] filters = new QFilter[]{protocolTypeFilter, personFilter, posTypeFilter, preWarnTypeFilter};
            this.handlePreWarn(preWarnHelper, startStatus, filters);
            return;
        }
        if (HRStringUtils.equals((String)protocolType, (String)ProtocolTypeEnum.YG.getCombKey()) && HRStringUtils.equals((String)businessType, (String)BusinessTypeEnum.NEW.getCombKey())) {
            QFilter[] filters = new QFilter[]{protocolTypeFilter, personFilter, posTypeFilter};
            this.handlePreWarn(preWarnHelper, startStatus, filters);
        }
    }

    private void handlePreWarn(HRBaseServiceHelper preWarnHelper, String startStatus, QFilter[] filters) {
        if (HRStringUtils.equals((String)startStatus, (String)StartStatusEnum.ARCHIVE.getCombKey())) {
            preWarnHelper.deleteByFilter(filters);
        } else {
            DynamicObject[] preWarns = preWarnHelper.query("startstatus", filters);
            Stream.of(preWarns).forEach(preWarn -> preWarn.set("startstatus", (Object)startStatus));
            preWarnHelper.update(preWarns);
        }
    }

    private String getYGSignBillStatus(String protocolType, QFilter personFilter, QFilter posTypeFilter, QFilter startDateFilter, HRBaseServiceHelper signBillHelper) {
        if (HRStringUtils.equals((String)protocolType, (String)ProtocolTypeEnum.YG.getCombKey())) {
            QFilter protocolTypeFilter = new QFilter("protocoltype", "=", (Object)ProtocolTypeEnum.YG.getCombKey());
            QFilter businessTypeFilter = new QFilter("businesstype", "=", (Object)BusinessTypeEnum.NEW.getCombKey());
            DynamicObject signBill = signBillHelper.queryOne("handlestatus", new QFilter[]{personFilter, posTypeFilter, startDateFilter, protocolTypeFilter, businessTypeFilter}, "id desc");
            return this.getStartStatusFromSignBill(signBill);
        }
        return "0";
    }

    private String getStartStatusFromSignBill(DynamicObject signBill) {
        return Optional.ofNullable(signBill).map(bill -> bill.getString("handlestatus")).orElse("0");
    }

    private static class SingletonHolder {
        private static final SyncStartStatusService INSTANCE = new SyncStartStatusService();

        private SingletonHolder() {
        }
    }
}

