/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.prewarn.abs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.domian.repository.ContractRepository;
import kd.hr.hlcm.business.prewarn.SyncStartStatusService;
import kd.hr.hlcm.business.service.PersonService;
import kd.hr.hlcm.common.enums.PreWarnTypeEnum;

public abstract class PreWarnBaseService {
    private PreWarnTypeEnum preWarnType;
    protected HRBaseServiceHelper contractHelper = new HRBaseServiceHelper("hlcm_contractsource");

    protected abstract DynamicObject[] getPreWarns();

    protected boolean isExclude(DynamicObject contract) {
        long personId = contract.getLong(String.format(Locale.ROOT, "%s_id", "person"));
        long posTypeId = contract.getLong(String.format(Locale.ROOT, "%s_id", "postype"));
        String protocolType = contract.getString("protocoltype");
        if (ContractRepository.getInstance().existWaitEffect(personId, posTypeId, protocolType)) {
            return true;
        }
        String signStatus = contract.getString("signstatus");
        return this.excludeSignStatus().contains(signStatus);
    }

    protected abstract List<String> excludeSignStatus();

    protected QFilter[] getDelFilters() {
        return new QFilter[]{new QFilter("warntype", "=", (Object)this.getPreWarnType().getCombKey())};
    }

    public PreWarnTypeEnum getPreWarnType() {
        return this.preWarnType;
    }

    public PreWarnBaseService(PreWarnTypeEnum preWarnType) {
        this.preWarnType = preWarnType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert() {
        DynamicObject[] preWarns = this.getPreWarns();
        HRBaseServiceHelper preWarnHelper = new HRBaseServiceHelper("hlcm_prewarn");
        if (preWarns.length == 0) {
            preWarnHelper.deleteByFilter(this.getDelFilters());
            return;
        }
        DynamicObject[] onJobPreWarns = this.excludeQuits(preWarns);
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(onJobPreWarns.length);
        for (DynamicObject preWarn : onJobPreWarns) {
            long personId;
            if (this.isExclude(preWarn) || (personId = preWarn.getLong("person.id")) == 0L) continue;
            DynamicObject preWarnDy = preWarnHelper.generateEmptyDynamicObject();
            preWarnDy.set("contract", preWarn.getPkValue());
            preWarnDy.set("warntype", (Object)this.getPreWarnType().getCombKey());
            preWarnDy.set("empnumber", (Object)preWarn.getString("empnumber"));
            preWarnDy.set("personname", (Object)preWarn.getString("name"));
            String protocolType = Optional.ofNullable(preWarn.getString("protocoltype")).filter(HRStringUtils::isNotEmpty).orElse("1");
            preWarnDy.set("protocoltype", (Object)protocolType);
            preWarnDy.set("person", (Object)personId);
            preWarnDy.set("ermanorg", preWarn.get("ermanorg"));
            preWarnDy.set("adminororg", preWarn.get("adminororg"));
            preWarnDy.set("ermanperorg", preWarn.get("ermanperorg"));
            preWarnDy.set("startstatus", (Object)SyncStartStatusService.getInstance().calPreWarnStartStatus(preWarn, this.getPreWarnType()));
            Date now = new Date();
            long currUserId = RequestContext.get().getCurrUserId();
            preWarnDy.set("creator", (Object)currUserId);
            preWarnDy.set("modifier", (Object)currUserId);
            preWarnDy.set("createtime", (Object)now);
            preWarnDy.set("modifytime", (Object)now);
            preWarnDy.set("employee", (Object)preWarn.getLong("employee.id"));
            result.add(preWarnDy);
        }
        if (result.isEmpty()) {
            preWarnHelper.deleteByFilter(this.getDelFilters());
            return;
        }
        try (TXHandle tx = TX.required();){
            preWarnHelper.deleteByFilter(this.getDelFilters());
            preWarnHelper.save(result.toArray(new DynamicObject[0]));
        }
    }

    private DynamicObject[] excludeQuits(DynamicObject[] preWarns) {
        List<Long> employeeIds = Stream.of(preWarns).map(preWarn -> preWarn.getLong("employee.id")).collect(Collectors.toList());
        Long[] onJobPersonIds = PersonService.getInstance().getOnJobEmployeeIds(employeeIds);
        if (Objects.isNull(onJobPersonIds) || onJobPersonIds.length == 0) {
            return new DynamicObject[0];
        }
        return (DynamicObject[])Stream.of(preWarns).filter(preWarn -> Arrays.asList(onJobPersonIds).contains(preWarn.getLong("employee.id"))).toArray(DynamicObject[]::new);
    }
}

