/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.prewarn.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hlcm.business.prewarn.abs.PreWarnBaseService;
import kd.hr.hlcm.common.enums.ContractStatusEnum;
import kd.hr.hlcm.common.enums.PreWarnTypeEnum;
import kd.hr.hlcm.common.enums.ProtocolTypeEnum;

public class PreWarn2Service
extends PreWarnBaseService {
    private int month;

    public PreWarn2Service setMonth(int month) {
        this.month = month;
        return this;
    }

    public PreWarn2Service() {
        super(PreWarnTypeEnum.SOON_EXPIRE);
    }

    @Override
    protected DynamicObject[] getPreWarns() {
        Date nowDay = HRDateTimeUtils.truncateDate((Date)new Date());
        Date date = HRDateTimeUtils.addMonth((Date)nowDay, (int)this.getMonth());
        QFilter statusFilter = new QFilter("contractstatus", "!=", (Object)ContractStatusEnum.STATUS_NO_EFFECT.getCode());
        QFilter versionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter protocolTypeFilter = new QFilter("protocoltype", "not in", (Object)ProtocolTypeEnum.FS.getCombKey());
        QFilter endDateLessFilter = new QFilter("enddate", "<=", (Object)date);
        QFilter endDateLargeFilter = new QFilter("enddate", ">=", (Object)nowDay);
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        DynamicObject[] preWarns = this.contractHelper.loadDynamicObjectArray(new QFilter[]{endDateLessFilter, endDateLargeFilter, versionFilter, statusFilter, protocolTypeFilter, initStatusFilter});
        Map<String, List<DynamicObject>> map = Stream.of(preWarns).collect(Collectors.groupingBy(warn -> String.format(Locale.ROOT, "%s_%d_%d", warn.getString("protocoltype"), warn.getLong(String.format(Locale.ROOT, "%s_id", "person")), warn.getLong(String.format(Locale.ROOT, "%s_id", "postype")))));
        return (DynamicObject[])map.values().stream().map(list -> list.stream().max(Comparator.comparing(dy -> dy.getDate("startdate"))).get()).toArray(DynamicObject[]::new);
    }

    @Override
    protected List<String> excludeSignStatus() {
        ArrayList<String> signStatus = new ArrayList<String>();
        signStatus.add("2");
        signStatus.add("3");
        signStatus.add("4");
        return signStatus;
    }

    @Override
    protected boolean isExclude(DynamicObject contract) {
        if (super.isExclude(contract)) {
            return true;
        }
        Date planEndDate = contract.getDate("planenddate");
        if (Objects.nonNull(planEndDate)) {
            Date now = HRDateTimeUtils.truncateDate((Date)new Date());
            return HRDateTimeUtils.dateDiff((String)"m", (Date)now, (Date)planEndDate) >= (long)this.getMonth();
        }
        return false;
    }

    private int getMonth() {
        return this.month;
    }
}

