/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.setcontractstatus.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hlcm.business.setcontractstatus.abs.SetContractStatusBaseService;
import kd.hr.hlcm.common.enums.ContractStatusEnum;

public class EffectContractService
extends SetContractStatusBaseService {
    private static final Log LOGGER = LogFactory.getLog(EffectContractService.class);

    @Override
    protected DynamicObject[] getToSetContract() {
        QFilter statusFilter = new QFilter("contractstatus", "=", (Object)"0");
        QFilter versionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter endDateFilter = new QFilter("startdate", "<=", (Object)HRDateTimeUtils.truncateDate((Date)new Date()));
        DynamicObject[] toEffectContracts = this.contractHelper.loadDynamicObjectArray(new QFilter[]{statusFilter, versionFilter, endDateFilter});
        LOGGER.info("the contract need to effect|{}", (Object)toEffectContracts.length);
        return toEffectContracts;
    }

    @Override
    protected List<DynamicObject> executeContractStatus(DynamicObject[] contracts) {
        ArrayList<String> invalidContractNos = new ArrayList<String>(contracts.length);
        ArrayList<DynamicObject> hisDyns = new ArrayList<DynamicObject>(contracts.length);
        for (DynamicObject contract : contracts) {
            DynamicObject contractHis = this.contractHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)contract, (DynamicObject)contractHis);
            Date startDate = contract.getDate("startdate");
            String number = contract.getString("number");
            contractHis.set("bsed", (Object)startDate);
            contractHis.set("contractstatus", (Object)ContractStatusEnum.STATUS_IN_EFFECT.getCode());
            invalidContractNos.add(number);
            hisDyns.add(contractHis);
        }
        if (!hisDyns.isEmpty()) {
            LOGGER.info("the contracts has been effect number is {}", (Object)String.join((CharSequence)",", invalidContractNos));
        }
        return hisDyns;
    }
}

