/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.task;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hlcm.business.domian.repository.CommonRepository;
import kd.hr.hlcm.business.task.service.TaskService;
import kd.hr.hlcm.common.enums.SignWayEnum;

public class MoveSignTypeToSignConfigTask
extends AbstractTask {
    private static final String selProp = "econtemplatetype,econtemplate";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        QFilter filter = new QFilter("signway", "like", (Object)("%" + SignWayEnum.ELECTRONIC.getCombKey() + "%")).and("econtemplatetype.id", "!=", (Object)0L).and("econtemplate.id", "=", (Object)0L);
        DynamicObject[] templates = CommonRepository.query("hlcm_contracttemplate", selProp, new QFilter[]{filter});
        DynamicObject[] hisTemlates = CommonRepository.query("hlcm_contracttemplatehis", selProp, new QFilter[]{filter});
        boolean isSuccess = true;
        try (TXHandle txHandle = TX.required();){
            this.moveSignTypeToSignConfig(templates, "hlcm_contracttemplate");
            this.moveSignTypeToSignConfig(hisTemlates, "hlcm_contracttemplatehis");
        }
        if (isSuccess) {
            TaskService.disableTask("sch_schedule", "3HD5AC739+LC");
        }
    }

    private void moveSignTypeToSignConfig(DynamicObject[] templates, String entityNum) {
        if (templates != null && templates.length > 0) {
            for (DynamicObject template : templates) {
                long eTemConfigId;
                DynamicObject eTemType = template.getDynamicObject("econtemplatetype");
                if (eTemType == null || (eTemConfigId = eTemType.getLong("template.id")) == 0L) continue;
                template.set("econtemplate", (Object)eTemConfigId);
            }
            CommonRepository.updateDynamicObject(entityNum, templates);
        }
    }
}

