/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.task;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.common.HLCMCommonRepository;
import kd.hr.hlcm.business.domian.repository.CommonRepository;
import kd.hr.hlcm.business.domian.repository.ContractRepository;
import kd.hr.hlcm.business.domian.service.hspm.IHSPMFileService;
import kd.hr.hlcm.business.domian.service.signmgt.ISignManageService;
import kd.hr.hlcm.common.enums.HandleStatusEnum;
import kd.hr.hlcm.common.enums.ProcessStatusEnum;
import kd.hr.hlcm.common.enums.SignTabEnum;
import kd.hr.hlcm.common.enums.SignWayEnum;

public class RepairBeginSignedContractDataTask
extends AbstractTask {
    private static final String ERMAN_FILE_ID = "ermanfile_id";
    private static final Log LOGGER = LogFactory.getLog(RepairBeginSignedContractDataTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        boolean syncOrgResult = this.syncOrg();
        LOGGER.info("syncOrgResult result:{}", (Object)syncOrgResult);
        boolean repairBeginSignedContractResult = this.repairBeginSignedContract();
        LOGGER.info("repairBeginSignedContractResult result:{}", (Object)repairBeginSignedContractResult);
        if (syncOrgResult && repairBeginSignedContractResult) {
            HRBaseServiceHelper schServiceHelper = new HRBaseServiceHelper("sch_schedule");
            DynamicObject schDy = schServiceHelper.queryOne("status", (Object)"2U0YWB5F0EE2");
            schDy.set("status", (Object)"0");
            schServiceHelper.updateOne(schDy);
        }
    }

    private boolean syncOrg() {
        try {
            Object[] hiredPersons = HLCMCommonRepository.queryDynamicObjects("hlcm_hiredperson", "ermanorg,adminororg,ermanperorg,ermanfile", new QFilter("ermanorg", "=", (Object)0L));
            ArrayList querySet = Lists.newArrayList((Object[])hiredPersons);
            List partition = Lists.partition((List)querySet, (int)1000);
            for (List dys : partition) {
                List<Long> erManFileIds = dys.stream().map(dy -> dy.getLong(ERMAN_FILE_ID)).filter(er -> !HRObjectUtils.isEmpty((Object)er)).collect(Collectors.toList());
                List<Map<String, Object>> erManFileInfos = IHSPMFileService.getInstance().getAllCardFieldByErManFileIds(erManFileIds);
                HashMap erManFileMap = new HashMap();
                erManFileInfos.forEach(info -> {
                    Long erManFileId = HRJSONUtils.getLongValOfCustomParam(info.get("id"));
                    erManFileMap.put(erManFileId, info);
                });
                dys.forEach(dy -> {
                    long erManFileId = dy.getLong(ERMAN_FILE_ID);
                    Map erManFileInfo = (Map)erManFileMap.get(erManFileId);
                    dy.set("ermanorg", (Object)HRJSONUtils.getLongValOfCustomParam(erManFileInfo.get("org_id")));
                    dy.set("adminororg", (Object)HRJSONUtils.getLongValOfCustomParam(erManFileInfo.get("affiliateadminorg_id")));
                    dy.set("ermanperorg", (Object)HRJSONUtils.getLongValOfCustomParam(erManFileInfo.get("empgroup_id")));
                });
                HLCMCommonRepository.updateDynamicObjects("hlcm_hiredperson", dys.toArray(new DynamicObject[dys.size()]));
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean repairBeginSignedContract() {
        LOGGER.info("RepairBeginSignedContractDataTask Begin");
        try {
            DynamicObject[] archiveSignBills;
            HashSet signBillIds = new HashSet(8);
            DynamicObject[] activities = CommonRepository.query("hlcm_activity", "signapply.id", new QFilter[]{new QFilter("activity.id", "=", (Object)SignTabEnum.P_BEGIN.getActivityId()), new QFilter("processstatus", "=", (Object)ProcessStatusEnum.PROCESSED.getValue())});
            if (activities.length != 0) {
                signBillIds.addAll(Arrays.stream(activities).map(activity -> activity.getLong("signapply.id")).collect(Collectors.toList()));
            }
            if ((archiveSignBills = CommonRepository.query("hlcm_contractapplybase", "contractnumber", new QFilter[]{new QFilter("handlestatus", "=", (Object)HandleStatusEnum.ARCHIVE.getCombKey()), new QFilter("signway", "=", (Object)SignWayEnum.PAPER.getCombKey())})).length != 0) {
                signBillIds.addAll(Arrays.stream(archiveSignBills).map(signBill -> signBill.getLong("id")).collect(Collectors.toList()));
            }
            if (signBillIds.size() == 0) {
                return true;
            }
            DynamicObject[] signBills = CommonRepository.queryByIds("hlcm_contractapplybase", null, new ArrayList<Long>(signBillIds));
            List signBillPartitions = Lists.partition(Arrays.asList(signBills), (int)1000);
            for (List signBillPartition : signBillPartitions) {
                HashSet modifiedSignBills = new HashSet(signBillPartition.size());
                signBillPartition.forEach(signBill -> signBill.getDynamicObjectCollection("entryentity").forEach(entryEntity -> {
                    try {
                        if (!HRStringUtils.isEmpty((String)entryEntity.getString("presigndocurl"))) {
                            return;
                        }
                        String signDocUrl = ISignManageService.getInstance().replaceKeywordGenContract((DynamicObject)signBill, (DynamicObject)entryEntity, true, false);
                        if (!HRStringUtils.isEmpty((String)signDocUrl)) {
                            entryEntity.set("presigndocurl", (Object)signDocUrl);
                            modifiedSignBills.add(signBill);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage(), (Throwable)e);
                    }
                }));
                if (modifiedSignBills.size() == 0) continue;
                CommonRepository.updateDynamicObject("hlcm_contractapplybase", modifiedSignBills.toArray(new DynamicObject[0]));
            }
            if (archiveSignBills.length != 0) {
                List archiveSignBillPartitions = Lists.partition(Arrays.asList(signBills), (int)1000);
                for (List archiveSignBillPartition : archiveSignBillPartitions) {
                    Map<String, DynamicObject> archiveSignBillMap = archiveSignBillPartition.stream().collect(Collectors.toMap(signBill -> signBill.getString("contractnumber"), signBill -> signBill, (v1, v2) -> v1));
                    DynamicObject[] contractFiles = ContractRepository.getInstance().loadBySignBills(archiveSignBillPartition.toArray(new DynamicObject[0]), null);
                    Map<String, DynamicObject> contractFileMap = Arrays.stream(contractFiles).collect(Collectors.toMap(contractFile -> contractFile.getString("number"), contractFile -> contractFile, (v1, v2) -> v1));
                    HashSet modifiedContractFiles = new HashSet(contractFiles.length);
                    contractFileMap.forEach((contractNumber, contractFile) -> {
                        DynamicObject signBill = (DynamicObject)archiveSignBillMap.get(contractNumber);
                        DynamicObjectCollection signBillEntryEntity = signBill.getDynamicObjectCollection("entryentity");
                        Map<Long, String> signDocUrlMap = signBillEntryEntity.stream().collect(Collectors.toMap(entryEntity -> entryEntity.getDynamicObject("texthis").getLong("id"), entryEntity -> entryEntity.getString("presigndocurl"), (v1, v2) -> v1));
                        DynamicObjectCollection contractFileEntryEntity = contractFile.getDynamicObjectCollection("entryentity");
                        contractFileEntryEntity.forEach(entryEntity -> {
                            String signDocUrl = (String)signDocUrlMap.get(entryEntity.getDynamicObject("texthis").getLong("id"));
                            if (HRStringUtils.isEmpty((String)entryEntity.getString("presigndocurl")) && !HRStringUtils.isEmpty((String)signDocUrl)) {
                                entryEntity.set("presigndocurl", (Object)signDocUrl);
                                modifiedContractFiles.add(contractFile);
                            }
                        });
                    });
                    if (modifiedContractFiles.size() == 0) continue;
                    CommonRepository.updateDynamicObject("hlcm_contract", modifiedContractFiles.toArray(new DynamicObject[0]));
                }
            }
            LOGGER.info("RepairBeginSignedContractDataTask End");
            return true;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

