/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.task;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.common.HLCMCommonRepository;
import kd.hr.hlcm.business.domian.service.hspm.IHSPMFileService;
import org.apache.commons.collections.CollectionUtils;

public class RepairErmanAndEmployeeService {
    private static final Log LOGGER = LogFactory.getLog(RepairErmanAndEmployeeService.class);
    private static final int BATCH = 1000;

    public void executeRepair() throws KDException {
        this.repairSignBillData();
        this.repairContractFile();
        this.repairEmployeeForHiredPerson();
        this.repairHisContractEmployee();
    }

    private void repairHisContractEmployee() {
        boolean isLast = false;
        HRBaseServiceHelper contractServiceHelper = new HRBaseServiceHelper("hlcm_contractsource");
        long start = 0L;
        while (!isLast) {
            QFilter idFilter = new QFilter("id", ">", (Object)start);
            QFilter employeeFilter = new QFilter("employee", "=", (Object)0L);
            QFilter erManFileFilter = new QFilter("ermanfile", "!=", (Object)0L);
            DynamicObject[] queryResult = contractServiceHelper.query("ermanfile.id,employee.id", new QFilter[]{employeeFilter, erManFileFilter, idFilter}, "id", 1000);
            if (queryResult.length == 0) {
                return;
            }
            if (queryResult.length < 1000) {
                isLast = true;
            }
            start = queryResult[queryResult.length - 1].getLong("id");
            this.setEmployeeByErman(queryResult);
            contractServiceHelper.save(queryResult);
        }
    }

    private QFilter hisModelQFilter() {
        return new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1')).and("datastatus", "=", (Object)"1").and("empposrel.isprimary", "=", (Object)"1");
    }

    private void repairEmployeeForHiredPerson() {
        HRBaseServiceHelper hiredServiceHelper = new HRBaseServiceHelper("hlcm_hiredperson");
        boolean isLast = false;
        long start = 0L;
        while (!isLast) {
            QFilter idFilter = new QFilter("id", ">", (Object)start);
            DynamicObject[] queryResult = hiredServiceHelper.query("employee,id, empnumber,empentrel.id, empposrel.id,ermanorg.id, adminororg.id, ermanperorg.id, ermanfile, person.id", new QFilter[]{idFilter}, "id", 1000);
            if (queryResult.length == 0) {
                return;
            }
            if (queryResult.length < 1000) {
                isLast = true;
            }
            start = queryResult[queryResult.length - 1].getLong("id");
            this.setEmployeeByErman(queryResult);
            this.setNewestErmanfile(queryResult);
            this.repairRelatedFields(queryResult, "3");
            hiredServiceHelper.save(queryResult);
        }
    }

    private void repairSignBillData() {
        boolean isLast = false;
        HRBaseServiceHelper applyServiceHelper = new HRBaseServiceHelper("hlcm_contractapplybase");
        HRBaseServiceHelper activityServiceHelper = new HRBaseServiceHelper("hlcm_activity");
        long start = 0L;
        while (!isLast) {
            QFilter idFilter = new QFilter("id", ">", (Object)start);
            DynamicObject[] queryResult = applyServiceHelper.query("employee,ermanfile,modifytime,person.id,postype.id,curcompany.id,curdept.id,curpostion.id,curstdpostion.id,curjob.id,org.id,ermanorg.id,adminororg.id,ermanperorg.id,terminatedate,actualsigndate,createtime", new QFilter[]{idFilter}, "id", 1000);
            if (queryResult.length == 0) {
                return;
            }
            if (queryResult.length < 1000) {
                isLast = true;
            }
            start = queryResult[queryResult.length - 1].getLong("id");
            List applyIds = Arrays.stream(queryResult).map(dy -> dy.getLong("id")).collect(Collectors.toList());
            QFilter acitivityFilter = new QFilter("activity", "in", Arrays.asList(1374063287922229248L, 1373940938556191744L));
            QFilter applyFilter = new QFilter("signapply", "in", applyIds);
            QFilter handleTimeFilter = QFilter.isNotNull((String)"activityins.handletime");
            DynamicObject[] activityDys = activityServiceHelper.query("activityins.handletime,signapply.id", new QFilter[]{acitivityFilter, applyFilter, handleTimeFilter});
            Map<Long, Date> billDateMap = Arrays.stream(activityDys).collect(Collectors.toMap(dy -> dy.getLong("signapply.id"), dy -> dy.getDate("activityins.handletime"), (k1, k2) -> k2));
            this.seekErManFile(queryResult, dy -> {
                long billId = dy.getLong("id");
                Date date = (Date)billDateMap.get(billId);
                Date signDate = dy.getDate("actualsigndate");
                Date terminateDate = dy.getDate("terminatedate");
                Date createDate = dy.getDate("createtime");
                if (Objects.nonNull(date)) {
                    return date;
                }
                if (Objects.nonNull(signDate)) {
                    return signDate;
                }
                if (Objects.nonNull(terminateDate)) {
                    return terminateDate;
                }
                return createDate;
            });
            this.setEmployeeByErman(queryResult);
            this.repairRelatedFields(queryResult, "1");
            applyServiceHelper.save(queryResult);
        }
    }

    private void seekErManFile(DynamicObject[] queryResult, Function<DynamicObject, Date> dateFunction) {
        HashMap dateMap = Maps.newHashMapWithExpectedSize((int)queryResult.length);
        HashSet personIdSet = Sets.newHashSetWithExpectedSize((int)queryResult.length);
        for (DynamicObject dy : queryResult) {
            long billId = dy.getLong("id");
            Date dateDesc = HRDateTimeUtils.truncateDate((Date)dateFunction.apply(dy));
            dateMap.put(billId, dateDesc);
            personIdSet.add(dy.getLong("person.id"));
        }
        QFilter mergeFilter = this.hisModelQFilter().and("person", "in", (Object)personIdSet);
        DynamicObject[] erManFiles = HLCMCommonRepository.queryDynamicObjects("hspm_ermanfile", "id,person.id,startdate,enddate", mergeFilter);
        Map<Long, List<DynamicObject>> personGroupMap = Stream.of(erManFiles).collect(Collectors.groupingBy(e -> e.getLong("person.id")));
        for (DynamicObject dy : queryResult) {
            long billId = dy.getLong("id");
            long personId = dy.getLong("person.id");
            Date date = (Date)dateMap.get(billId);
            List<DynamicObject> erManFileList = personGroupMap.get(personId);
            if (CollectionUtils.isEmpty(erManFileList) || date == null) continue;
            for (DynamicObject erManFile : erManFileList) {
                Date startDate = erManFile.getDate("startdate");
                Date endDate = erManFile.getDate("enddate");
                if (startDate == null || endDate == null || !startDate.before(date) || !endDate.after(date)) continue;
                dy.set("ermanfile_id", (Object)erManFile.getLong("id"));
            }
        }
    }

    private void repairContractFile() {
        boolean isLast = false;
        HRBaseServiceHelper contractServiceHelper = new HRBaseServiceHelper("hlcm_contractsource");
        long start = 0L;
        while (!isLast) {
            QFilter idFilter = new QFilter("id", ">", (Object)start);
            QFilter versionFilter = new QFilter("datastatus", "=", (Object)"1");
            DynamicObject[] queryPKResult = contractServiceHelper.query("id", new QFilter[]{idFilter, versionFilter}, "id", 1000);
            if (queryPKResult.length == 0) {
                return;
            }
            if (queryPKResult.length < 1000) {
                isLast = true;
            }
            start = queryPKResult[queryPKResult.length - 1].getLong("id");
            List idList = Stream.of(queryPKResult).map(dy -> dy.getLong("id")).collect(Collectors.toList());
            QFilter idListFilter = new QFilter("id", "in", idList);
            DynamicObject[] queryResult = contractServiceHelper.query("curcompany.id,curdept.id,curpostion.id,curstdpostion.id,curjob.id,org.id,ermanorg.id,adminororg.id,ermanperorg.id,initbatch,createtime,startdate,person.id,ermanfile,employee", new QFilter[]{idListFilter, versionFilter});
            this.seekErManFile(queryResult, dy -> {
                long initBatch = dy.getLong("initbatch");
                if (initBatch == 0L) {
                    return dy.getDate("createtime");
                }
                return dy.getDate("startdate");
            });
            this.setEmployeeByErman(queryResult);
            this.setNewestErmanfile(queryResult);
            this.repairRelatedFields(queryResult, "2");
            contractServiceHelper.save(queryResult);
        }
    }

    private void repairRelatedFields(DynamicObject[] dys, String type) {
        List<Long> erManFileIds = Stream.of(dys).map(dy -> dy.getLong("ermanfile_id")).collect(Collectors.toList());
        Map<Long, Map<String, Object>> erManFileInfoMap = this.queryRelFields(erManFileIds);
        for (DynamicObject dy2 : dys) {
            long erManFileId = dy2.getLong("ermanfile_id");
            Map<String, Object> erManFileInfo = erManFileInfoMap.get(erManFileId);
            if (erManFileInfo == null) continue;
            if (HRStringUtils.equals((String)type, (String)"1")) {
                dy2.set("org", erManFileInfo.get("org_id"));
            }
            dy2.set("ermanorg", erManFileInfo.get("org_id"));
            dy2.set("adminororg", erManFileInfo.get("affiliateadminorg_id"));
            dy2.set("ermanperorg", erManFileInfo.get("empgroup_id"));
            if (HRStringUtils.equals((String)type, (String)"1") || HRStringUtils.equals((String)type, (String)"2")) {
                dy2.set("curcompany", erManFileInfo.get("company_id"));
                dy2.set("curdept", erManFileInfo.get("adminorg_id"));
                dy2.set("curpostion", erManFileInfo.get("position_id"));
                dy2.set("curstdpostion", erManFileInfo.get("stdposition_id"));
                dy2.set("curjob", erManFileInfo.get("job_id"));
            }
            if (!HRStringUtils.equals((String)type, (String)"3")) continue;
            dy2.set("empposrel", erManFileInfo.get("empposrel_id"));
            dy2.set("empentrel", erManFileInfo.get("empentrel_id"));
        }
        LOGGER.info("RepairErmanAndEmployeeService.repairRelatedFields.success..");
    }

    private void setNewestErmanfile(DynamicObject[] queryResult) {
        List<Long> empIds = Arrays.stream(queryResult).map(dy -> dy.getLong("employee_id")).collect(Collectors.toList());
        Map<Long, Long> newErManFileMap = IHSPMFileService.getInstance().getNewestErmanByEmployee(empIds, Boolean.FALSE);
        for (DynamicObject dy2 : queryResult) {
            Long employeeId = dy2.getLong("employee_id");
            Long newestErManFileId = newErManFileMap.get(employeeId);
            if (newestErManFileId == null || newestErManFileId == 0L) continue;
            dy2.set("ermanfile_id", (Object)newestErManFileId);
        }
    }

    private void setEmployeeByErman(DynamicObject[] queryResult) {
        LOGGER.info("RepairErmanAndEmployeeService.setEmployeeByErman.queryResult.count={}", (Object)queryResult.length);
        List ermanId = Arrays.stream(queryResult).map(dynamicObject -> dynamicObject.getLong("ermanfile_id")).collect(Collectors.toList());
        HRBaseServiceHelper ermanServiceHelper = new HRBaseServiceHelper("hspm_ermanfile");
        QFilter ermanIdFilter = new QFilter("id", "in", ermanId);
        DynamicObject[] employeeDys = ermanServiceHelper.query("id,employee.id", new QFilter[]{ermanIdFilter});
        Map<Long, Long> employeeMap = Arrays.stream(employeeDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("employee.id"), (k1, k2) -> k1));
        for (DynamicObject dy2 : queryResult) {
            long erManFileId = dy2.getLong("ermanfile_id");
            Long employeeId = employeeMap.get(erManFileId);
            if (employeeId == null || employeeId == 0L) continue;
            dy2.set("employee_id", (Object)employeeId);
        }
    }

    private boolean isOneToNOpen() {
        String flag = (String)HRMServiceHelper.invokeHRService((String)"hpfs", (String)"IHPFSDevParamConfigService", (String)"queryBusinessValueByBusinessKey", (Object[])new Object[]{"person_model_switch"});
        if (!Lists.newArrayList((Object[])new String[]{"true", "false"}).contains(flag)) {
            return false;
        }
        return Boolean.parseBoolean(flag);
    }

    private Map<Long, Map<String, Object>> queryRelFields(List<Long> erManFileIds) {
        Set erManFileIdSet = erManFileIds.stream().filter(Objects::nonNull).filter(erManFileId -> erManFileId != 0L).collect(Collectors.toSet());
        HRBaseServiceHelper erManFileServiceHelper = new HRBaseServiceHelper("hspm_ermanfile");
        QFilter idFilter = new QFilter("id", "in", erManFileIdSet);
        DynamicObject[] queryResult = erManFileServiceHelper.query("empposrel.id,empentrel.id,org.id,empgroup.id,affiliateadminorg.id,empposrel.company.id,empposrel.adminorg.id,empposrel.position.id,empposrel.stdposition.id,empposrel.job.id", new QFilter[]{idFilter});
        HashMap result = Maps.newHashMapWithExpectedSize((int)queryResult.length);
        for (DynamicObject dy : queryResult) {
            HashMap<String, Long> erManFileInfo = new HashMap<String, Long>();
            erManFileInfo.put("org_id", dy.getLong("org.id"));
            erManFileInfo.put("affiliateadminorg_id", dy.getLong("affiliateadminorg.id"));
            erManFileInfo.put("empgroup_id", dy.getLong("empgroup.id"));
            erManFileInfo.put("company_id", dy.getLong("empposrel.company.id"));
            erManFileInfo.put("adminorg_id", dy.getLong("empposrel.adminorg.id"));
            erManFileInfo.put("position_id", dy.getLong("empposrel.position.id"));
            erManFileInfo.put("stdposition_id", dy.getLong("empposrel.stdposition.id"));
            erManFileInfo.put("empposrel_id", dy.getLong("empposrel.id"));
            erManFileInfo.put("empentrel_id", dy.getLong("empentrel.id"));
            long id = dy.getLong("id");
            erManFileInfo.put("id", id);
            result.put(id, erManFileInfo);
        }
        return result;
    }
}

