/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.task;

import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.utils.AttachmentUtils;
import kd.hr.hlcm.common.enums.SignStatusEnum;

public class RepairSignAttachment
extends AbstractTask {
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        DynamicObject[] queryResult;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hlcm_contractapplybase");
        HRBaseServiceHelper attachmentHelper = new HRBaseServiceHelper("bos_attachment");
        QFilter filter = new QFilter("entryentity.presigndocurl", "!=", (Object)" ");
        for (DynamicObject signBill : queryResult = serviceHelper.query("signstatus,entryentity.presigndocurl,entryentity,signdate", new QFilter[]{filter})) {
            int beginIndex;
            DynamicObject entryEntity = (DynamicObject)signBill.getDynamicObjectCollection("entryentity").get(0);
            String signDocUrl = entryEntity.getString("presigndocurl");
            Date signDate = entryEntity.getDate("signdate");
            String signStatus = signBill.getString("signstatus");
            if (HRStringUtils.isEmpty((String)signDocUrl)) continue;
            String pkId = signBill.getPkValue().toString();
            QFilter[] filters = new QFilter[]{new QFilter("ffileid", "=", (Object)signDocUrl), new QFilter("finterid", "=", (Object)pkId)};
            boolean exists = attachmentHelper.isExists(filters);
            if (exists || (beginIndex = signDocUrl.lastIndexOf("/")) == -1) continue;
            String fileName = signDocUrl.substring(beginIndex + 1);
            if (HRStringUtils.equals((String)signStatus, (String)SignStatusEnum.P_SIGNED.getCombKey())) {
                AttachmentUtils.writeAttachment("empsignnotify", "hlcm_signattachment", pkId, signDocUrl, fileName, signDate);
                continue;
            }
            AttachmentUtils.writeAttachment("companysignnotify", "hlcm_signattachment", pkId, signDocUrl, fileName, signDate);
        }
        HRBaseServiceHelper schServiceHelper = new HRBaseServiceHelper("sch_schedule");
        DynamicObject schDy = schServiceHelper.queryOne("status", (Object)"3EQ+WG/YOGMB");
        schDy.set("status", (Object)"0");
        schServiceHelper.updateOne(schDy);
    }
}

