/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.task.workbench;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.prewarn.PreWarnTaskExecutor;
import kd.hr.hlcm.business.prewarn.SyncStartStatusService;
import kd.hr.hlcm.business.prewarn.impl.PreWarn1Service;
import kd.hr.hlcm.business.prewarn.impl.PreWarn2Service;
import kd.hr.hlcm.business.prewarn.impl.PreWarn3Service;
import org.apache.commons.lang3.StringUtils;

public class ContractWarningTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(ContractWarningTask.class);
    private static final String SOON_MONTH = "SOON_MONTH";
    private static final int DEFAULT_MONTH = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        TXHandle txHandle = TX.required();
        String monthsStr = (String)map.get(SOON_MONTH);
        logger.info("param SOON_MONTH|{}", (Object)monthsStr);
        int months = HRStringUtils.isNotEmpty((String)monthsStr) && StringUtils.isNumeric((CharSequence)monthsStr) ? Integer.parseInt(monthsStr) : 3;
        try {
            new PreWarnTaskExecutor().addTask(new PreWarn1Service()).addTask(new PreWarn2Service().setMonth(months)).addTask(new PreWarn3Service()).executeTask();
            SyncStartStatusService.getInstance().syncHirePersonStartStatus();
        }
        catch (Exception exp) {
            logger.error((Throwable)exp);
            txHandle.markRollback();
        }
        finally {
            txHandle.close();
        }
    }
}

