/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kd.bos.base.utils.msg.MultiLangEnumBridge;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.common.enums.ActivityStatusEnum;
import kd.hr.hlcm.common.enums.ActivityTaskStatusEnum;
import kd.hr.hlcm.common.enums.BusinessStatusEnum;
import kd.hr.hlcm.common.enums.SignTabEnum;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class ActivityUtils {
    private static final Map<Long, BusinessStatusEnum> BUSINESS_STATUS_MAP = new HashMap<Long, BusinessStatusEnum>();

    private ActivityUtils() {
    }

    @Deprecated
    public static BusinessStatusEnum getBusinessStatus(String bizKey) {
        return BUSINESS_STATUS_MAP.get(SignTabEnum.getSignEnum((String)bizKey).getActivityId());
    }

    public static BusinessStatusEnum getBusinessStatus(Long activityId) {
        return BUSINESS_STATUS_MAP.get(activityId);
    }

    public static ImmutablePair<String, String> getActivityStatus(DynamicObject activity) {
        String taskStatus = activity.getString("activityins.taskstatus");
        ActivityStatusEnum activityStatusEnum = null;
        String color = "#333";
        if (HRStringUtils.isEmpty((String)taskStatus)) {
            color = "#333";
        } else if (HRStringUtils.equals((String)taskStatus, (String)ActivityTaskStatusEnum.TERMINATED.getCombKey())) {
            activityStatusEnum = ActivityStatusEnum.TERMINATED;
            color = "#666666";
        } else {
            color = HRStringUtils.equals((String)taskStatus, (String)ActivityTaskStatusEnum.COMPLETED.getCombKey()) ? "#1BA854" : "#FF991C";
            activityStatusEnum = ActivityStatusEnum.getActivityStatusEnum(null, (Long)activity.getLong("activityins.activity.id"), (String)taskStatus);
        }
        String activityStatus = Optional.ofNullable(activityStatusEnum).map(ActivityStatusEnum::getBridge).map(MultiLangEnumBridge::loadKDString).orElse("-");
        return ImmutablePair.of((Object)activityStatus, (Object)color);
    }

    static {
        BUSINESS_STATUS_MAP.put(SignTabEnum.E_BEGIN.getActivityId(), BusinessStatusEnum.BEGIN);
        BUSINESS_STATUS_MAP.put(SignTabEnum.E_CONFIRM.getActivityId(), BusinessStatusEnum.CONFIRM);
        BUSINESS_STATUS_MAP.put(SignTabEnum.E_ESIGN.getActivityId(), BusinessStatusEnum.PSIGN);
        BUSINESS_STATUS_MAP.put(SignTabEnum.E_CSIGN.getActivityId(), BusinessStatusEnum.CSIGN);
        BUSINESS_STATUS_MAP.put(SignTabEnum.E_CHECK.getActivityId(), BusinessStatusEnum.CHECK);
        BUSINESS_STATUS_MAP.put(SignTabEnum.P_BEGIN.getActivityId(), BusinessStatusEnum.BEGIN);
        BUSINESS_STATUS_MAP.put(SignTabEnum.P_CHECK.getActivityId(), BusinessStatusEnum.CHECK);
        BUSINESS_STATUS_MAP.put(SignTabEnum.P_COMP.getActivityId(), BusinessStatusEnum.COMP);
    }
}

