/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.utils;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hlcm.business.domian.repository.BosAttachmentRepository;
import kd.hr.hlcm.business.domian.repository.ContractRepository;
import kd.hr.hlcm.common.enums.BusinessTypeEnum;
import kd.hr.hlcm.common.enums.ContractTypeCatEnum;
import kd.hr.hlcm.common.enums.ProtocolTypeEnum;
import kd.hr.hlcm.common.enums.SignTabEnum;
import kd.hr.hlcm.common.enums.SignWayEnum;
import org.apache.commons.lang3.RandomUtils;

public class AttachmentUtils {
    private static final String FATTACHMENTPANEL = "fattachmentpanel";
    private static final String FINTERID = "finterid";
    private static final String FBILLTYPE = "fbilltype";
    private static final String ATTACHMENT_KEY = "attachmentpanel";
    private static final String BOS_ATTACHMENT = "bos_attachment";

    public static void bindAttachment(IFormView formView) {
        String formId = formView.getFormShowParameter().getFormId();
        if (SignTabEnum.P_ARCHIVE.getSourceListFormId().equals(formId) || SignTabEnum.P_CHECK.getSourceListFormId().equals(formId) || SignTabEnum.P_STOP.getSourceListFormId().equals(formId)) {
            AttachmentPanel attachmentPanel = (AttachmentPanel)formView.getControl("paperattachment");
            attachmentPanel.setEntityId("hlcm_papersign_comp");
        }
        AttachmentUtils.bindAttachment(formView, ATTACHMENT_KEY);
    }

    public static void bindAttachment(AttachmentPanel attachmentPanel, String formId, String pkId) {
        List attachmentList = AttachmentServiceHelper.getAttachments((String)formId, (Object)pkId, (String)"companysignnotify");
        if (CollectionUtils.isEmpty((Collection)attachmentList)) {
            attachmentList = AttachmentServiceHelper.getAttachments((String)formId, (Object)pkId, (String)"empsignnotify");
        }
        if (!CollectionUtils.isEmpty((Collection)attachmentList)) {
            attachmentList.forEach(attachment -> attachment.put("visible", "11"));
            attachmentPanel.bindData(attachmentList);
        }
    }

    public static void bindAttachment(IFormView formView, String attachmentKey) {
        DynamicObject dataEntity = formView.getModel().getDataEntity();
        AttachmentPanel attachmentPanel = (AttachmentPanel)formView.getControl(attachmentKey);
        attachmentPanel.setEntityId(AttachmentUtils.getSignBillEntityId(dataEntity));
    }

    private static String getSignBillEntityId(DynamicObject signBill) {
        String businessType = signBill.getString("businesstype");
        String protocolType = signBill.getString("protocoltype");
        String entityId = "";
        block5 : switch (protocolType) {
            case "2": {
                switch (businessType) {
                    case "4": {
                        entityId = "hlcm_empprotocolrelieve";
                        break block5;
                    }
                    case "5": {
                        entityId = "hlcm_empprotocolterminate";
                        break block5;
                    }
                    case "1": {
                        entityId = "hlcm_empprotocolnew";
                        break block5;
                    }
                }
                break;
            }
            case "3": {
                entityId = "hlcm_otheragreements";
                break;
            }
            case "1": {
                switch (businessType) {
                    case "2": {
                        entityId = "hlcm_contractapplyrenew";
                        break block5;
                    }
                    case "3": {
                        entityId = "hlcm_contractapplychange";
                        break block5;
                    }
                    case "4": {
                        entityId = "hlcm_contractapplycancel";
                        break block5;
                    }
                    case "5": {
                        entityId = "hlcm_contractapplyend";
                        break block5;
                    }
                    case "1": {
                        entityId = "hlcm_contractapplynew";
                        break block5;
                    }
                }
                break;
            }
        }
        return entityId;
    }

    private static String getContractEntityId(DynamicObject contract) {
        String protocolType = contract.getString("protocoltype");
        if (ProtocolTypeEnum.YG.getCombKey().equals(protocolType)) {
            return "hlcm_contractfileemp";
        }
        if (ProtocolTypeEnum.FS.getCombKey().equals(protocolType)) {
            return "hlcm_contractfileother";
        }
        return "hlcm_contract";
    }

    public static void copyAttachment(String srcAttachmentPanel, String srcBillType, String srcPKId, String destAttachmentPanel, String destBillType, String destPKId) {
        try (TXHandle txHandle = TX.notSupported();){
            DynamicObject[] srcDyn;
            HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(BOS_ATTACHMENT);
            QFilter filter = new QFilter(FATTACHMENTPANEL, "=", (Object)srcAttachmentPanel).and(new QFilter(FINTERID, "=", (Object)String.valueOf(srcPKId)));
            if (null != srcBillType) {
                filter = filter.and(new QFilter(FBILLTYPE, "=", (Object)srcBillType));
            }
            if (null == (srcDyn = hrBaseServiceHelper.loadDynamicObjectArray(new QFilter[]{filter})) || srcDyn.length == 0) {
                return;
            }
            DynamicObject[] destDyn = new DynamicObject[srcDyn.length];
            for (int i = 0; i < srcDyn.length; ++i) {
                destDyn[i] = hrBaseServiceHelper.generateEmptyDynamicObject();
                HRDynamicObjectUtils.copy((DynamicObject)srcDyn[i], (DynamicObject)destDyn[i]);
                destDyn[i].set(FINTERID, (Object)destPKId);
                destDyn[i].set(FATTACHMENTPANEL, (Object)destAttachmentPanel);
                destDyn[i].set(FBILLTYPE, (Object)destBillType);
                String number = srcDyn[i].getString("FNUMBER");
                String attUid = BosAttachmentRepository.getInstance().getAttUid(number);
                destDyn[i].set("FNUMBER", (Object)attUid);
            }
            hrBaseServiceHelper.save(destDyn);
        }
    }

    public static void writeAttachment(String attachmentKey, String formId, String pkId, String url, String fileName, Date signDate) {
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(BOS_ATTACHMENT);
        DynamicObject attachment = hrBaseServiceHelper.generateEmptyDynamicObject();
        long fileSize = fileService.getFileSize(url);
        String[] split = fileName.split("\\.");
        attachment.set(FINTERID, (Object)pkId);
        attachment.set("ffileid", (Object)url);
        attachment.set(FATTACHMENTPANEL, (Object)attachmentKey);
        attachment.set(FBILLTYPE, (Object)formId);
        attachment.set("fmodifytime", (Object)Optional.ofNullable(signDate).orElseGet(Date::new));
        attachment.set("fcreatetime", (Object)Optional.ofNullable(signDate).orElseGet(Date::new));
        attachment.set("fmodifymen", (Object)RequestContext.get().getCurrUserId());
        attachment.set("fcreatemen", (Object)RequestContext.get().getCurrUserId());
        attachment.set("fattachmentsize", (Object)fileSize);
        attachment.set("fattachmentname", (Object)split[0]);
        attachment.set("faliasfilename", (Object)split[0]);
        attachment.set("fextname", (Object)split[1]);
        attachment.set("FNUMBER", (Object)AttachmentServiceHelper.generateUid());
        try (TXHandle txHandle = TX.notSupported();){
            hrBaseServiceHelper.saveOne(attachment);
        }
    }

    public static void signAttachmentToContract(DynamicObject ... signBills) {
        DynamicObject[] contracts = ContractRepository.getInstance().loadBySignBills(signBills, String.join((CharSequence)",", "protocoltype", "signway"));
        Map<String, DynamicObject> signBillMap = Arrays.stream(signBills).collect(Collectors.toMap(signBill -> signBill.getString("contractnumber"), signBill -> signBill, (v1, v2) -> v1));
        Map<String, DynamicObject> contractMap = AttachmentUtils.getFsOnPageLaborContract(signBills);
        for (DynamicObject contract : contracts) {
            String entityId = AttachmentUtils.getContractEntityId(contract);
            DynamicObject signBill2 = signBillMap.get(contract.getString("number"));
            if (signBill2 == null) continue;
            String signBillId = signBill2.getString("id");
            String id = contract.getString("id");
            if (SignWayEnum.PAPER.getCombKey().equals(contract.getString("signway"))) {
                AttachmentUtils.copyAttachment("paperattachment", "hlcm_papersign_comp", signBillId, "paperattachment", entityId, id);
            }
            AttachmentUtils.handlePageLaborContractFsAttacth(signBill2, contractMap);
            AttachmentUtils.copyAttachment(ATTACHMENT_KEY, null, signBillId, ATTACHMENT_KEY, entityId, id);
        }
        DynamicObject[] stopSignBills = (DynamicObject[])Stream.of(signBills).filter(signBill -> Arrays.asList(BusinessTypeEnum.CANCEL.getCombKey(), BusinessTypeEnum.STOP.getCombKey()).contains(signBill.getString("businesstype"))).toArray(DynamicObject[]::new);
        AttachmentUtils.signAttachmentToOldContract(contractMap, stopSignBills);
    }

    private static void handlePageLaborContractFsAttacth(DynamicObject signBill, Map<String, DynamicObject> contractMap) {
        DynamicObjectCollection dys;
        if (contractMap.isEmpty() || !ProtocolTypeEnum.CON.getCombKey().equals(signBill.getString("protocoltype")) || BusinessTypeEnum.STOP.getCombKey().equals(signBill.getString("businesstype"))) {
            return;
        }
        if ((signBill.getBoolean("issignother") || signBill.getBoolean("issignprotocol")) && !CollectionUtils.isEmpty((Collection)(dys = signBill.getDynamicObjectCollection("entryentity")))) {
            try (TXHandle txHandle = TX.notSupported();){
                for (DynamicObject entryRow : dys) {
                    DynamicObject contract;
                    if (Objects.equals(ContractTypeCatEnum.CON.getPkId(), entryRow.getLong("entrycontracttype.group.id")) || (contract = contractMap.get(entryRow.get("entrycontractnumber"))) == null) continue;
                    if (SignWayEnum.PAPER.getCombKey().equals(signBill.getString("signway"))) {
                        AttachmentUtils.copyPageToFs(entryRow, contract);
                    }
                    AttachmentUtils.copyAttachment(ATTACHMENT_KEY, null, signBill.getString("id"), ATTACHMENT_KEY, AttachmentUtils.getContractEntityId(contract), contract.getString("id"));
                }
            }
        }
    }

    private static void copyPageToFs(DynamicObject entryRow, DynamicObject contract) {
        String entityId = "hlcm_contractfileother";
        DynamicObjectCollection atts = entryRow.getDynamicObjectCollection("entryattachment");
        if (!CollectionUtils.isEmpty((Collection)atts)) {
            ArrayList attachDataList = new ArrayList();
            atts.forEach(attach -> {
                DynamicObject attachObj = attach.getDynamicObject("fbasedataid");
                HashMap<String, Object> attachMap = new HashMap<String, Object>();
                attachMap.put("description", attachObj.getString("description"));
                attachMap.put("type", attachObj.getString("type"));
                InputStream inputStream = FileServiceFactory.getAttachmentFileService().getInputStream(attachObj.getString("url"));
                String saveUrl = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsFullUrl(attachObj.getString("name"), (InputStream)new BufferedInputStream(inputStream), 7200);
                attachMap.put("url", saveUrl);
                attachMap.put("uid", AttachmentUtils.getUid().toString());
                attachMap.put("name", attachObj.getString("name"));
                attachMap.put("size", attachObj.get("size"));
                attachMap.put(FATTACHMENTPANEL, "paperattachment");
                attachMap.put("entityNum", entityId);
                attachMap.put("billPkId", String.valueOf(contract.getLong("id")));
                attachMap.put("lastModified", new Date().getTime());
                attachMap.put("status", "success");
                attachMap.put("client", null);
                attachDataList.add(attachMap);
            });
            HashMap attachmentMap = new HashMap(2);
            attachmentMap.put("paperattachment", attachDataList);
            AttachmentServiceHelper.saveTempAttachments((String)entityId, (Object)contract.getLong("id"), (String)"hlcm", attachmentMap);
        }
    }

    private static StringBuffer getUid() {
        StringBuffer uid = new StringBuffer("rc-upload-");
        uid.append(new Date().getTime());
        uid.append("-");
        int index = RandomUtils.nextInt((int)1, (int)10);
        uid.append(index);
        return uid;
    }

    private static Map<String, DynamicObject> getFsOnPageLaborContract(DynamicObject ... signBills) {
        DynamicObject[] contracts;
        HashSet<String> numbers = new HashSet<String>(8);
        for (DynamicObject signBill : signBills) {
            DynamicObjectCollection dys;
            if (!ProtocolTypeEnum.CON.getCombKey().equals(signBill.getString("protocoltype")) || BusinessTypeEnum.STOP.getCombKey().equals(signBill.getString("businesstype")) || CollectionUtils.isEmpty((Collection)(dys = signBill.getDynamicObjectCollection("entryentity")))) continue;
            for (DynamicObject entryRow : dys) {
                if (Objects.equals(ContractTypeCatEnum.CON.getPkId(), entryRow.getLong("entrycontracttype.group.id"))) continue;
                numbers.add(entryRow.getString("entrycontractnumber"));
            }
        }
        if (!numbers.isEmpty() && (contracts = ContractRepository.getInstance().loadByNumbers(numbers, String.join((CharSequence)",", "protocoltype", "signway"))) != null && contracts.length > 0) {
            return Arrays.stream(contracts).collect(Collectors.toMap(val -> val.getString("number"), val -> val, (v1, v2) -> v1));
        }
        return new HashMap<String, DynamicObject>(0);
    }

    public static void signAttachmentToOldContract(Map<String, DynamicObject> contractMap, DynamicObject ... signBills) {
        AttachmentUtils.signAttachmentToOldContract(signBills);
        for (DynamicObject signBill : signBills) {
            AttachmentUtils.handlePageLaborContractFsAttacth(signBill, contractMap);
        }
    }

    public static void signAttachmentToOldContract(DynamicObject ... signBills) {
        for (DynamicObject signBill : signBills) {
            DynamicObject oldContract = signBill.getDynamicObject("oldcontract");
            if (HRObjectUtils.isEmpty((Object)oldContract)) continue;
            String destBillType = AttachmentUtils.getContractEntityId(oldContract);
            String srcBillType = AttachmentUtils.getSignBillEntityId(signBill);
            AttachmentUtils.copyAttachment(ATTACHMENT_KEY, srcBillType, signBill.getPkValue().toString(), ATTACHMENT_KEY, destBillType, oldContract.getPkValue().toString());
            AttachmentUtils.copyAttachment("paperattachment", "hlcm_papersign_comp", signBill.getPkValue().toString(), "paperattachment", destBillType, oldContract.getPkValue().toString());
        }
    }

    public static void clearAttachmentData(AttachmentPanel attachmentPanel) {
        if (null != attachmentPanel) {
            attachmentPanel.bindData(new ArrayList());
        }
    }
}

