/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.utils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.IntStream;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.common.HLCMCommonRepository;
import kd.hr.hlcm.business.domian.repository.CommonRepository;
import kd.hr.hlcm.common.enums.ContractPeriodTypeEnum;
import kd.hr.hlcm.common.enums.ProtocolTypeEnum;
import kd.hr.hlcm.common.utils.ComboUtils;

public class ContractRecordCardUtils {
    private static final Log LOGGER = LogFactory.getLog(ContractRecordCardUtils.class);
    private static final ContractRecordCardUtils CONTRACT_RECORD_CARD_UTILS = new ContractRecordCardUtils();
    private static final String LAB_FLEXLIST = "flexlistsub";
    private static final String LAB_OTHERFLEX_LIST = "otherflexlistsub";
    private static final String TAG_NEWFLEX_PER = "createFlex";
    private static final String TAG_OTHERNEWFLEX_PER = "createOtherFlex";
    public static final String CONTRACT_RECORD_SELECT_PROPERTIES = "number,maincontract,actualenddate,oldcontract,period,periodtype,actualsigncompany,contractstatus,contracttype,startdate,enddate,boid";
    public static final String CONTRACT_RECORD_ORDER = "createtime desc";
    public static final String FLEX_NODATAO_THER = "nodataother";
    public static final String FLEX_NODATA_HIS = "nodatahis";

    public static ContractRecordCardUtils getInstance() {
        return CONTRACT_RECORD_CARD_UTILS;
    }

    public void showOtherHisCardList(IFormView contractFileView, QFilter dataRule) {
        QFilter initStatusQfilter;
        QFilter isCurrentVersionQfilter;
        QFilter otherFilter;
        Long fid = contractFileView.getModel().getDataEntity().getLong("boid");
        QFilter mainContactQFilter = new QFilter("maincontract", "=", (Object)fid);
        DynamicObject[] queryResult = CommonRepository.queryDynamicObjectByFilters("hlcm_contract", CONTRACT_RECORD_SELECT_PROPERTIES, new QFilter[]{mainContactQFilter, otherFilter = new QFilter("protocoltype", "=", (Object)ProtocolTypeEnum.FS.getCombKey()), isCurrentVersionQfilter = new QFilter("iscurrentversion", "=", (Object)"1"), initStatusQfilter = new QFilter("initstatus", "=", (Object)"2"), dataRule}, CONTRACT_RECORD_ORDER, -1);
        if (queryResult != null && queryResult.length > 0) {
            this.showCard(contractFileView, queryResult, "2");
            contractFileView.setVisible(Boolean.FALSE, new String[]{FLEX_NODATAO_THER});
            this.creatRecordFlexes(contractFileView, queryResult.length, "2");
        } else {
            contractFileView.setVisible(Boolean.TRUE, new String[]{FLEX_NODATA_HIS});
        }
    }

    public void showHisCardList(IFormView contractFileView, QFilter dataRule) {
        DynamicObject dataEntity = contractFileView.getModel().getDataEntity();
        DynamicObject oldContact = dataEntity.getDynamicObject("oldcontract");
        ArrayList<DynamicObject> preContracts = new ArrayList<DynamicObject>(16);
        this.getFutureCon(dataRule, dataEntity, preContracts);
        this.getHisCon(dataRule, oldContact, preContracts);
        DynamicObject[] queryResult = preContracts.toArray(new DynamicObject[0]);
        if (queryResult.length > 0) {
            contractFileView.setVisible(Boolean.FALSE, new String[]{FLEX_NODATA_HIS});
            this.showCard(contractFileView, queryResult, "1");
            this.creatRecordFlexes(contractFileView, queryResult.length, "1");
        } else {
            contractFileView.setVisible(Boolean.TRUE, new String[]{FLEX_NODATA_HIS});
        }
    }

    public void getHisCon(QFilter dataRule, DynamicObject oldContact, List<DynamicObject> preContracts) {
        while (!HRObjectUtils.isEmpty((Object)oldContact)) {
            Object pkValue = oldContact.getPkValue();
            QFilter idFilter = new QFilter("id", "=", pkValue);
            DynamicObject queryDB = HLCMCommonRepository.queryDynamicObject("hlcm_contract", CONTRACT_RECORD_SELECT_PROPERTIES, idFilter);
            if (HLCMCommonRepository.exist("hlcm_contract", idFilter, dataRule)) {
                preContracts.add(queryDB);
            }
            oldContact = queryDB.getDynamicObject("oldcontract");
        }
    }

    public void getFutureCon(QFilter dataRule, DynamicObject dataEntity, List<DynamicObject> preContracts) {
        ArrayList<DynamicObject> tmpList = new ArrayList<DynamicObject>(10);
        while (!HRObjectUtils.isEmpty((Object)dataEntity)) {
            long boid = dataEntity.getLong("boid");
            QFilter oldConFilter = new QFilter("oldcontract.id", "=", (Object)boid).and("iscurrentversion", "=", (Object)"1").and("datastatus", "=", (Object)"1");
            DynamicObject queryDB = HLCMCommonRepository.queryDynamicObject("hlcm_contract", CONTRACT_RECORD_SELECT_PROPERTIES, oldConFilter);
            if (HLCMCommonRepository.exist("hlcm_contract", oldConFilter, dataRule)) {
                tmpList.add(queryDB);
            }
            dataEntity = queryDB;
        }
        if (!CollectionUtils.isEmpty(tmpList)) {
            for (int i = tmpList.size() - 1; i >= 0; --i) {
                preContracts.add((DynamicObject)tmpList.get(i));
            }
        }
    }

    public void showMainContractList(IFormView contractFileView, QFilter dataRule) {
        QFilter isCurrentVersionQFilter;
        DynamicObject mainContract = contractFileView.getModel().getDataEntity().getDynamicObject("maincontract");
        if (HRObjectUtils.isEmpty((Object)mainContract)) {
            return;
        }
        QFilter mainContractNumberQFilter = new QFilter("number", "=", (Object)mainContract.getString("number"));
        DynamicObject[] queryResult = CommonRepository.queryDynamicObjectByFilters("hlcm_contract", CONTRACT_RECORD_SELECT_PROPERTIES, new QFilter[]{mainContractNumberQFilter, isCurrentVersionQFilter = new QFilter("iscurrentversion", "=", (Object)"1"), dataRule}, CONTRACT_RECORD_ORDER, -1);
        if (queryResult != null && queryResult.length > 0) {
            contractFileView.setVisible(Boolean.FALSE, new String[]{FLEX_NODATAO_THER});
            this.showCard(contractFileView, queryResult, "2");
            this.creatRecordFlexes(contractFileView, queryResult.length, "2");
        } else {
            contractFileView.setVisible(Boolean.TRUE, new String[]{FLEX_NODATA_HIS});
        }
    }

    public void creatRecordFlexes(IFormView contractFileView, int createFlexRecordCount, String targetFillTabTag) {
        String flexListTag = HRStringUtils.equals((String)targetFillTabTag, (String)"1") ? LAB_FLEXLIST : LAB_OTHERFLEX_LIST;
        Container flexList = (Container)contractFileView.getControl(flexListTag);
        FlexPanelAp outerFlexPanel = this.createOuterFlexPanel(flexListTag, targetFillTabTag, createFlexRecordCount);
        List runtimeItems = ((Container)outerFlexPanel.buildRuntimeControl()).getItems();
        flexList.getItems().addAll(runtimeItems);
        contractFileView.createControlIndex(flexList.getItems());
        contractFileView.updateControlMetadata(flexListTag, outerFlexPanel.createControl());
    }

    private FlexPanelAp createOuterFlexPanel(String flexListTag, String targetFillTabTag, int createFlexRecordCount) {
        String newFlexPer = HRStringUtils.equals((String)targetFillTabTag, (String)"1") ? TAG_NEWFLEX_PER : TAG_OTHERNEWFLEX_PER;
        FlexPanelAp outerFlexPanel = new FlexPanelAp();
        outerFlexPanel.setKey(flexListTag);
        outerFlexPanel.setName(new LocaleString(flexListTag));
        outerFlexPanel.setLazyLoad(true);
        Style style = new Style();
        Margin margin = new Margin();
        margin.setBottom("20px");
        style.setMargin(margin);
        outerFlexPanel.setStyle(style);
        List items = outerFlexPanel.getItems();
        for (int index = 1; index <= createFlexRecordCount; ++index) {
            FlexPanelAp innerFlexPanel = this.createInnerFlexPanel(newFlexPer, index);
            items.add(innerFlexPanel);
        }
        return outerFlexPanel;
    }

    private FlexPanelAp createInnerFlexPanel(String newFlexPer, int index) {
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        String key = newFlexPer + index;
        flexPanelAp.setKey(key);
        flexPanelAp.setLazyLoad(true);
        return flexPanelAp;
    }

    public void showCard(IFormView contractFileView, DynamicObject[] contractFileArr, String targetFillTabTag) {
        String newFlexPer = HRStringUtils.equals((String)targetFillTabTag, (String)"1") ? TAG_NEWFLEX_PER : TAG_OTHERNEWFLEX_PER;
        IntStream.range(1, contractFileArr.length + 1).forEach(index -> {
            String targetKey = newFlexPer.concat(index + "");
            FormShowParameter formShowParameter = new FormShowParameter();
            OpenStyle openStyle = formShowParameter.getOpenStyle();
            openStyle.setTargetKey(targetKey);
            openStyle.setShowType(ShowType.InContainer);
            formShowParameter.setStatus(OperationStatus.VIEW);
            if (HRStringUtils.equals((String)targetFillTabTag, (String)"1")) {
                formShowParameter.setFormId("hlcm_contracthiscard");
                formShowParameter.setCustomParam("contracttype", contractFileView.getModel().getValue("contracttype"));
            } else {
                formShowParameter.setFormId("hlcm_contractotherhis");
            }
            DynamicObject dataEntity = contractFileArr[index - 1];
            DynamicObject periodType = dataEntity.getDynamicObject("periodtype");
            Date startDate = dataEntity.getDate("startdate");
            Date endDate = dataEntity.getDate("enddate");
            String startDateFormat = "";
            String endDateFormat = "";
            if (!HRObjectUtils.isEmpty((Object)startDate)) {
                startDateFormat = HRInteDateTimeUtil.formatDate((String)"hlcm_contract", (String)"startdate", (Date)startDate);
            }
            if (!HRObjectUtils.isEmpty((Object)endDate)) {
                endDateFormat = HRInteDateTimeUtil.formatDate((String)"hlcm_contract", (String)"enddate", (Date)endDate);
            }
            formShowParameter.setCustomParam("startdate", (Object)startDateFormat);
            formShowParameter.setCustomParam("enddate", (Object)endDateFormat);
            if (!HRObjectUtils.isEmpty((Object)periodType)) {
                formShowParameter.setCustomParam("periodtype", (Object)periodType.getString("name"));
                Object periodTypeId = periodType.getPkValue();
                if (!HRObjectUtils.equals((Object)periodTypeId, (Object)ContractPeriodTypeEnum.FIXED.getPkId()) && HRObjectUtils.isEmpty((Object)dataEntity.getDate("actualenddate"))) {
                    formShowParameter.setCustomParam("period", (Object)"--");
                }
            }
            DynamicObject signCompany = dataEntity.getDynamicObject("actualsigncompany");
            DynamicObject contractType = dataEntity.getDynamicObject("contracttype");
            formShowParameter.setCustomParam("contractNumber", (Object)dataEntity.getString("number"));
            String contractStatus = ComboUtils.getComboOptionLocaleName((DynamicObject)dataEntity, (String)"contractstatus");
            String contractStatusCode = dataEntity.getString("contractstatus");
            formShowParameter.setCustomParam("contractstatus", (Object)contractStatus);
            formShowParameter.setCustomParam("contractStatusCode", (Object)contractStatusCode);
            formShowParameter.setCustomParam("contracttype", (Object)(HRObjectUtils.isEmpty((Object)contractType) ? "" : contractType.getString("name")));
            formShowParameter.setCustomParam("actualsigncompany", (Object)(HRObjectUtils.isEmpty((Object)signCompany) ? "" : signCompany.getString("name")));
            Date actualEndDate = dataEntity.getDate("actualenddate");
            if (!HRObjectUtils.isEmpty((Object)actualEndDate)) {
                String actualEndDateFormat = HRInteDateTimeUtil.formatDate((String)"hlcm_contract", (String)"actualenddate", (Date)actualEndDate);
                formShowParameter.setCustomParam("actualenddate", (Object)actualEndDateFormat);
            }
            contractFileView.setVisible(Boolean.TRUE, new String[]{targetKey});
            contractFileView.showForm(formShowParameter);
        });
    }
}

