/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.LogPrivacyUtil;
import kd.hr.hlcm.business.common.HLCMCommonRepository;
import kd.hr.hlcm.business.domian.repository.ContractSignApplyRepository;
import kd.hr.hlcm.business.domian.service.hspm.IHSPMFileService;
import kd.hr.hlcm.business.utils.ModelUtils;
import kd.hr.hlcm.common.enums.BusinessTypeEnum;
import kd.hr.hlcm.common.enums.ContractCategoryEnum;
import kd.hr.hlcm.common.enums.ContractPeriodTypeEnum;
import kd.hr.hlcm.common.enums.ContractTypeCatEnum;
import kd.hr.hlcm.common.enums.PeriodUnitEnum;
import kd.hr.hlcm.common.enums.PostypeEnum;
import kd.hr.hlcm.common.enums.ProbationUnitEnum;
import kd.hr.hlcm.common.enums.ProtocolTypeEnum;
import kd.sdk.hr.hpfs.business.config.service.IDevParamConfigService;

public class ContractSignUtils {
    private static final Log LOGGER = LogFactory.getLog(ContractSignUtils.class);
    public static final String ACTIVE_ID_TERMINATE = "terminateOperation";
    public static final String TAG_TERMINATE_SELECTEDROWS = "terminateIDs";
    private static final String ACTUAL_SIGNCOMPANY_HIS_DATA = "actualsigncompanyhisdata";
    private static final String CONTRACT_TEMPLATE_VID = "contracttemplate.vid";
    public static final HRBaseServiceHelper CONTRACT_HELPER = new HRBaseServiceHelper("hlcm_contractsource");
    public static final HRBaseServiceHelper ACTIVITY_HELPER = new HRBaseServiceHelper("hlcm_activity");

    public static Map<String, Object> getPersonInfoByErManFile(Long erManFileId) {
        List perAddressDyList;
        List trialPeriodMap;
        Map<String, Object> erManFileInfo = IHSPMFileService.getInstance().getCardFieldByErManFileId(erManFileId);
        if (CollectionUtils.isEmpty(erManFileInfo)) {
            return Maps.newHashMap();
        }
        HashMap manFile = Maps.newHashMapWithExpectedSize((int)erManFileInfo.size());
        manFile.put("empname", erManFileInfo.get("name"));
        manFile.put("empnumber", erManFileInfo.get("number"));
        manFile.put("postype", erManFileInfo.get("postype_id"));
        Date useStartDate = (Date)erManFileInfo.get("startdate");
        manFile.put("startdate", useStartDate);
        String phone = (String)erManFileInfo.get("phone");
        manFile.put("empphone", phone);
        Long employeeId = HRJSONUtils.getLongValOfCustomParam((Object)erManFileInfo.get("employee_id"));
        manFile.put("employee_id", employeeId);
        Long personId = HRJSONUtils.getLongValOfCustomParam((Object)erManFileInfo.get("person_id"));
        manFile.put("person_id", personId);
        manFile.put("location_id", HRJSONUtils.getLongValOfCustomParam((Object)erManFileInfo.get("location_id")));
        manFile.put("empgroup_id", HRJSONUtils.getLongValOfCustomParam((Object)erManFileInfo.get("empgroup_id")));
        manFile.put("org_id", HRJSONUtils.getLongValOfCustomParam((Object)erManFileInfo.get("org_id")));
        manFile.put("affiliateadminorg_id", HRJSONUtils.getLongValOfCustomParam((Object)erManFileInfo.get("affiliateadminorg_id")));
        manFile.put("signedcompany", HRJSONUtils.getLongValOfCustomParam((Object)erManFileInfo.get("company_id")));
        manFile.put("department", HRJSONUtils.getLongValOfCustomParam((Object)erManFileInfo.get("adminorg_id")));
        manFile.put("position", HRJSONUtils.getLongValOfCustomParam((Object)erManFileInfo.get("position_id")));
        manFile.put("stdposition", HRJSONUtils.getLongValOfCustomParam((Object)erManFileInfo.get("stdposition_id")));
        manFile.put("job", HRJSONUtils.getLongValOfCustomParam((Object)erManFileInfo.get("job_id")));
        List perCreMap = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"listPersonAttachs", (Object[])new Object[]{personId, "hrpi_percre"});
        if (!CollectionUtils.isEmpty((Collection)perCreMap)) {
            for (Map tmpMap : perCreMap) {
                Long credentTypeId = (Long)tmpMap.get("credentialstype_id");
                Boolean isMajor = (Boolean)tmpMap.get("ismajor");
                if (isMajor.booleanValue()) {
                    ContractSignUtils.setCardInfo(manFile, tmpMap);
                }
                if (credentTypeId != 1010L) continue;
                ContractSignUtils.setCardInfo(manFile, tmpMap);
                break;
            }
            if (manFile.get("cardtype") == null) {
                ContractSignUtils.setCardInfo(manFile, (Map)perCreMap.get(0));
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(trialPeriodMap = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIEmployeeService", (String)"listEmployeeAttachs", (Object[])new Object[]{employeeId, "hrpi_trialperiod"})))) {
            Date startDate = (Date)((Map)trialPeriodMap.get(0)).get("startdate");
            manFile.put("probationstartdate", startDate);
            Date endDate = (Date)((Map)trialPeriodMap.get(0)).get("preregulardate");
            manFile.put("probationenddate", endDate);
            Integer probation = (Integer)((Map)trialPeriodMap.get(0)).get("probation");
            String probationUnit = (String)((Map)trialPeriodMap.get(0)).get("probationunit");
            manFile.put("probationperiod", probation);
            manFile.put("probationperiodunit", probationUnit);
        }
        if (!CollectionUtils.isEmpty((Collection)(perAddressDyList = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"listPersonAttachs", (Object[])new Object[]{personId, "hrpi_peraddress"})))) {
            perAddressDyList.forEach(perAddress -> {
                Long addressTypeId = (Long)perAddress.get("addresstype_id");
                if (1020L == addressTypeId) {
                    manFile.put("householdregister", perAddress.get("addressinfo"));
                } else if (1030L == addressTypeId) {
                    manFile.put("residentialaddress", perAddress.get("addressinfo"));
                } else {
                    LOGGER.info("addressTypeId|{}", (Object)addressTypeId);
                }
            });
        }
        Map personInfoMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getPersonInfo", (Object[])new Object[]{personId});
        manFile.put("nationality_id", personInfoMap.get("nationality_id"));
        LOGGER.info("ContractSignUtils.getPersonInfoByErManFile======manFile:|{}", (Object)LogPrivacyUtil.filterPrivacyProp((Map)manFile, (List)Lists.newArrayList((Object[])new String[]{"empphone", "cardnumber"})));
        return manFile;
    }

    private static void setCardInfo(HashMap<String, Object> manFile, Map tmpMap) {
        manFile.put("cardtype", tmpMap.get("credentialstype_id"));
        manFile.put("cardtypename", tmpMap.get("credentialstype"));
        manFile.put("cardnumber", tmpMap.get("number"));
    }

    public static void setControlIsEmpty(IFormView view, String ... controlIds) {
        for (String controlId : controlIds) {
            Control control = view.getControl(controlId);
            if (HRObjectUtils.isEmpty((Object)control)) continue;
            view.getModel().setValue(controlId, (Object)"");
        }
    }

    public static void setControlListIsEmpty(IFormView view, List<String> controlIds) {
        for (String controlId : controlIds) {
            Control control = view.getControl(controlId);
            if (HRObjectUtils.isEmpty((Object)control)) continue;
            view.getModel().setValue(controlId, (Object)"");
        }
    }

    public static Map<String, Object> callRuleEngine(String bizApp, String sceneNumber, String buNumber, List<Long> executePolicyIds, Map<String, Object> inputParams) {
        HashMap requestMap = Maps.newHashMapWithExpectedSize((int)6);
        requestMap.put("tenantId", RequestContext.get().getTenantId());
        requestMap.put("bizApp", bizApp);
        requestMap.put("sceneNumber", sceneNumber);
        requestMap.put("buNumber", buNumber);
        if (!CollectionUtils.isEmpty(executePolicyIds)) {
            requestMap.put("executePolicyIds", executePolicyIds);
        }
        if (!CollectionUtils.isEmpty(inputParams)) {
            requestMap.put("inputParams", inputParams);
        }
        return (Map)HRMServiceHelper.invokeHRMPService((String)"brm", (String)"IBRMRuleService", (String)"callRuleEngine", (Object[])new Object[]{requestMap});
    }

    public static String readCodeRuleNumberByCurrentDy(String dyName) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(dyName);
        DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
        return CodeRuleServiceHelper.readNumber((String)dyName, (DynamicObject)dynamicObject, null);
    }

    public static String readCodeRuleNumberByCurrentDy(String dyName, String orgId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(dyName);
        DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
        return CodeRuleServiceHelper.readNumber((String)dyName, (DynamicObject)dynamicObject, (String)orgId);
    }

    public static String getCodeRuleNumberByCurrentDy(String dyName) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(dyName);
        DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
        return CodeRuleServiceHelper.getNumber((String)dyName, (DynamicObject)dynamicObject, null);
    }

    public static String getCodeRuleNumberByCurrentDy(String dyName, String orgId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(dyName);
        DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
        return CodeRuleServiceHelper.getNumber((String)dyName, (DynamicObject)dynamicObject, (String)orgId);
    }

    public static boolean isExistByCurrentDy(String dyName) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(dyName);
        DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
        return CodeRuleServiceHelper.isExist((String)dyName, (DynamicObject)dynamicObject, null);
    }

    public static boolean codeRuleIsModify(String dyName, String orgId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(dyName);
        DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
        boolean modifiable = CodeRuleServiceHelper.isModifiable((String)dyName, (DynamicObject)dynamicObject, (String)orgId);
        LOGGER.info("ContractSignUtils.codeRuleIsModify.result:{}", (Object)modifiable);
        return modifiable;
    }

    public static boolean isShowCodeAddNew(String dyName, String orgId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(dyName);
        DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
        return CodeRuleServiceHelper.isAddView((String)dyName, (DynamicObject)dynamicObject, (String)orgId);
    }

    public static boolean isModifyCanUpdate(String dyName, String orgId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(dyName);
        DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
        CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)dyName, (DynamicObject)dynamicObject, (String)orgId);
        if (!HRObjectUtils.isEmpty((Object)codeRule)) {
            return codeRule.isUpdateRecover();
        }
        return false;
    }

    public static String getNumber(String billFormId, boolean isSave) {
        return ContractSignUtils.getNumber(billFormId, isSave, null);
    }

    public static String getNumber(String billFormId, boolean isSave, String orgId) {
        String htNumber = null;
        String contractBusinessType = ContractSignUtils.getContractNameBySignBill(billFormId);
        htNumber = HRStringUtils.isNotEmpty((String)orgId) ? ContractSignUtils.getCodeRuleNumberByCurrentDy(contractBusinessType, orgId) : ContractSignUtils.getCodeRuleNumberByCurrentDy(contractBusinessType);
        return htNumber;
    }

    public static String getBusinessTypeByBillFormId(String billFormId) {
        String businessType = null;
        switch (billFormId) {
            case "hlcm_contractapplynew": 
            case "hlcm_empprotocolnew": 
            case "hlcm_otheragreements": {
                businessType = BusinessTypeEnum.NEW.getCombKey();
                break;
            }
            case "hlcm_contractapplyrenew": {
                businessType = BusinessTypeEnum.RENEW.getCombKey();
                break;
            }
            case "hlcm_contractapplychange": {
                businessType = BusinessTypeEnum.CHANGE.getCombKey();
                break;
            }
            case "hlcm_contractapplycancel": 
            case "hlcm_empprotocolrelieve": {
                businessType = BusinessTypeEnum.CANCEL.getCombKey();
                break;
            }
            case "hlcm_contractapplyend": {
                businessType = BusinessTypeEnum.STOP.getCombKey();
                break;
            }
        }
        return businessType;
    }

    public static String getContractNameBySignBill(String billFormId) {
        String ContractName = null;
        switch (billFormId) {
            case "hlcm_contractapplynew": 
            case "hlcm_contractapplyrenew": 
            case "hlcm_contractapplychange": 
            case "hlcm_contractapplycancel": 
            case "hlcm_contractapplyend": {
                ContractName = "hlcm_contract";
                break;
            }
            case "hlcm_otheragreements": {
                ContractName = "hlcm_contractfileother";
                break;
            }
            case "hlcm_empprotocolnew": 
            case "hlcm_empprotocolrelieve": 
            case "hlcm_empprotocolterminate": {
                ContractName = "hlcm_contractfileemp";
                break;
            }
        }
        return ContractName;
    }

    public static void calcEndDateInfo(IDataModel model) {
        DynamicObject dataEntity = model.getDataEntity();
        BigDecimal period = dataEntity.getBigDecimal("period");
        Date startDate = dataEntity.getDate("startdate");
        if (Objects.isNull(period) || Objects.isNull(startDate) || period.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        int year = period.intValue();
        Date result = HRDateTimeUtils.addYear((Date)startDate, (int)year);
        BigDecimal floatValue = period.subtract(new BigDecimal(year));
        if (floatValue.compareTo(BigDecimal.ZERO) > 0) {
            result = HRDateTimeUtils.addDay((Date)result, (long)floatValue.multiply(new BigDecimal("365")).setScale(0, RoundingMode.HALF_UP).intValue());
        }
        ModelUtils.setDateValue("enddate", HRDateTimeUtils.getBeforeDay((Date)result), model);
    }

    public static boolean setStartDateAndEndDateInfo(IFormView view) {
        DynamicObject dataEntity = view.getModel().getDataEntity();
        ContractSignApplyRepository instance = ContractSignApplyRepository.getInstance();
        String errorMsg = instance.isDateStartEndValidate(dataEntity);
        if (!HRStringUtils.isEmpty((String)errorMsg)) {
            view.showErrorNotification(errorMsg);
            view.getModel().setValue("period", (Object)0);
            return false;
        }
        return true;
    }

    public static void setEntryStartDateAndEndDateInfo(IFormView view, DynamicObject dataEntity) {
        ContractSignApplyRepository instance = ContractSignApplyRepository.getInstance();
        String errorMsg = instance.isEntryDateStartEndValidate(dataEntity);
        if (!HRStringUtils.isEmpty((String)errorMsg)) {
            view.showErrorNotification(errorMsg);
            view.getModel().setValue("entryperiod", (Object)0);
        }
    }

    public static boolean isAuditView(IFormView view) {
        IFormView parentView = view.getViewNoPlugin(view.getFormShowParameter().getParentPageId());
        if (Objects.isNull(parentView)) {
            return false;
        }
        return HRStringUtils.equals((String)"wftask", (String)parentView.getFormShowParameter().getAppId());
    }

    public static void updateEndDateControlMustByPeriodType(IFormView view, boolean isPropertyChanged) {
        DynamicObject dataEntity = view.getModel().getDataEntity();
        DynamicObject periodTypeDy = dataEntity.getDynamicObject("periodtype");
        if (HRObjectUtils.isEmpty((Object)periodTypeDy)) {
            return;
        }
        DateEdit endDate = (DateEdit)view.getControl("enddate");
        ComboEdit periodUnit = (ComboEdit)view.getControl("periodunit");
        DecimalEdit period = (DecimalEdit)view.getControl("period");
        long periodTypeId = periodTypeDy.getLong("id");
        if (periodTypeId == ContractPeriodTypeEnum.FIXED.getPkId()) {
            if (endDate != null) {
                endDate.setMustInput(true);
            }
            if (periodUnit != null) {
                periodUnit.setMustInput(true);
            }
            if (period != null) {
                period.setMustInput(true);
            }
        } else if (periodTypeId == ContractPeriodTypeEnum.NONFIXED.getPkId() || periodTypeId == ContractPeriodTypeEnum.COMPTASK.getPkId()) {
            if (endDate != null) {
                endDate.setMustInput(false);
            }
            if (periodUnit != null) {
                periodUnit.setMustInput(false);
            }
            if (period != null) {
                period.setMustInput(false);
            }
        }
        if (isPropertyChanged) {
            String initPeriodUnit = periodTypeId == ContractPeriodTypeEnum.NONFIXED.getPkId() ? "0" : PeriodUnitEnum.YEAR.getCombKey();
            view.getModel().setValue("periodunit", (Object)initPeriodUnit);
            view.getModel().setValue("period", (Object)"");
            view.getModel().setValue("enddate", (Object)"");
        }
    }

    public static void updateEntryEndDateControlMustByPeriodType(IFormView view, DynamicObject dataEntity, int rowIndex, boolean isPropertyChanged) {
        DynamicObject periodTypeDy = dataEntity.getDynamicObject("entryperiodtype");
        if (HRObjectUtils.isEmpty((Object)periodTypeDy)) {
            return;
        }
        long periodTypeId = periodTypeDy.getLong("id");
        if (periodTypeId == ContractPeriodTypeEnum.FIXED.getPkId() || periodTypeId == ContractPeriodTypeEnum.COMPTASK.getPkId()) {
            view.setEnable(Boolean.valueOf(true), rowIndex, new String[]{"entryenddate"});
            view.setEnable(Boolean.valueOf(true), rowIndex, new String[]{"entryperiodunit"});
            view.setEnable(Boolean.valueOf(true), rowIndex, new String[]{"entryperiod"});
        } else if (periodTypeId == ContractPeriodTypeEnum.NONFIXED.getPkId()) {
            view.setEnable(Boolean.valueOf(false), rowIndex, new String[]{"entryenddate"});
            view.setEnable(Boolean.valueOf(false), rowIndex, new String[]{"entryperiodunit"});
            view.setEnable(Boolean.valueOf(false), rowIndex, new String[]{"entryperiod"});
        }
        if (isPropertyChanged) {
            String initPeriodUnit = periodTypeId == ContractPeriodTypeEnum.NONFIXED.getPkId() ? "0" : PeriodUnitEnum.YEAR.getCombKey();
            view.getModel().setValue("entryperiodunit", (Object)initPeriodUnit);
            view.getModel().setValue("entryperiod", (Object)"");
            view.getModel().setValue("entryenddate", (Object)"");
        }
    }

    public static Optional<String> validateFixedMustInput(DynamicObject dataEntity) {
        String businessType = dataEntity.getString("businesstype");
        if (Sets.newHashSet((Object[])new String[]{BusinessTypeEnum.STOP.getCombKey(), BusinessTypeEnum.CANCEL.getCombKey()}).contains(businessType)) {
            return Optional.empty();
        }
        DynamicObject periodTypeDy = dataEntity.getDynamicObject("periodtype");
        Date endDate = dataEntity.getDate("enddate");
        String periodUnit = dataEntity.getString("periodunit");
        BigDecimal period = dataEntity.getBigDecimal("period");
        Object periodTypeId = periodTypeDy.getPkValue();
        if (!Objects.equals(ContractPeriodTypeEnum.FIXED.getPkId(), periodTypeId)) {
            return Optional.empty();
        }
        if (HRObjectUtils.isEmpty((Object)endDate)) {
            return Optional.ofNullable(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5408\u540c\u7ed3\u675f\u65e5\u671f\u201d\u3002", (String)"ContractSignUtils_1", (String)"hr-hlcm-business", (Object[])new Object[0]));
        }
        if (HRObjectUtils.isEmpty((Object)periodUnit)) {
            return Optional.ofNullable(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5408\u540c\u671f\u9650\u5355\u4f4d\u201d\u3002", (String)"ContractSignUtils_2", (String)"hr-hlcm-business", (Object[])new Object[0]));
        }
        if (HRObjectUtils.isEmpty((Object)period)) {
            return Optional.ofNullable(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5408\u540c\u671f\u9650\u201d\u3002", (String)"ContractSignUtils_3", (String)"hr-hlcm-business", (Object[])new Object[0]));
        }
        return Optional.empty();
    }

    public static void setCancelPartyABInfo(DynamicObject cancelContract, IDataModel cancelModel) {
        ContractSignUtils.setCancelPartyAInfo(cancelContract, cancelModel);
        ContractSignUtils.setCancelPartyBInfo(cancelContract, cancelModel);
    }

    public static void setCancelPartyBInfo(DynamicObject cancelContract, IDataModel cancelModel) {
        cancelModel.setValue("empname", (Object)cancelContract.getString("name"));
        cancelModel.setValue("cardtype", (Object)cancelContract.getDynamicObject("cardtype"));
        cancelModel.setValue("cardnumber", (Object)cancelContract.getString("cardnumber"));
        cancelModel.setValue("householdregister", (Object)cancelContract.getString("householdregister"));
        cancelModel.setValue("residentialaddress", (Object)cancelContract.getString("residentialaddress"));
        Set properties = cancelModel.getDataEntity().getDynamicObjectType().getProperties().stream().map(dt -> dt.getName()).collect(Collectors.toSet());
        if (properties.contains("oldempphone")) {
            cancelModel.setValue("oldempphone", (Object)cancelContract.getString("empphone"));
        }
    }

    public static void setCancelPartyAInfo(DynamicObject cancelContract, IDataModel cancelModel) {
        cancelModel.setValue("oldcontract", (Object)cancelContract);
        cancelModel.setValue(ACTUAL_SIGNCOMPANY_HIS_DATA, (Object)cancelContract.getDynamicObject("actualsigncompanyhis"));
    }

    public static void setSignTemplateHis(DynamicObjectCollection signTemplates) {
        if (Objects.isNull(signTemplates)) {
            return;
        }
        for (DynamicObject signTemplate : signTemplates) {
            DynamicObject curSignTemplate = signTemplate.getDynamicObject("contracttemplate");
            if (HRObjectUtils.isEmpty((Object)curSignTemplate)) continue;
            long curSignTemplateVid = signTemplate.getLong(CONTRACT_TEMPLATE_VID);
            signTemplate.set("texthis", (Object)HLCMCommonRepository.queryDynamicObjectByPk("hlcm_contracttemplatehis", null, curSignTemplateVid));
        }
    }

    public static void setSignTemplateHis(DynamicObject bill) {
        DynamicObject curSignTemplate;
        if (Objects.isNull(bill)) {
            return;
        }
        DataEntityPropertyCollection propertys = bill.getDataEntityType().getProperties();
        if (propertys.containsKey((Object)"contractemplate") && propertys.containsKey((Object)"contractemplatehis") && !HRObjectUtils.isEmpty((Object)(curSignTemplate = bill.getDynamicObject("contractemplate")))) {
            long curSignTemplateVid = bill.getLong("contractemplate.vid");
            bill.set("contractemplatehis", (Object)HLCMCommonRepository.queryDynamicObjectByPk("hlcm_contracttemplatehis", null, curSignTemplateVid));
        }
        DynamicObjectCollection signTemplates = bill.getDynamicObjectCollection("entryentity");
        ContractSignUtils.setSignTemplateHis(signTemplates);
    }

    public static void setPeriodUnit(DynamicObject signBill) {
        if (HRObjectUtils.isEmpty((Object)signBill.get("periodunit"))) {
            signBill.set("periodunit", (Object)"0");
        }
        if (Lists.newArrayList((Object[])new String[]{BusinessTypeEnum.STOP.getCombKey()}).contains(signBill.getString("businesstype"))) {
            signBill.set("periodunit", (Object)" ");
        }
        DynamicObject periodType = signBill.getDynamicObject("periodtype");
        BigDecimal period = signBill.getBigDecimal("period");
        if (!HRObjectUtils.isEmpty((Object)periodType)) {
            Object periodTypeId = periodType.getPkValue();
            if (Objects.equals(ContractPeriodTypeEnum.NONFIXED.getPkId(), periodTypeId)) {
                signBill.set("periodunit", (Object)"0");
            } else if (Objects.equals(ContractPeriodTypeEnum.COMPTASK.getPkId(), periodTypeId) && (HRObjectUtils.isEmpty((Object)period) || period.compareTo(BigDecimal.ZERO) == 0)) {
                signBill.set("periodunit", (Object)"0");
            }
        }
        DynamicObjectCollection dys = signBill.getDynamicObjectCollection("entryentity");
        for (DynamicObject dy : dys) {
            DynamicObject entryPeriodType = dy.getDynamicObject("entryperiodtype");
            BigDecimal entryPeriod = dy.getBigDecimal("entryperiod");
            if (HRObjectUtils.isEmpty((Object)entryPeriodType)) continue;
            Object entryPeriodTypeId = entryPeriodType.getPkValue();
            if (Objects.equals(ContractPeriodTypeEnum.NONFIXED.getPkId(), entryPeriodTypeId)) {
                dy.set("entryperiodunit", (Object)"0");
                continue;
            }
            if (!Objects.equals(ContractPeriodTypeEnum.COMPTASK.getPkId(), entryPeriodTypeId) || !HRObjectUtils.isEmpty((Object)entryPeriod) && entryPeriod.compareTo(BigDecimal.ZERO) != 0) continue;
            dy.set("entryperiodunit", (Object)"0");
        }
    }

    public static void setContractCategory(DynamicObject signBill) {
        if (!HRStringUtils.equals((String)signBill.getString("protocoltype"), (String)ProtocolTypeEnum.CON.getCombKey())) {
            return;
        }
        DynamicObject posType = signBill.getDynamicObject("postype");
        if (HRObjectUtils.isEmpty((Object)posType)) {
            return;
        }
        Object posTypeId = posType.getPkValue();
        if (Objects.equals(posTypeId, PostypeEnum.FULL.getCombKey())) {
            signBill.set("contractcategory", (Object)ContractCategoryEnum.MAIN.getCombKey());
        } else if (Objects.equals(posTypeId, PostypeEnum.EXPATRIATE.getCombKey())) {
            signBill.set("contractcategory", (Object)ContractCategoryEnum.OUTER.getCombKey());
        } else {
            LOGGER.warn("posTypeId|{} is not 1010 or 1040", posTypeId);
        }
    }

    public static void propertyChangedOldContractSignStatus(IFormView formView, boolean clearErManFile) {
        if (formView.getFormShowParameter().getStatus() != OperationStatus.VIEW) {
            IDataModel model = formView.getModel();
            String errorMsg = ContractSignApplyRepository.getInstance().checkOldContractSignStatus(model.getDataEntity());
            if (HRStringUtils.isNotEmpty((String)errorMsg)) {
                formView.showErrorNotification(errorMsg);
                if (clearErManFile) {
                    model.setValue("ermanfile", null);
                }
            }
        }
    }

    public static BigDecimal calcProbationPeriodMonth(DynamicObject signBill) {
        BigDecimal probationPeriod = signBill.getBigDecimal("probationperiod");
        String probationUnit = signBill.getString("probationunit");
        BigDecimal probationPeriodMonth = probationPeriod;
        if (HRStringUtils.equals((String)ProbationUnitEnum.WEEK.getCombKey(), (String)probationUnit)) {
            probationPeriodMonth = probationPeriod.multiply(new BigDecimal(7)).divide(new BigDecimal(30), 1, RoundingMode.HALF_UP);
        } else if (HRStringUtils.equals((String)ProbationUnitEnum.DAY.getCombKey(), (String)probationUnit)) {
            probationPeriodMonth = probationPeriod.divide(new BigDecimal(30), 1, RoundingMode.HALF_UP);
        } else {
            LOGGER.info("probationPeriod|{}", (Object)probationPeriod.toString());
        }
        return probationPeriodMonth;
    }

    public static void HandleEntryInfo(DynamicObject signBill) {
        String billFormId;
        String businessTypeEnum;
        if (!HRStringUtils.equals((String)signBill.getString("protocoltype"), (String)ProtocolTypeEnum.CON.getCombKey())) {
            return;
        }
        List<String> businessType = Arrays.asList(BusinessTypeEnum.NEW.getCombKey(), BusinessTypeEnum.RENEW.getCombKey(), BusinessTypeEnum.CHANGE.getCombKey());
        if (!businessType.contains(businessTypeEnum = ContractSignUtils.getBusinessTypeByBillFormId(billFormId = signBill.getDataEntityType().getName()))) {
            return;
        }
        DynamicObjectCollection dys = signBill.getDynamicObjectCollection("entryentity");
        if (!signBill.getBoolean("issignother") && !dys.isEmpty()) {
            dys.clear();
        }
        dys.removeIf(val -> Objects.equals(ContractTypeCatEnum.CON.getPkId(), val.getLong("entrycontracttype.group.id")));
        DynamicObject conNewRow = dys.addNew();
        conNewRow.set("entrycontractnumber", signBill.get("contractnumber"));
        conNewRow.set("entrycontracttype", signBill.get("contracttype"));
        conNewRow.set("entryperiodtype", signBill.get("periodtype"));
        conNewRow.set("entrystartdate", signBill.get("startdate"));
        conNewRow.set("entryperiod", signBill.get("period"));
        conNewRow.set("entryperiodunit", signBill.get("periodunit"));
        conNewRow.set("entryenddate", signBill.get("enddate"));
        conNewRow.set("contracttemplate", signBill.get("contractemplate"));
        conNewRow.set("opperson", (Object)RequestContext.get().getCurrUserId());
        conNewRow.set("opdate", (Object)new Date());
        conNewRow.set("remark", signBill.get("contractremark"));
    }

    public static boolean isConNew(String formId) {
        return "hlcm_contractapplynew".equals(formId) || "hlcm_contractapplyrenew".equals(formId) || "hlcm_contractapplychange".equals(formId);
    }

    public static boolean isContractNotStop(String formId) {
        return "hlcm_contractapplynew".equals(formId) || "hlcm_contractapplyrenew".equals(formId) || "hlcm_contractapplychange".equals(formId) || "hlcm_contractapplycancel".equals(formId);
    }

    public static void setOtherProtocolNumberForEntity(IFormView formView, int rowNum) {
        String isModifyStr;
        String billFormId = "hlcm_otheragreements";
        IDataModel dataModel = formView.getModel();
        long orgId = dataModel.getDataEntity().getLong("ermanorg.id");
        String htNumber = ContractSignUtils.getNumber(billFormId, true, String.valueOf(orgId));
        if (!HRStringUtils.isEmpty((String)htNumber)) {
            dataModel.setValue("entrycontractnumber", (Object)htNumber, rowNum);
        }
        if ((isModifyStr = formView.getPageCache().get("entrycontractnumber")) == null) {
            String businessTypeByBillFormId = ContractSignUtils.getContractNameBySignBill(billFormId);
            boolean isModify = ContractSignUtils.codeRuleIsModify(businessTypeByBillFormId, String.valueOf(orgId));
            isModifyStr = Boolean.toString(isModify);
            formView.getPageCache().put("entrycontractnumber", isModifyStr);
        }
        DynamicObjectCollection dys = dataModel.getDataEntity().getDynamicObjectCollection("entryentity");
        for (int index = 0; index < dys.size(); ++index) {
            if (Objects.equals(ContractTypeCatEnum.CON.getPkId(), ((DynamicObject)dys.get(index)).getLong("entrycontracttype.group.id"))) continue;
            formView.setEnable(Boolean.valueOf(isModifyStr), index, new String[]{"entrycontractnumber"});
        }
    }

    public static boolean notCheckEntryData(DynamicObject signBill) {
        try {
            String protocolType = signBill.getString("protocoltype");
            return ProtocolTypeEnum.CON.getCombKey().equals(protocolType) && !signBill.getBoolean("issignother") && !signBill.getBoolean("issignprotocol");
        }
        catch (Exception ex) {
            LOGGER.error("notCheckEntryData ex", (Throwable)ex);
            return false;
        }
    }

    public static String getSignModeVal() {
        String signModeVal = IDevParamConfigService.getInstance().queryBusinessValueByBusinessKey("hlcm_sign_mode");
        signModeVal = HRStringUtils.trim((String)signModeVal);
        return signModeVal;
    }
}

