/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.vaildator;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.domian.repository.ContractSignApplyRepository;
import kd.hr.hlcm.business.vaildator.FutureContractValidator;
import kd.hr.hlcm.business.vaildator.HasInitingEmpProtocolValidator;
import kd.hr.hlcm.business.vaildator.IsBasedataBanForBillValidator;
import kd.hr.hlcm.business.vaildator.IsComptaskValidator;
import kd.hr.hlcm.business.vaildator.IsContractCanCancel;
import kd.hr.hlcm.business.vaildator.IsContractInValueValidator;
import kd.hr.hlcm.business.vaildator.IsContractToBeValueValidator;
import kd.hr.hlcm.business.vaildator.IsContractValuingValidator;
import kd.hr.hlcm.business.vaildator.IsCrossBillTransfersValidator;
import kd.hr.hlcm.business.vaildator.IsCrossBillsQuitValidator;
import kd.hr.hlcm.business.vaildator.IsCrossBillsRetireValidator;
import kd.hr.hlcm.business.vaildator.IsDateEndSignValidator;
import kd.hr.hlcm.business.vaildator.IsDateStartEndValidator;
import kd.hr.hlcm.business.vaildator.IsEmpContractUseStartValidator;
import kd.hr.hlcm.business.vaildator.IsEmpProtocolExistValidator;
import kd.hr.hlcm.business.vaildator.IsEmpProtocolOnValueValidator;
import kd.hr.hlcm.business.vaildator.IsExistsContractNumberValidator;
import kd.hr.hlcm.business.vaildator.IsProtocolCrossValidator;
import kd.hr.hlcm.business.vaildator.IsProtocolNewestValueValidator;
import kd.hr.hlcm.business.vaildator.IsProtocolToBeValueValidator;
import kd.hr.hlcm.business.vaildator.IsTemplateExpiredValidator;
import kd.hr.hlcm.business.vaildator.LicenseCheckForPersonF7Validator;
import kd.hr.hlcm.business.vaildator.OtherAgreementValidator;
import kd.hr.hlcm.business.vaildator.ProtocolCancelDateValidator;
import kd.hr.hlcm.business.vaildator.ValidatorHolder;
import kd.hr.hlcm.business.vaildator.checkOldContractSignStatusValidator;
import kd.hr.hlcm.common.entity.NoticeEntity;
import kd.hr.hlcm.common.enums.BusinessTypeEnum;
import kd.hr.hlcm.common.enums.ProtocolTypeEnum;

public class ContractProtocolValidatorFactory {
    private static final Log LOGGER = LogFactory.getLog(ContractProtocolValidatorFactory.class);

    public static List<NoticeEntity> getManualTipNoticeEntitie(DynamicObject dynamicObject) {
        String protocolType = dynamicObject.getString("protocoltype");
        ProtocolTypeEnum protocolTypeEnum = ProtocolTypeEnum.getValueByKey((String)protocolType);
        if (ProtocolTypeEnum.YG == protocolTypeEnum) {
            return ContractProtocolValidatorFactory.getEmpProtocolTipManualValidatorHolder(dynamicObject);
        }
        if (ProtocolTypeEnum.FS == protocolTypeEnum) {
            return ContractProtocolValidatorFactory.getOtherProtocolTipManualValidatorHolder(dynamicObject);
        }
        return Lists.newArrayList();
    }

    private static List<NoticeEntity> getOtherProtocolTipManualValidatorHolder(DynamicObject dynamicObject) {
        String businessType = dynamicObject.getString("businesstype");
        if (HRStringUtils.equals((String)BusinessTypeEnum.NEW.getCombKey(), (String)businessType)) {
            return OtherAgreementValidator.getInstance().checkPersonInfoTip(dynamicObject);
        }
        return Lists.newArrayList();
    }

    private static List<NoticeEntity> getEmpProtocolTipManualValidatorHolder(DynamicObject appleBill) {
        String businessType = appleBill.getString("businesstype");
        ValidatorHolder importValidatorHolder = null;
        ArrayList noticeEntities = Lists.newArrayList();
        ValidatorHolder holder = new ValidatorHolder(appleBill, true);
        if (HRStringUtils.equals((String)BusinessTypeEnum.NEW.getCombKey(), (String)businessType)) {
            importValidatorHolder = ContractProtocolValidatorFactory.getEmpProtocolValidatorHolderNewTip(holder);
        } else if (HRStringUtils.equals((String)BusinessTypeEnum.CANCEL.getCombKey(), (String)businessType)) {
            importValidatorHolder = ContractProtocolValidatorFactory.getEmpProtocolValidatorHolderCancelTip(holder);
        } else if (HRStringUtils.equals((String)BusinessTypeEnum.STOP.getCombKey(), (String)businessType)) {
            importValidatorHolder = ContractProtocolValidatorFactory.getEmpProtocolValidatorHolderStopTip(holder);
        } else {
            LOGGER.info("businessType|{}", (Object)businessType);
        }
        if (importValidatorHolder != null) {
            Object errorNotice = importValidatorHolder.startValidate();
            if (!HRObjectUtils.isEmpty((Object)errorNotice)) {
                String[] split;
                for (String errorMsg : split = errorNotice.toString().split(";")) {
                    noticeEntities.add(new NoticeEntity(Integer.valueOf(NoticeEntity.NoticeLevel.NOTICE.getVal()), errorMsg));
                }
            }
            return noticeEntities.stream().filter(Objects::nonNull).collect(Collectors.toList());
        }
        return noticeEntities;
    }

    public static ValidatorHolder getEmpProtocolManualValidatorHolder(DynamicObject dynamicObject, boolean isImportType) {
        ValidatorHolder holder = new ValidatorHolder(dynamicObject, isImportType);
        holder.addValidator(new IsBasedataBanForBillValidator());
        List<Object> results = ContractSignApplyRepository.getInstance().getInfoByEmp(dynamicObject);
        List applyObjects = (List)results.get(0);
        List contractObjects = (List)results.get(1);
        DynamicObject erManFile = (DynamicObject)results.get(2);
        Map erManFileInfo = (Map)results.get(3);
        String businessType = dynamicObject.getString("businesstype");
        if (HRStringUtils.equals((String)BusinessTypeEnum.NEW.getCombKey(), (String)businessType)) {
            return ContractProtocolValidatorFactory.getEmpProtocolValidatorHolderNew(holder, applyObjects, contractObjects, erManFile, erManFileInfo);
        }
        if (HRStringUtils.equals((String)BusinessTypeEnum.CANCEL.getCombKey(), (String)businessType)) {
            return ContractProtocolValidatorFactory.getEmpProtocolValidatorHolderCancel(holder, applyObjects, contractObjects, erManFile, erManFileInfo);
        }
        if (HRStringUtils.equals((String)BusinessTypeEnum.STOP.getCombKey(), (String)businessType)) {
            return ContractProtocolValidatorFactory.getEmpProtocolValidatorHolderStop(holder, applyObjects, contractObjects, erManFile, erManFileInfo);
        }
        return ContractProtocolValidatorFactory.getCommonValidatorHolder(holder);
    }

    public static Map<DynamicObject, ValidatorHolder> getEmpProtocolBatchValidatorHolder(List<DynamicObject> dynamicObjects, boolean isImportType) {
        ConcurrentHashMap<DynamicObject, ValidatorHolder> resultMap = new ConcurrentHashMap<DynamicObject, ValidatorHolder>();
        Map<DynamicObject, List<Object>> infoListMap = ContractSignApplyRepository.getInstance().getInfoListByEmp(dynamicObjects);
        infoListMap.entrySet().forEach(entry -> {
            DynamicObject dynamicObject = (DynamicObject)entry.getKey();
            List results = (List)entry.getValue();
            ValidatorHolder holder = new ValidatorHolder(dynamicObject, isImportType);
            holder.addValidator(new IsBasedataBanForBillValidator());
            List applyObjects = (List)results.get(0);
            List contractObjects = (List)results.get(1);
            DynamicObject erManFile = (DynamicObject)results.get(2);
            Map erManFileInfo = (Map)results.get(3);
            String businessType = dynamicObject.getString("businesstype");
            if (isImportType) {
                if (!HRStringUtils.equals((String)BusinessTypeEnum.CANCEL.getCombKey(), (String)businessType)) {
                    holder.addValidator(new IsProtocolToBeValueValidator(applyObjects, contractObjects, erManFile, erManFileInfo));
                }
                holder.addValidator(new IsContractValuingValidator(applyObjects, contractObjects, erManFile, erManFileInfo));
                holder.addValidator(new IsContractToBeValueValidator(applyObjects, contractObjects, erManFile, erManFileInfo));
            }
            if (HRStringUtils.equals((String)BusinessTypeEnum.NEW.getCombKey(), (String)businessType)) {
                ValidatorHolder empProtocolValidatorHolderNew = ContractProtocolValidatorFactory.getEmpProtocolValidatorHolderNew(holder, applyObjects, contractObjects, erManFile, erManFileInfo);
                resultMap.put(dynamicObject, empProtocolValidatorHolderNew);
                return;
            }
            if (HRStringUtils.equals((String)BusinessTypeEnum.CANCEL.getCombKey(), (String)businessType)) {
                ValidatorHolder empProtocolValidatorHolderCancel = ContractProtocolValidatorFactory.getEmpProtocolValidatorHolderCancel(holder, applyObjects, contractObjects, erManFile, erManFileInfo);
                resultMap.put(dynamicObject, empProtocolValidatorHolderCancel);
                return;
            }
            if (HRStringUtils.equals((String)BusinessTypeEnum.STOP.getCombKey(), (String)businessType)) {
                ValidatorHolder empProtocolValidatorHolderStop = ContractProtocolValidatorFactory.getEmpProtocolValidatorHolderStop(holder, applyObjects, contractObjects, erManFile, erManFileInfo);
                resultMap.put(dynamicObject, empProtocolValidatorHolderStop);
                return;
            }
            ValidatorHolder commonValidatorHolder = ContractProtocolValidatorFactory.getCommonValidatorHolder(holder);
            resultMap.put(dynamicObject, commonValidatorHolder);
        });
        return resultMap;
    }

    private static ValidatorHolder getEmpProtocolValidatorHolderStop(ValidatorHolder holder, List<DynamicObject> applyObjects, List<DynamicObject> contractObjects, DynamicObject erManFile, Map<String, Object> erManFileInfo) {
        holder.addValidator(new ProtocolCancelDateValidator()).addValidator(new IsEmpProtocolOnValueValidator(applyObjects, contractObjects, erManFile, erManFileInfo)).addValidator(new IsEmpProtocolExistValidator(applyObjects, contractObjects, erManFile, erManFileInfo)).addValidator(new IsProtocolToBeValueValidator(applyObjects, contractObjects, erManFile, erManFileInfo)).addValidator(new IsProtocolNewestValueValidator(applyObjects, contractObjects, erManFile, erManFileInfo)).addValidator(new IsContractCanCancel(applyObjects, contractObjects, erManFile, erManFileInfo));
        return holder;
    }

    private static ValidatorHolder getCommonValidatorHolder(ValidatorHolder holder) {
        holder.addValidator(new IsDateStartEndValidator());
        return holder;
    }

    private static ValidatorHolder getEmpProtocolValidatorHolderNew(ValidatorHolder holder, List<DynamicObject> applyObjects, List<DynamicObject> contractObjects, DynamicObject erManFile, Map<String, Object> erManFileInfo) {
        holder.addValidator(new LicenseCheckForPersonF7Validator()).addValidator(new IsExistsContractNumberValidator()).addValidator(new IsDateStartEndValidator()).addValidator(new IsEmpContractUseStartValidator(erManFileInfo)).addValidator(new IsDateEndSignValidator()).addValidator(new IsEmpProtocolOnValueValidator(applyObjects, contractObjects, erManFile, erManFileInfo)).addValidator(new IsContractInValueValidator(applyObjects, contractObjects, erManFile, erManFileInfo)).addValidator(new IsProtocolCrossValidator(applyObjects, contractObjects, erManFile, erManFileInfo)).addValidator(new HasInitingEmpProtocolValidator(applyObjects, contractObjects, erManFile, erManFileInfo)).addValidator(new IsComptaskValidator());
        return holder;
    }

    private static ValidatorHolder getEmpProtocolValidatorHolderNewTip(ValidatorHolder holder) {
        holder.addValidator(new IsCrossBillsQuitValidator()).addValidator(new IsCrossBillTransfersValidator());
        return holder;
    }

    private static ValidatorHolder getEmpProtocolValidatorHolderCancelTip(ValidatorHolder holder) {
        holder.addValidator(new IsCrossBillsRetireValidator()).addValidator(new IsCrossBillTransfersValidator()).addValidator(new FutureContractValidator());
        return holder;
    }

    private static ValidatorHolder getEmpProtocolValidatorHolderStopTip(ValidatorHolder holder) {
        holder.addValidator(new IsCrossBillsQuitValidator()).addValidator(new IsCrossBillTransfersValidator()).addValidator(new FutureContractValidator());
        return holder;
    }

    private static ValidatorHolder getEmpProtocolValidatorHolderCancel(ValidatorHolder holder, List<DynamicObject> applyObjects, List<DynamicObject> contractObjects, DynamicObject erManFile, Map<String, Object> erManFileInfo) {
        holder.addValidator(new IsTemplateExpiredValidator()).addValidator(new ProtocolCancelDateValidator()).addValidator(new IsEmpProtocolOnValueValidator(applyObjects, contractObjects, erManFile, erManFileInfo)).addValidator(new IsEmpProtocolExistValidator(applyObjects, contractObjects, erManFile, erManFileInfo)).addValidator(new IsProtocolNewestValueValidator(applyObjects, contractObjects, erManFile, erManFileInfo)).addValidator(new checkOldContractSignStatusValidator()).addValidator(new IsContractCanCancel(applyObjects, contractObjects, erManFile, erManFileInfo));
        return holder;
    }

    public static ValidatorHolder getOtherProtocolManualValidatorHolder(DynamicObject dynamicObject, boolean isImportType) {
        ValidatorHolder holder = new ValidatorHolder(dynamicObject, isImportType);
        holder.addValidator(new IsBasedataBanForBillValidator());
        String businessType = dynamicObject.getString("businesstype");
        if (HRStringUtils.equals((String)BusinessTypeEnum.NEW.getCombKey(), (String)businessType)) {
            return ContractProtocolValidatorFactory.getOtherValidatorErrorHolderNew(holder);
        }
        return ContractProtocolValidatorFactory.getCommonValidatorHolder(holder);
    }

    public static Map<DynamicObject, ValidatorHolder> getOtherProtocolBatchValidatorHolder(List<DynamicObject> dynamicObjects, boolean isImportType) {
        ConcurrentHashMap<DynamicObject, ValidatorHolder> resultMap = new ConcurrentHashMap<DynamicObject, ValidatorHolder>();
        dynamicObjects.stream().forEach(dynamicObject -> {
            ValidatorHolder holder = new ValidatorHolder((DynamicObject)dynamicObject, isImportType);
            holder.addValidator(new IsBasedataBanForBillValidator());
            String businessType = dynamicObject.getString("businesstype");
            if (HRStringUtils.equals((String)BusinessTypeEnum.NEW.getCombKey(), (String)businessType)) {
                ValidatorHolder otherValidatorErrorHolderNew = ContractProtocolValidatorFactory.getOtherValidatorErrorHolderNew(holder);
                resultMap.put((DynamicObject)dynamicObject, otherValidatorErrorHolderNew);
                return;
            }
            ValidatorHolder commonValidatorHolder = ContractProtocolValidatorFactory.getCommonValidatorHolder(holder);
            resultMap.put((DynamicObject)dynamicObject, commonValidatorHolder);
        });
        return resultMap;
    }

    private static ValidatorHolder getOtherValidatorErrorHolderNew(ValidatorHolder holder) {
        return holder.addValidator(new IsEmpContractUseStartValidator()).addValidator(new IsExistsContractNumberValidator()).addValidator(new IsDateStartEndValidator()).addValidator(new IsDateEndSignValidator()).addValidator(new IsComptaskValidator());
    }
}

