/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.vaildator;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.domian.repository.ContractSignApplyRepository;
import kd.hr.hlcm.business.vaildator.ContractProtocolValidatorFactory;
import kd.hr.hlcm.business.vaildator.ContractTypeCatValidator;
import kd.hr.hlcm.business.vaildator.FutureContractValidator;
import kd.hr.hlcm.business.vaildator.HasInitingContractValidator;
import kd.hr.hlcm.business.vaildator.ImportContractCancelOtherprotocolValidator;
import kd.hr.hlcm.business.vaildator.ImportContractInputValidator;
import kd.hr.hlcm.business.vaildator.ImportEntryContractDateValidator;
import kd.hr.hlcm.business.vaildator.ImportEntryFixedValidator;
import kd.hr.hlcm.business.vaildator.ImportFixedValidator;
import kd.hr.hlcm.business.vaildator.ImportSignWayValidator;
import kd.hr.hlcm.business.vaildator.IsBasedataBanForBillValidator;
import kd.hr.hlcm.business.vaildator.IsComptaskValidator;
import kd.hr.hlcm.business.vaildator.IsContractCanCancel;
import kd.hr.hlcm.business.vaildator.IsContractExistValidator;
import kd.hr.hlcm.business.vaildator.IsContractInValueValidator;
import kd.hr.hlcm.business.vaildator.IsContractNewestValueValidator;
import kd.hr.hlcm.business.vaildator.IsContractToBeValueValidator;
import kd.hr.hlcm.business.vaildator.IsContractValuingValidator;
import kd.hr.hlcm.business.vaildator.IsContracttypeGroupOther;
import kd.hr.hlcm.business.vaildator.IsCrossBillTransfersValidator;
import kd.hr.hlcm.business.vaildator.IsCrossBillsQuitValidator;
import kd.hr.hlcm.business.vaildator.IsCrossBillsRetireValidator;
import kd.hr.hlcm.business.vaildator.IsDateEndSignValidator;
import kd.hr.hlcm.business.vaildator.IsDateStartEndValidator;
import kd.hr.hlcm.business.vaildator.IsDateStartOldEnd2Validator;
import kd.hr.hlcm.business.vaildator.IsDateStartOldEnd3Validator;
import kd.hr.hlcm.business.vaildator.IsDateStartOldStartValidator;
import kd.hr.hlcm.business.vaildator.IsDateUseStartValidator;
import kd.hr.hlcm.business.vaildator.IsExistsContractNumberValidator;
import kd.hr.hlcm.business.vaildator.IsIDCardValidator;
import kd.hr.hlcm.business.vaildator.IsOrgSameValidator;
import kd.hr.hlcm.business.vaildator.IsProtocolCrossValidator;
import kd.hr.hlcm.business.vaildator.IsProtocolInValueValidator;
import kd.hr.hlcm.business.vaildator.IsProtocolToBeValueOrValuingValidator;
import kd.hr.hlcm.business.vaildator.IsProtocolToBeValueValidator;
import kd.hr.hlcm.business.vaildator.IsProtocolValuingValidator;
import kd.hr.hlcm.business.vaildator.IsSignWayValidator;
import kd.hr.hlcm.business.vaildator.IsTemplateExpiredValidator;
import kd.hr.hlcm.business.vaildator.IsTplConTypeCatValidator;
import kd.hr.hlcm.business.vaildator.LicenseCheckForPersonF7Validator;
import kd.hr.hlcm.business.vaildator.RenewStartEndDateOldContractValidator;
import kd.hr.hlcm.business.vaildator.ValidatorHolder;
import kd.hr.hlcm.business.vaildator.checkOldContractSignStatusValidator;
import kd.hr.hlcm.common.enums.BusinessTypeEnum;
import kd.hr.hlcm.common.enums.CrossTypeEnum;
import kd.hr.hlcm.common.enums.ProtocolTypeEnum;

public class ContractSignValidatorFactory {
    private static final Log LOGGER = LogFactory.getLog(ContractSignValidatorFactory.class);

    public static Map<DynamicObject, ValidatorHolder> getImportValidatorHolderMap(List<DynamicObject> dynamicObjects) {
        Map<DynamicObject, ValidatorHolder> resultMap = new HashMap<DynamicObject, ValidatorHolder>();
        if (CollectionUtils.isEmpty(dynamicObjects)) {
            return resultMap;
        }
        String protocolType = dynamicObjects.get(0).getString("protocoltype");
        ProtocolTypeEnum protocolTypeEnum = ProtocolTypeEnum.getValueByKey((String)protocolType);
        if (ProtocolTypeEnum.CON == protocolTypeEnum) {
            resultMap = ContractSignValidatorFactory.getConBatchValidatorHolder(dynamicObjects, true);
        } else if (ProtocolTypeEnum.YG == protocolTypeEnum) {
            resultMap = ContractProtocolValidatorFactory.getEmpProtocolBatchValidatorHolder(dynamicObjects, true);
        } else if (ProtocolTypeEnum.FS == protocolTypeEnum) {
            resultMap = ContractProtocolValidatorFactory.getOtherProtocolBatchValidatorHolder(dynamicObjects, true);
        } else {
            LOGGER.warn("protocolType|{}", (Object)protocolType);
        }
        if (!CollectionUtils.isEmpty(resultMap)) {
            resultMap.values().forEach(holder -> {
                String pageName = holder.getSignObj().getDataEntityType().getName();
                HashSet pageNames = Sets.newHashSet((Object[])new String[]{"hlcm_contractapplyend", "hlcm_contractapplycancel", "hlcm_empprotocolrelieve"});
                if (!pageNames.contains(pageName)) {
                    holder.addValidator(new ContractTypeCatValidator()).addValidator(new ImportSignWayValidator());
                    holder.addValidator(new ImportFixedValidator());
                }
                holder.addValidator(new IsOrgSameValidator("importtype"));
            });
        }
        return resultMap;
    }

    public static Map<DynamicObject, ValidatorHolder> getManualBatchValidatorHolder(List<DynamicObject> dynamicObjects) {
        Map<DynamicObject, ValidatorHolder> resultMap = new HashMap<DynamicObject, ValidatorHolder>();
        if (CollectionUtils.isEmpty(dynamicObjects)) {
            return resultMap;
        }
        String protocolType = dynamicObjects.get(0).getString("protocoltype");
        ProtocolTypeEnum protocolTypeEnum = ProtocolTypeEnum.getValueByKey((String)protocolType);
        if (ProtocolTypeEnum.CON == protocolTypeEnum) {
            resultMap = ContractSignValidatorFactory.getConBatchValidatorHolder(dynamicObjects, false);
        } else if (ProtocolTypeEnum.YG == protocolTypeEnum) {
            resultMap = ContractProtocolValidatorFactory.getEmpProtocolBatchValidatorHolder(dynamicObjects, false);
        } else if (ProtocolTypeEnum.FS == protocolTypeEnum) {
            resultMap = ContractProtocolValidatorFactory.getOtherProtocolBatchValidatorHolder(dynamicObjects, false);
        } else {
            LOGGER.warn("protocolTypeEnum|{}", (Object)protocolTypeEnum);
        }
        if (!CollectionUtils.isEmpty(resultMap)) {
            resultMap.entrySet().stream().forEach(entry -> {
                DynamicObject dynamicObject = (DynamicObject)entry.getKey();
                ValidatorHolder holder = (ValidatorHolder)entry.getValue();
                String businessType = dynamicObject.getString("businesstype");
                if (HRStringUtils.equals((String)BusinessTypeEnum.NEW.getCombKey(), (String)businessType) || HRStringUtils.equals((String)BusinessTypeEnum.RENEW.getCombKey(), (String)businessType) || HRStringUtils.equals((String)BusinessTypeEnum.CHANGE.getCombKey(), (String)businessType)) {
                    holder.addValidator(new IsIDCardValidator()).addValidator(new IsSignWayValidator()).addValidator(new ContractTypeCatValidator()).addValidator(new IsTplConTypeCatValidator());
                }
            });
        }
        return resultMap;
    }

    public static ValidatorHolder getManualValidatorHolder(DynamicObject dynamicObject) {
        String protocolType = dynamicObject.getString("protocoltype");
        ProtocolTypeEnum protocolTypeEnum = ProtocolTypeEnum.getValueByKey((String)protocolType);
        if (ProtocolTypeEnum.CON == protocolTypeEnum) {
            return ContractSignValidatorFactory.getContractSignValidatorHolder(dynamicObject, false);
        }
        if (ProtocolTypeEnum.YG == protocolTypeEnum) {
            return ContractProtocolValidatorFactory.getEmpProtocolManualValidatorHolder(dynamicObject, false);
        }
        if (ProtocolTypeEnum.FS == protocolTypeEnum) {
            return ContractProtocolValidatorFactory.getOtherProtocolManualValidatorHolder(dynamicObject, false);
        }
        return new ValidatorHolder(dynamicObject, false);
    }

    public static ValidatorHolder getValidatorHolderWeakConfirm(DynamicObject dynamicObject, IPageCache pageCache) {
        String protocolType = dynamicObject.getString("protocoltype");
        ProtocolTypeEnum protocolTypeEnum = ProtocolTypeEnum.getValueByKey((String)protocolType);
        if (ProtocolTypeEnum.CON == protocolTypeEnum) {
            return ContractSignValidatorFactory.getContractSignValidatorHolderWeakConfirm(dynamicObject, pageCache);
        }
        return new ValidatorHolder(dynamicObject);
    }

    private static ValidatorHolder getContractSignValidatorHolder(DynamicObject dynamicObject, boolean isImportType) {
        ValidatorHolder holder = new ValidatorHolder(dynamicObject, isImportType);
        holder.addValidator(new IsBasedataBanForBillValidator());
        List<Object> results = ContractSignApplyRepository.getInstance().getInfoByEmp(dynamicObject);
        List applyObjects = (List)results.get(0);
        List contractObjects = (List)results.get(1);
        DynamicObject erManFile = (DynamicObject)results.get(2);
        Map erManFileInfo = (Map)results.get(3);
        String businessType = dynamicObject.getString("businesstype");
        if (HRStringUtils.equals((String)BusinessTypeEnum.NEW.getCombKey(), (String)businessType)) {
            return ContractSignValidatorFactory.getCommonValidatorHolderNew(holder, applyObjects, contractObjects, erManFile, erManFileInfo);
        }
        if (HRStringUtils.equals((String)BusinessTypeEnum.RENEW.getCombKey(), (String)businessType)) {
            return ContractSignValidatorFactory.getCommonValidatorHolderRenew(holder, applyObjects, contractObjects, erManFile, erManFileInfo);
        }
        if (HRStringUtils.equals((String)BusinessTypeEnum.CHANGE.getCombKey(), (String)businessType)) {
            return ContractSignValidatorFactory.getCommonValidatorHolderChange(holder, applyObjects, contractObjects, erManFile, erManFileInfo);
        }
        if (HRStringUtils.equals((String)BusinessTypeEnum.CANCEL.getCombKey(), (String)businessType)) {
            return ContractSignValidatorFactory.getCommonValidatorHolderCancel(holder, applyObjects, contractObjects, erManFile, erManFileInfo);
        }
        if (HRStringUtils.equals((String)BusinessTypeEnum.STOP.getCombKey(), (String)businessType)) {
            return ContractSignValidatorFactory.getCommonValidatorHolderStop(holder, applyObjects, contractObjects, erManFile, erManFileInfo);
        }
        return ContractSignValidatorFactory.getCommonValidatorHolder(holder, applyObjects, contractObjects, erManFile, erManFileInfo);
    }

    private static Map<DynamicObject, ValidatorHolder> getConBatchValidatorHolder(List<DynamicObject> dynamicObjects, boolean isImportType) {
        ConcurrentHashMap<DynamicObject, ValidatorHolder> resultMap = new ConcurrentHashMap<DynamicObject, ValidatorHolder>();
        Map<DynamicObject, List<Object>> infoListMap = ContractSignApplyRepository.getInstance().getInfoListByEmp(dynamicObjects);
        infoListMap.entrySet().stream().forEach(entry -> {
            DynamicObject dynamicObject = (DynamicObject)entry.getKey();
            List results = (List)entry.getValue();
            ValidatorHolder holder = new ValidatorHolder(dynamicObject, isImportType);
            List applyObjects = (List)results.get(0);
            List contractObjects = (List)results.get(1);
            DynamicObject erManFile = (DynamicObject)results.get(2);
            Map erManFileInfo = (Map)results.get(3);
            String businessType = dynamicObject.getString("businesstype");
            holder.addValidator(new IsBasedataBanForBillValidator());
            if (isImportType) {
                holder.addValidator(new IsContracttypeGroupOther());
                holder.addValidator(new ImportEntryFixedValidator());
                holder.addValidator(new ImportContractInputValidator());
                holder.addValidator(new ImportEntryContractDateValidator());
                holder.addValidator(new ImportContractCancelOtherprotocolValidator());
            }
            if (HRStringUtils.equals((String)BusinessTypeEnum.NEW.getCombKey(), (String)businessType)) {
                ValidatorHolder commonValidatorHolderNew = ContractSignValidatorFactory.getCommonValidatorHolderNew(holder, applyObjects, contractObjects, erManFile, erManFileInfo);
                resultMap.put(dynamicObject, commonValidatorHolderNew);
                return;
            }
            if (HRStringUtils.equals((String)BusinessTypeEnum.RENEW.getCombKey(), (String)businessType)) {
                ValidatorHolder commonValidatorHolderRenew = ContractSignValidatorFactory.getCommonValidatorHolderRenew(holder, applyObjects, contractObjects, erManFile, erManFileInfo);
                resultMap.put(dynamicObject, commonValidatorHolderRenew);
                return;
            }
            if (HRStringUtils.equals((String)BusinessTypeEnum.CHANGE.getCombKey(), (String)businessType)) {
                ValidatorHolder commonValidatorHolderChange = ContractSignValidatorFactory.getCommonValidatorHolderChange(holder, applyObjects, contractObjects, erManFile, erManFileInfo);
                resultMap.put(dynamicObject, commonValidatorHolderChange);
                return;
            }
            if (HRStringUtils.equals((String)BusinessTypeEnum.CANCEL.getCombKey(), (String)businessType)) {
                ValidatorHolder commonValidatorHolderCancel = ContractSignValidatorFactory.getCommonValidatorHolderCancel(holder, applyObjects, contractObjects, erManFile, erManFileInfo);
                resultMap.put(dynamicObject, commonValidatorHolderCancel);
                return;
            }
            if (HRStringUtils.equals((String)BusinessTypeEnum.STOP.getCombKey(), (String)businessType)) {
                ValidatorHolder commonValidatorHolderStop = ContractSignValidatorFactory.getCommonValidatorHolderStop(holder, applyObjects, contractObjects, erManFile, erManFileInfo);
                resultMap.put(dynamicObject, commonValidatorHolderStop);
                return;
            }
            ValidatorHolder commonValidatorHolder = ContractSignValidatorFactory.getCommonValidatorHolder(holder, applyObjects, contractObjects, erManFile, erManFileInfo);
            resultMap.put(dynamicObject, commonValidatorHolder);
        });
        return resultMap;
    }

    private static ValidatorHolder getContractSignValidatorHolderWeakConfirm(DynamicObject dynamicObject, IPageCache pageCache) {
        ValidatorHolder holder = new ValidatorHolder(dynamicObject);
        return ContractSignValidatorFactory.getCommonValidatorHolderWeakConfirm(holder, pageCache, dynamicObject);
    }

    private static ValidatorHolder getCommonValidatorHolderWeakConfirm(ValidatorHolder holder, IPageCache pageCache, DynamicObject dynamicObject) {
        if (HRStringUtils.isEmpty((String)pageCache.get("crossquiteactionId"))) {
            dynamicObject.set("crossaction", (Object)CrossTypeEnum.QUITE.getCode());
            holder.addValidator(new IsCrossBillsQuitValidator());
            return holder;
        }
        if (HRStringUtils.isEmpty((String)pageCache.get("crossretireactionId"))) {
            dynamicObject.set("crossaction", (Object)CrossTypeEnum.RETIRE.getCode());
            holder.addValidator(new IsCrossBillsRetireValidator());
            return holder;
        }
        if (HRStringUtils.isEmpty((String)pageCache.get("crosstransferactionId"))) {
            dynamicObject.set("crossaction", (Object)CrossTypeEnum.TRANSFER.getCode());
            holder.addValidator(new IsCrossBillTransfersValidator());
            return holder;
        }
        if (HRStringUtils.isEmpty((String)pageCache.get("existfutureactionid"))) {
            dynamicObject.set("crossaction", (Object)CrossTypeEnum.EXIST_FUTURE.getCode());
            holder.addValidator(new FutureContractValidator());
            return holder;
        }
        return holder;
    }

    private static ValidatorHolder getCommonValidatorHolderNew(ValidatorHolder holder, List<DynamicObject> applyObjects, List<DynamicObject> contractObjects, DynamicObject erManFile, Map<String, Object> erManFileInfo) {
        holder.addValidator(new LicenseCheckForPersonF7Validator()).addValidator(new IsExistsContractNumberValidator()).addValidator(new IsDateStartEndValidator()).addValidator(new IsDateEndSignValidator()).addValidator(new IsDateUseStartValidator(applyObjects, contractObjects, erManFile, erManFileInfo)).addValidator(new IsContractInValueValidator(applyObjects, contractObjects, erManFile, erManFileInfo)).addValidator(new IsContractToBeValueValidator(applyObjects, contractObjects, erManFile, erManFileInfo)).addValidator(new IsContractValuingValidator(applyObjects, contractObjects, erManFile, erManFileInfo)).addValidator(new IsProtocolInValueValidator(applyObjects, contractObjects, erManFile, erManFileInfo)).addValidator(new IsProtocolToBeValueValidator(applyObjects, contractObjects, erManFile, erManFileInfo)).addValidator(new IsProtocolValuingValidator(applyObjects, contractObjects, erManFile, erManFileInfo)).addValidator(new HasInitingContractValidator(applyObjects, contractObjects, erManFile, erManFileInfo)).addValidator(new IsComptaskValidator());
        return holder;
    }

    private static ValidatorHolder getCommonValidatorHolderRenew(ValidatorHolder holder, List<DynamicObject> applyObjects, List<DynamicObject> contractObjects, DynamicObject erManFile, Map<String, Object> erManFileInfo) {
        holder.addValidator(new IsExistsContractNumberValidator()).addValidator(new IsDateStartEndValidator()).addValidator(new IsDateEndSignValidator()).addValidator(new RenewStartEndDateOldContractValidator()).addValidator(new IsContractInValueValidator(applyObjects, contractObjects, erManFile, erManFileInfo)).addValidator(new IsContractExistValidator(applyObjects, contractObjects, erManFile, erManFileInfo)).addValidator(new IsContractToBeValueValidator(applyObjects, contractObjects, erManFile, erManFileInfo)).addValidator(new IsProtocolToBeValueOrValuingValidator(applyObjects, contractObjects, erManFile, erManFileInfo)).addValidator(new checkOldContractSignStatusValidator()).addValidator(new IsComptaskValidator());
        return holder;
    }

    private static ValidatorHolder getCommonValidatorHolderChange(ValidatorHolder holder, List<DynamicObject> applyObjects, List<DynamicObject> contractObjects, DynamicObject erManFile, Map<String, Object> erManFileInfo) {
        holder.addValidator(new IsExistsContractNumberValidator()).addValidator(new IsDateStartEndValidator()).addValidator(new IsDateEndSignValidator()).addValidator(new IsDateStartOldStartValidator()).addValidator(new IsDateStartOldEnd2Validator()).addValidator(new IsContractInValueValidator(applyObjects, contractObjects, erManFile, erManFileInfo)).addValidator(new IsContractExistValidator(applyObjects, contractObjects, erManFile, erManFileInfo)).addValidator(new IsContractToBeValueValidator(applyObjects, contractObjects, erManFile, erManFileInfo)).addValidator(new checkOldContractSignStatusValidator()).addValidator(new IsComptaskValidator());
        return holder;
    }

    private static ValidatorHolder getCommonValidatorHolderCancel(ValidatorHolder holder, List<DynamicObject> applyObjects, List<DynamicObject> contractObjects, DynamicObject erManFile, Map<String, Object> erManFileInfo) {
        holder.addValidator(new IsDateStartOldEnd3Validator()).addValidator(new IsTemplateExpiredValidator()).addValidator(new IsContractInValueValidator(applyObjects, contractObjects, erManFile, erManFileInfo)).addValidator(new IsContractExistValidator(applyObjects, contractObjects, erManFile, erManFileInfo)).addValidator(new IsContractNewestValueValidator(applyObjects, contractObjects, erManFile, erManFileInfo)).addValidator(new checkOldContractSignStatusValidator()).addValidator(new IsContractCanCancel(applyObjects, contractObjects, erManFile, erManFileInfo));
        return holder;
    }

    private static ValidatorHolder getCommonValidatorHolderStop(ValidatorHolder holder, List<DynamicObject> applyObjects, List<DynamicObject> contractObjects, DynamicObject erManFile, Map<String, Object> erManFileInfo) {
        holder.addValidator(new IsContractInValueValidator(applyObjects, contractObjects, erManFile, erManFileInfo)).addValidator(new IsContractExistValidator(applyObjects, contractObjects, erManFile, erManFileInfo)).addValidator(new IsContractNewestValueValidator(applyObjects, contractObjects, erManFile, erManFileInfo)).addValidator(new checkOldContractSignStatusValidator()).addValidator(new IsDateStartOldEnd3Validator()).addValidator(new IsContractCanCancel(applyObjects, contractObjects, erManFile, erManFileInfo));
        return holder;
    }

    private static ValidatorHolder getCommonValidatorHolder(ValidatorHolder holder, List<DynamicObject> applyObjects, List<DynamicObject> contractObjects, DynamicObject erManFile, Map<String, Object> erManFileInfo) {
        holder.addValidator(new IsDateStartEndValidator()).addValidator(new IsProtocolCrossValidator(applyObjects, contractObjects, erManFile, erManFileInfo));
        return holder;
    }
}

