/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.vaildator;

import java.util.Arrays;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.vaildator.AbstractErrorMsgSignValidator;
import kd.hr.hlcm.common.enums.BusinessTypeEnum;

public class ImportEntryContractDateValidator
extends AbstractErrorMsgSignValidator {
    @Override
    protected String realValidate(DynamicObject dynamicObject) {
        boolean issignprotocol;
        boolean issignother;
        String businessType = dynamicObject.getString("businesstype");
        if (Arrays.asList(BusinessTypeEnum.NEW.getCombKey(), BusinessTypeEnum.RENEW.getCombKey(), BusinessTypeEnum.CHANGE.getCombKey()).contains(businessType) && (issignother = dynamicObject.getBoolean("issignother"))) {
            this.errorMsg = this.importEntryContractDateValidator(dynamicObject);
        }
        if (HRStringUtils.equals((String)BusinessTypeEnum.CANCEL.getCombKey(), (String)businessType) && (issignprotocol = dynamicObject.getBoolean("issignprotocol"))) {
            this.errorMsg = this.importEntryContractDateValidator(dynamicObject);
        }
        return this.errorMsg;
    }

    private String importEntryContractDateValidator(DynamicObject dynamicObject) {
        DynamicObjectCollection entryCol = dynamicObject.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entryCol) {
            Date startDate = entry.getDate("entrystartdate");
            Date endDate = entry.getDate("entryenddate");
            if (startDate == null || endDate == null || !HRDateTimeUtils.dayAfter((Date)startDate, (Date)endDate)) continue;
            return ResManager.loadKDString((String)"\u5206\u5f55\u884c\u4e2d \u201c\u5408\u540c\u5f00\u59cb\u65e5\u671f\u201d\u5e94\u65e9\u4e8e\u7b49\u4e8e\u201c\u5408\u540c\u7ed3\u675f\u65e5\u671f\u201d\u3002", (String)"ImportEntryContractDateValidator_0", (String)"hr-hlcm-business", (Object[])new Object[0]);
        }
        return "";
    }
}

