/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.vaildator;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.vaildator.AbstractErrorMsgSignValidator;
import kd.hr.hlcm.common.enums.BusinessTypeEnum;
import kd.hr.hlcm.common.enums.ContractPeriodTypeEnum;

public class ImportEntryFixedValidator
extends AbstractErrorMsgSignValidator {
    @Override
    protected String realValidate(DynamicObject dynamicObject) {
        boolean issignprotocol;
        boolean issignother;
        String businessType = dynamicObject.getString("businesstype");
        if (Arrays.asList(BusinessTypeEnum.NEW.getCombKey(), BusinessTypeEnum.RENEW.getCombKey(), BusinessTypeEnum.CHANGE.getCombKey()).contains(businessType) && (issignother = dynamicObject.getBoolean("issignother"))) {
            this.errorMsg = this.validateImportFixedMustInput(dynamicObject);
        }
        if (HRStringUtils.equals((String)BusinessTypeEnum.CANCEL.getCombKey(), (String)businessType) && (issignprotocol = dynamicObject.getBoolean("issignprotocol"))) {
            this.errorMsg = this.validateImportFixedMustInput(dynamicObject);
        }
        return this.errorMsg;
    }

    private String validateImportFixedMustInput(DynamicObject dynamicObject) {
        DynamicObjectCollection entryCol = dynamicObject.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entryCol) {
            DynamicObject periodTypeDy = entry.getDynamicObject("entryperiodtype");
            Date endDate = entry.getDate("entryenddate");
            String periodUnit = entry.getString("entryperiodunit");
            BigDecimal period = Optional.ofNullable(entry.getBigDecimal("entryperiod")).orElse(BigDecimal.ZERO);
            Object periodTypeId = periodTypeDy.getPkValue();
            if (Objects.equals(ContractPeriodTypeEnum.FIXED.getPkId(), periodTypeId) && (HRObjectUtils.isEmpty((Object)endDate) || HRObjectUtils.isEmpty((Object)periodUnit) || BigDecimal.ZERO.compareTo(period) == 0)) {
                return ResManager.loadKDString((String)"\u5206\u5f55\u884c\u4e2d\u5982\u679c\u5408\u540c\u671f\u9650\u7c7b\u578b\u4e3a\u201c\u56fa\u5b9a\u671f\u9650\u201d\uff0c\u5408\u540c\u671f\u9650\u3001\u5408\u540c\u671f\u9650\u5355\u4f4d\u3001\u5408\u540c\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ImportEntryFixedValidator_0", (String)"hr-hlcm-business", (Object[])new Object[0]);
            }
            if (!Objects.equals(ContractPeriodTypeEnum.NONFIXED.getPkId(), periodTypeId) || HRObjectUtils.isEmpty((Object)endDate) && HRObjectUtils.isEmpty((Object)periodUnit) && BigDecimal.ZERO.compareTo(period) == 0) continue;
            return ResManager.loadKDString((String)"\u5206\u5f55\u884c\u4e2d\u5408\u540c\u671f\u9650\u7c7b\u578b\u4e3a\u201c\u65e0\u56fa\u5b9a\u671f\u9650\u201d\uff0c\u65e0\u9700\u586b\u5199\u5408\u540c\u671f\u9650\u3001\u5408\u540c\u671f\u9650\u5355\u4f4d\u3001\u5408\u540c\u7ed3\u675f\u65e5\u671f\u3002", (String)"ImportEntryFixedValidator_1", (String)"hr-hlcm-business", (Object[])new Object[0]);
        }
        return "";
    }
}

