/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.vaildator;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hlcm.business.vaildator.AbstractErrorMsgSignValidator;
import kd.hr.hlcm.common.enums.BusinessTypeEnum;
import kd.hr.hlcm.common.enums.ContractPeriodTypeEnum;

public class ImportFixedValidator
extends AbstractErrorMsgSignValidator {
    @Override
    protected String realValidate(DynamicObject dataEntity) {
        this.errorMsg = this.validateImportFixedMustInput(dataEntity).orElse("");
        return this.errorMsg;
    }

    private Optional<String> validateImportFixedMustInput(DynamicObject dataEntity) {
        String businessType = dataEntity.getString("businesstype");
        if (Sets.newHashSet((Object[])new String[]{BusinessTypeEnum.STOP.getCombKey(), BusinessTypeEnum.CANCEL.getCombKey()}).contains(businessType)) {
            return Optional.empty();
        }
        DynamicObject periodTypeDy = dataEntity.getDynamicObject("periodtype");
        Date endDate = dataEntity.getDate("enddate");
        String periodUnit = dataEntity.getString("periodunit");
        BigDecimal period = Optional.ofNullable(dataEntity.getBigDecimal("period")).orElse(BigDecimal.ZERO);
        Object periodTypeId = periodTypeDy.getPkValue();
        if (Objects.equals(ContractPeriodTypeEnum.FIXED.getPkId(), periodTypeId) && (HRObjectUtils.isEmpty((Object)endDate) || HRObjectUtils.isEmpty((Object)periodUnit) || BigDecimal.ZERO.compareTo(period) == 0)) {
            return Optional.ofNullable(ResManager.loadKDString((String)"\u5982\u679c\u5408\u540c\u671f\u9650\u7c7b\u578b\u4e3a\u201c\u56fa\u5b9a\u671f\u9650\u201d\uff0c\u5408\u540c\u671f\u9650\u3001\u5408\u540c\u671f\u9650\u5355\u4f4d\u3001\u5408\u540c\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ImportFixedValidator_1", (String)"hr-hlcm-business", (Object[])new Object[0]));
        }
        if (!(!Objects.equals(ContractPeriodTypeEnum.NONFIXED.getPkId(), periodTypeId) || HRObjectUtils.isEmpty((Object)endDate) && HRObjectUtils.isEmpty((Object)periodUnit) && BigDecimal.ZERO.compareTo(period) == 0)) {
            return Optional.ofNullable(ResManager.loadKDString((String)"\u5408\u540c\u671f\u9650\u7c7b\u578b\u4e3a\u201c\u65e0\u56fa\u5b9a\u671f\u9650\u201d\uff0c\u65e0\u9700\u586b\u5199\u5408\u540c\u671f\u9650\u3001\u5408\u540c\u671f\u9650\u5355\u4f4d\u3001\u5408\u540c\u7ed3\u675f\u65e5\u671f\u3002", (String)"ImportFixedValidator_2", (String)"hr-hlcm-business", (Object[])new Object[0]));
        }
        return Optional.empty();
    }
}

