/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.vaildator;

import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hlcm.business.domian.repository.ContractSignApplyRepository;
import kd.hr.hlcm.business.utils.ContractSignUtils;
import kd.hr.hlcm.business.vaildator.AbstractErrorMsgSignValidator;

public class IsEmpContractUseStartValidator
extends AbstractErrorMsgSignValidator {
    private static final Log LOGGER = LogFactory.getLog(IsEmpContractUseStartValidator.class);

    public IsEmpContractUseStartValidator(Map<String, Object> erManFileInfo) {
        this.erManFileInfo = erManFileInfo;
    }

    public IsEmpContractUseStartValidator() {
    }

    @Override
    protected String realValidate(DynamicObject dynamicObject) {
        Date useStartDate;
        if (this.erManFileInfo == null) {
            long erManFileId = dynamicObject.getDynamicObject("ermanfile").getLong("id");
            Map<String, Object> personInfo = ContractSignUtils.getPersonInfoByErManFile(erManFileId);
            useStartDate = (Date)personInfo.get("startdate");
        } else {
            useStartDate = (Date)this.erManFileInfo.get("startdate");
        }
        if (HRObjectUtils.isEmpty((Object)useStartDate)) {
            return "";
        }
        Date startDate = dynamicObject.getDate("startdate");
        LOGGER.info("IsEmpContractUseStartValidator#realValidate useStartDate:{},startDate:{}", (Object)useStartDate, (Object)startDate);
        this.errorMsg = ContractSignApplyRepository.getInstance().checkEmpContractUseStartDate(startDate, useStartDate);
        return this.errorMsg;
    }
}

