/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.business.vaildator;

import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.extplugin.PluginCall;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.domian.repository.CommonRepository;
import kd.hr.hlcm.business.domian.service.hrcs.IHRCSService;
import kd.hr.hlcm.business.utils.ProxyUtils;
import kd.hr.hlcm.business.vaildator.AbstractErrorMsgSignValidator;
import kd.hr.hlcm.common.enums.SignWayEnum;
import kd.sdk.hr.hlcm.business.domain.validator.ICancelValidate;

public class SignCompanyContractSubjectValidator
extends AbstractErrorMsgSignValidator {
    @Override
    protected String realValidate(DynamicObject dynamicObject) {
        boolean isCancel = ProxyUtils.isCancel((PluginCall<ICancelValidate, Boolean>)((PluginCall)ICancelValidate::isCompanyContractSubjectValidate));
        if (isCancel) {
            return "";
        }
        String signWay = dynamicObject.getString("signway");
        if (!HRStringUtils.equals((String)signWay, (String)SignWayEnum.ELECTRONIC.getCombKey())) {
            return "";
        }
        String actualSignCompanyName = dynamicObject.getDynamicObject("actualsigncompany").getString("name");
        Long lawEntityId = dynamicObject.getLong("actualsigncompany.lawentity.id");
        if (lawEntityId == 0L) {
            this.errorMsg = this.getKDString(actualSignCompanyName);
            return this.errorMsg;
        }
        DynamicObject lawEntity = CommonRepository.queryDynamicObjectByPk("hbss_lawentity", "adminorg", lawEntityId);
        if (HRObjectUtils.isEmpty((Object)lawEntity)) {
            this.errorMsg = this.getKDString(actualSignCompanyName);
            return this.errorMsg;
        }
        DynamicObject adminOrg = lawEntity.getDynamicObject("adminorg");
        if (HRObjectUtils.isEmpty((Object)adminOrg)) {
            this.errorMsg = this.getKDString(actualSignCompanyName);
            return this.errorMsg;
        }
        boolean contSubjectExists = IHRCSService.getInstance().contSubjectExistsNew(adminOrg.getLong("id"), dynamicObject);
        this.errorMsg = contSubjectExists ? "" : this.getKDString(actualSignCompanyName);
        return this.errorMsg;
    }

    private String getKDString(String actualSignCompanyName) {
        return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8058\u7528\u5355\u4f4d%s\u672a\u8fdb\u884c\u7535\u5b50\u7b7e\u7ae0\u5b9e\u540d\u8ba4\u8bc1\u3002", (String)"SignCompanyContractSubjectValidator_0", (String)"hr-hlcm-business", (Object[])new Object[0]), actualSignCompanyName);
    }
}

