/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.common.enums;

import java.util.Arrays;
import java.util.List;
import kd.bos.base.utils.msg.MultiLangEnumBridge;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.common.enums.ActivityTaskStatusEnum;
import kd.hr.hlcm.common.enums.HandleStatusEnum;
import kd.hr.hlcm.common.enums.SignTabEnum;

public enum ActivityStatusEnum {
    E_TO_LAUNCH(SignTabEnum.E_BEGIN, ActivityTaskStatusEnum.getToDoStatusList(), new MultiLangEnumBridge("\u5f85\u53d1\u8d77\u7b7e\u7f72", "ActivityStatusEnum_0", "hr-hlcm-common")),
    P_TO_LAUNCH(SignTabEnum.P_BEGIN, ActivityTaskStatusEnum.getToDoStatusList(), new MultiLangEnumBridge("\u5f85\u53d1\u8d77\u7b7e\u7f72", "ActivityStatusEnum_0", "hr-hlcm-common")),
    E_LUNCHED(SignTabEnum.E_BEGIN, ActivityTaskStatusEnum.getCompletedList(), new MultiLangEnumBridge("\u5df2\u53d1\u8d77\u7b7e\u7f72", "ActivityStatusEnum_1", "hr-hlcm-common")),
    P_LUNCHED(SignTabEnum.P_BEGIN, ActivityTaskStatusEnum.getCompletedList(), new MultiLangEnumBridge("\u5df2\u53d1\u8d77\u7b7e\u7f72", "ActivityStatusEnum_1", "hr-hlcm-common")),
    E_TO_CONFIRM(SignTabEnum.E_CONFIRM, ActivityTaskStatusEnum.getToDoStatusList(), new MultiLangEnumBridge("\u5f85\u5458\u5de5\u786e\u8ba4\u4fe1\u606f\u3002", "ActivityStatusEnum_2", "hr-hlcm-common")),
    E_CONFIRMED(SignTabEnum.E_CONFIRM, ActivityTaskStatusEnum.getCompletedList(), new MultiLangEnumBridge("\u5458\u5de5\u5df2\u786e\u8ba4\u4fe1\u606f", "ActivityStatusEnum_3", "hr-hlcm-common")),
    E_P_TO_SIGN(SignTabEnum.E_ESIGN, ActivityTaskStatusEnum.getToDoStatusList(), new MultiLangEnumBridge("\u5f85\u5458\u5de5\u7b7e\u7f72", "ActivityStatusEnum_4", "hr-hlcm-common")),
    E_P_SIGNED(SignTabEnum.E_ESIGN, ActivityTaskStatusEnum.getCompletedList(), new MultiLangEnumBridge("\u5458\u5de5\u5df2\u7b7e\u7f72", "ActivityStatusEnum_5", "hr-hlcm-common")),
    E_C_TO_SIGN(SignTabEnum.E_CSIGN, ActivityTaskStatusEnum.getToDoStatusList(), new MultiLangEnumBridge("\u5f85\u4f01\u4e1a\u7b7e\u7f72", "ActivityStatusEnum_6", "hr-hlcm-common")),
    E_C_SIGNED(SignTabEnum.E_CSIGN, ActivityTaskStatusEnum.getCompletedList(), new MultiLangEnumBridge("\u4f01\u4e1a\u5df2\u7b7e\u7f72", "ActivityStatusEnum_7", "hr-hlcm-common")),
    P_TO_COMPLETE(SignTabEnum.P_COMP, ActivityTaskStatusEnum.getToDoStatusList(), new MultiLangEnumBridge("\u5f85\u5b8c\u6210\u7b7e\u7f72", "ActivityStatusEnum_8", "hr-hlcm-common")),
    P_COMPLETED(SignTabEnum.P_COMP, ActivityTaskStatusEnum.getCompletedList(), new MultiLangEnumBridge("\u5df2\u5b8c\u6210\u7b7e\u7f72", "ActivityStatusEnum_9", "hr-hlcm-common")),
    E_TO_CHECK(SignTabEnum.E_CHECK, ActivityTaskStatusEnum.getToDoStatusList(), new MultiLangEnumBridge("\u5f85\u6838\u9a8c\u7ed3\u679c", "ActivityStatusEnum_10", "hr-hlcm-common")),
    P_TO_CHECK(SignTabEnum.P_CHECK, ActivityTaskStatusEnum.getToDoStatusList(), new MultiLangEnumBridge("\u5f85\u6838\u9a8c\u7ed3\u679c", "ActivityStatusEnum_10", "hr-hlcm-common")),
    E_CHECKED(SignTabEnum.E_CHECK, ActivityTaskStatusEnum.getCompletedList(), new MultiLangEnumBridge("\u5df2\u6838\u9a8c\u7ed3\u679c", "ActivityStatusEnum_11", "hr-hlcm-common")),
    P_CHECKED(SignTabEnum.P_CHECK, ActivityTaskStatusEnum.getCompletedList(), new MultiLangEnumBridge("\u5df2\u6838\u9a8c\u7ed3\u679c", "ActivityStatusEnum_11", "hr-hlcm-common")),
    TERMINATED(null, null, new MultiLangEnumBridge("\u5df2\u7ec8\u6b62", "ActivityStatusEnum_12", "hr-hlcm-common")),
    ARCHIVE(null, null, new MultiLangEnumBridge("\u5df2\u5f52\u6863", "ActivityStatusEnum_13", "hr-hlcm-common"));

    SignTabEnum signTabEnum;
    List<String> taskStatus;
    MultiLangEnumBridge bridge;

    private ActivityStatusEnum(SignTabEnum signTabEnum, List<String> taskStatus, MultiLangEnumBridge bridge) {
        this.signTabEnum = signTabEnum;
        this.taskStatus = taskStatus;
        this.bridge = bridge;
    }

    @Deprecated
    public String getBindFormId() {
        return this.signTabEnum == null ? null : this.signTabEnum.getSourceListFormId();
    }

    public List<String> getTaskStatuses() {
        return this.taskStatus;
    }

    public String getTaskStatus() {
        return CollectionUtils.isEmpty(this.taskStatus) ? "" : this.taskStatus.get(0);
    }

    public MultiLangEnumBridge getBridge() {
        return this.bridge;
    }

    public String loadKDString() {
        return this.bridge.loadKDString();
    }

    @Deprecated
    public static ActivityStatusEnum getActivityStatusEnum(String handleStatus, String activityFormId, String taskStatus) {
        if (HRStringUtils.equals((String)handleStatus, (String)HandleStatusEnum.PROCESSEND.getCombKey())) {
            return TERMINATED;
        }
        if (HRStringUtils.equals((String)handleStatus, (String)HandleStatusEnum.ARCHIVE.getCombKey())) {
            return ARCHIVE;
        }
        if (HRStringUtils.isNotEmpty((String)activityFormId) && HRStringUtils.isNotEmpty((String)taskStatus)) {
            return Arrays.stream(ActivityStatusEnum.values()).filter(p -> HRStringUtils.equals((String)p.getBindFormId(), (String)activityFormId) && p.getTaskStatuses() != null && p.getTaskStatuses().contains(taskStatus)).findFirst().orElse(null);
        }
        return null;
    }

    public static ActivityStatusEnum getActivityStatusEnum(String handleStatus, Long activityId, String taskStatus) {
        if (HRStringUtils.equals((String)handleStatus, (String)HandleStatusEnum.PROCESSEND.getCombKey())) {
            return TERMINATED;
        }
        if (HRStringUtils.equals((String)handleStatus, (String)HandleStatusEnum.ARCHIVE.getCombKey())) {
            return ARCHIVE;
        }
        SignTabEnum signTabEnum = SignTabEnum.getTabEnumByActivity(activityId);
        if (signTabEnum != null && HRStringUtils.isNotEmpty((String)taskStatus)) {
            return Arrays.stream(ActivityStatusEnum.values()).filter(p -> p.signTabEnum == signTabEnum && p.getTaskStatuses() != null && p.getTaskStatuses().contains(taskStatus)).findFirst().orElse(null);
        }
        return null;
    }
}

