/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.common.utils;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.orm.util.CollectionUtils;

public class LogFilterUtil {
    private static final Set<String> ignoreKey = Sets.newHashSet((Object[])new String[]{"phone", "number", "peremail"});

    public static String getLogStrForMap(Map<String, Object> map, Set<String> forceIncludeKey) {
        if (CollectionUtils.isEmpty(map)) {
            return "";
        }
        HashMap<String, Object> tempMap = new HashMap<String, Object>(map);
        String[] keys = map.keySet().toArray(new String[0]);
        Arrays.stream(keys).forEach(key -> {
            if (!CollectionUtils.isEmpty((Collection)forceIncludeKey) && forceIncludeKey.contains(key)) {
                return;
            }
            if (ignoreKey.contains(key)) {
                tempMap.remove(key);
            }
        });
        return ((Object)tempMap).toString();
    }

    public static String getLogStrForList(List<Map<String, Object>> list) {
        if (CollectionUtils.isEmpty(list)) {
            return "";
        }
        return LogFilterUtil.getLogStrForList(list, null);
    }

    public static String getLogStrForList(List<Map<String, Object>> list, Set<String> forceIncludeKey) {
        if (CollectionUtils.isEmpty(list)) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        list.forEach(map -> str.append(LogFilterUtil.getLogStrForMap(map, forceIncludeKey)));
        return String.format(Locale.ROOT, "[%s]", str.toString());
    }
}

